import unittest
import sys

# --rintan08 /home/severin/Documents/MT1/Code/Benchmarks/gripper/domain.pddl /home/severin/Documents/MT1/Code/Benchmarks/gripper/prob00.pddl --invariant-generation-max-candidates=0
# sys.argv.append("domain")
sys.argv.append("/home/severin/Documents/MT1/Code/Benchmarks/gripper/domain.pddl")
# sys.argv.append("task")
sys.argv.append("/home/severin/Documents/MT1/Code/Benchmarks/gripper/prob00.pddl")
import pddl
from pddl import NegatedAtom, Atom, PropositionalAction
from rin08_invariant_finder import satisfies, resolution, sort_by_string
from rin08_invariant_finder import recurs_and_negate


class TestSatisfiable(unittest.TestCase):

    def setUp(self):
        self.maxDiff = 5000
        self.fn0 = [NegatedAtom(predicate="at-robby", args=["rooma"]),
                    NegatedAtom(predicate="at-robby", args=["roomb"])]
        self.fn1 = [NegatedAtom("carry", ["ball2", "left"]), NegatedAtom("carry", ["ball1", "left"])]
        self.tp = [NegatedAtom("at", ["ball4", "rooma"]), Atom("at", ["ball4", "rooma"])]
        self.fp0 = [NegatedAtom("at", ["ball1", "roomb"])]
        self.fp1 = [NegatedAtom("at", ["ball4", "roomb"]), Atom("at", ["ball4", "rooma"])]

        self.o1 = PropositionalAction(name="(move rooma roomb)", precondition=[Atom("at-robby", ["rooma"])],
                                      effects=[[[], Atom("at-robby", ["roomb"])],
                                               [[], NegatedAtom("at-robby", ["rooma"])]], cost=1)

        self.o2 = PropositionalAction(name="(drop ball1 roomb right)", precondition=[Atom("at-robby", ["roomb"]),
                                                                                     Atom("carry", ["ball1", "right"])],
                                      effects=[[[], Atom("at", ["ball1", "roomb"])],
                                               [[], NegatedAtom("carry", ["ball1", "right"])],
                                               [[], Atom("free", ["right"])]], cost=1)

        self.fp0_o2_rnr = [Atom("at-robby", ["roomb"]), Atom("carry", ["ball1", "right"])]
        self.fn1_ox_rnr = [Atom("carry", ["ball1", "right"])]

        self.kb0 = [
            [NegatedAtom("at-robby", ["rooma"]), NegatedAtom("at-robby", ["roomb"])],
            [NegatedAtom("at", ["ball4", "rooma"]), Atom("at", ["ball4", "rooma"])],
            [NegatedAtom("at", ["ball1", "roomb"])],
            [NegatedAtom("at", ["ball4", "roomb"]), Atom("at", ["ball4", "rooma"])]]

        self.kb1 = [
            [NegatedAtom("free", ["right"]), NegatedAtom("carry", ["ball1", "right"])],
            [Atom("free", ["right"])]]
        # self.kb0= [[<NegatedAtom at(ball1, roomb)>], [<NegatedAtom at(ball2, roomb)>],
        # [<NegatedAtom at(ball1, roomb)>, <Atom at-robby(rooma)>],
        # [<NegatedAtom at-robby(rooma)>, <Atom at-robby(rooma)>],
        # [<NegatedAtom carry(ball1, left)>, <Atom at-robby(rooma)>],
        # [<Atom at-robby(rooma)>, <NegatedAtom at(ball2, roomb)>],
        # [<Atom free(right)>, <Atom at-robby(rooma)>], [<Atom at-robby(rooma)>, <Atom free(left)>], [<Atom at-robby(roomb)>, <Atom at-robby(rooma)>], [<Atom at(ball2, rooma)>, <Atom at-robby(rooma)>], [<Atom at-robby(rooma)>, <NegatedAtom carry(ball2, left)>], [<Atom at-robby(rooma)>, <NegatedAtom carry(ball2, right)>], [<NegatedAtom carry(ball1, right)>, <Atom at-robby(rooma)>], [<Atom at-robby(rooma)>, <Atom at(ball1, rooma)>], [<NegatedAtom at(ball1, roomb)>, <NegatedAtom carry(ball1, left)>], [<NegatedAtom carry(ball1, left)>, <Atom carry(ball1, left)>], [<NegatedAtom carry(ball1, left)>, <NegatedAtom at(ball2, roomb)>], [<NegatedAtom carry(ball1, left)>, <Atom free(right)>], [<NegatedAtom carry(ball1, left)>, <NegatedAtom free(left)>], [<NegatedAtom carry(ball1, left)>, <NegatedAtom at-robby(roomb)>], [<NegatedAtom carry(ball1, left)>, <Atom at(ball2, rooma)>], [<NegatedAtom carry(ball1, left)>, <NegatedAtom carry(ball2, left)>], [<NegatedAtom carry(ball1, left)>, <NegatedAtom carry(ball2, right)>], [<NegatedAtom carry(ball1, right)>, <NegatedAtom carry(ball1, left)>], [<NegatedAtom carry(ball1, left)>, <NegatedAtom at(ball1, rooma)>], [<NegatedAtom at(ball1, roomb)>, <Atom free(right)>], [<Atom free(right)>, <NegatedAtom at(ball2, roomb)>], [<NegatedAtom free(right)>, <Atom free(right)>], [<Atom free(right)>, <Atom free(left)>], [<Atom free(right)>, <NegatedAtom at-robby(roomb)>], [<Atom free(right)>, <NegatedAtom carry(ball2, left)>], [<NegatedAtom at(ball1, roomb)>, <Atom free(left)>], [<Atom free(left)>, <NegatedAtom at(ball2, roomb)>], [<NegatedAtom free(left)>, <Atom free(left)>], [<Atom free(left)>, <NegatedAtom at-robby(roomb)>], [<NegatedAtom carry(ball2, right)>, <Atom free(left)>], [<NegatedAtom carry(ball1, right)>, <Atom free(left)>], [<NegatedAtom at(ball1, roomb)>, <NegatedAtom at-robby(roomb)>], [<NegatedAtom at-robby(rooma)>, <NegatedAtom at-robby(roomb)>], [<NegatedAtom at(ball2, roomb)>, <NegatedAtom at-robby(roomb)>], [<Atom at-robby(roomb)>, <NegatedAtom at-robby(roomb)>], [<Atom at(ball2, rooma)>, <NegatedAtom at-robby(roomb)>], [<NegatedAtom carry(ball2, left)>, <NegatedAtom at-robby(roomb)>], [<NegatedAtom carry(ball2, right)>, <NegatedAtom at-robby(roomb)>], [<NegatedAtom carry(ball1, right)>, <NegatedAtom at-robby(roomb)>], [<Atom at(ball1, rooma)>, <NegatedAtom at-robby(roomb)>], [<NegatedAtom at(ball1, roomb)>, <Atom at(ball2, rooma)>], [<Atom at(ball2, rooma)>, <NegatedAtom at(ball2, roomb)>], [<Atom at(ball2, rooma)>, <NegatedAtom at(ball2, rooma)>], [<NegatedAtom carry(ball1, right)>, <Atom at(ball2, rooma)>], [<Atom at(ball2, rooma)>, <Atom at(ball1, rooma)>], [<NegatedAtom at(ball1, roomb)>, <NegatedAtom carry(ball2, left)>], [<NegatedAtom carry(ball2, left)>, <NegatedAtom at(ball2, roomb)>], [<NegatedAtom free(left)>, <NegatedAtom carry(ball2, left)>], [<NegatedAtom at(ball2, rooma)>, <NegatedAtom carry(ball2, left)>], [<NegatedAtom carry(ball2, left)>, <Atom carry(ball2, left)>], [<NegatedAtom carry(ball2, left)>, <NegatedAtom carry(ball2, right)>], [<NegatedAtom carry(ball1, right)>, <NegatedAtom carry(ball2, left)>], [<Atom at(ball1, rooma)>, <NegatedAtom carry(ball2, left)>], [<NegatedAtom at(ball1, roomb)>, <NegatedAtom carry(ball2, right)>], [<NegatedAtom carry(ball2, right)>, <NegatedAtom at(ball2, roomb)>], [<NegatedAtom free(right)>, <NegatedAtom carry(ball2, right)>], [<NegatedAtom at(ball2, rooma)>, <NegatedAtom carry(ball2, right)>], [<NegatedAtom carry(ball2, right)>, <Atom carry(ball2, right)>], [<NegatedAtom carry(ball1, right)>, <NegatedAtom carry(ball2, right)>], [<Atom at(ball1, rooma)>, <NegatedAtom carry(ball2, right)>], [<NegatedAtom at(ball1, roomb)>, <NegatedAtom carry(ball1, right)>], [<NegatedAtom carry(ball1, right)>, <NegatedAtom at(ball2, roomb)>], [<NegatedAtom free(right)>, <NegatedAtom carry(ball1, right)>], [<NegatedAtom carry(ball1, right)>, <Atom carry(ball1, right)>], [<NegatedAtom carry(ball1, right)>, <NegatedAtom at(ball1, rooma)>], [<NegatedAtom at(ball1, roomb)>, <Atom at(ball1, rooma)>], [<Atom at(ball1, rooma)>, <NegatedAtom at(ball2, roomb)>], [<Atom at(ball1, rooma)>, <NegatedAtom at(ball1, rooma)>], [<NegatedAtom at(ball2, roomb)>, <Atom at-robby(rooma)>], [<Atom at-robby(rooma)>, <Atom free(right)>], [<Atom free(left)>, <Atom at-robby(rooma)>], [<Atom at-robby(rooma)>, <Atom at(ball2, rooma)>], [<NegatedAtom carry(ball2, left)>, <Atom at-robby(rooma)>], [<NegatedAtom carry(ball2, right)>, <Atom at-robby(rooma)>], [<Atom at(ball1, rooma)>, <Atom at-robby(rooma)>], [<NegatedAtom carry(ball1, left)>, <NegatedAtom at(ball1, roomb)>], [<NegatedAtom carry(ball1, left)>, <NegatedAtom carry(ball1, right)>], [<NegatedAtom at(ball2, roomb)>, <Atom free(right)>], [<NegatedAtom carry(ball2, left)>, <Atom free(right)>], [<NegatedAtom at(ball2, roomb)>, <Atom at(ball2, rooma)>], [<NegatedAtom at(ball2, roomb)>, <NegatedAtom carry(ball2, left)>], [<NegatedAtom carry(ball2, left)>, <NegatedAtom carry(ball1, right)>], [<NegatedAtom at(ball2, roomb)>, <NegatedAtom carry(ball2, right)>], [<NegatedAtom at(ball2, roomb)>, <NegatedAtom carry(ball1, right)>]]

        self.resolution_kb_init = [[Atom("free", ["left"])], [NegatedAtom("carry", ["ball1", "left"])],
                                   [Atom("at", ["ball2", "rooma"])], [NegatedAtom("carry", ["ball2", "right"])],
                                   [NegatedAtom("carry", ["ball2", "left"])],
                                   [NegatedAtom("carry", ["ball1", "right"])], [Atom("free", ["right"])],
                                   [Atom("at", ["ball1", "rooma"])], [NegatedAtom("at", ["ball2", "roomb"])],
                                   [NegatedAtom("at", ["ball1", "roomb"])], [NegatedAtom("at-robby", ["roomb"])],
                                   [Atom("at-robby", ["rooma"])]]

        self.resolution_kb_init_result = [[Atom("free", ["left"])], [NegatedAtom("carry", ["ball1", "left"])],
                                          [Atom("at", ["ball2", "rooma"])],
                                          [NegatedAtom("carry", ["ball2", "right"])],
                                          [NegatedAtom("carry", ["ball2", "left"])],
                                          [NegatedAtom("carry", ["ball1", "right"])], [Atom("free", ["right"])],
                                          [Atom("at", ["ball1", "rooma"])], [NegatedAtom("at", ["ball2", "roomb"])],
                                          [NegatedAtom("at", ["ball1", "roomb"])],
                                          [NegatedAtom("at-robby", ["roomb"])], [Atom("at-robby", ["rooma"])]]

        self.resolution_kb_trivially_unfullfil = [[Atom("at-robby", ["rooma"])], [NegatedAtom("free", ["left"])],
                                                  [Atom("free", ["left"])], [NegatedAtom("carry", ["ball1", "left"])],
                                                  [Atom("at", ["ball2", "rooma"])],
                                                  [NegatedAtom("carry", ["ball2", "right"])],
                                                  [NegatedAtom("carry", ["ball2", "left"])],
                                                  [NegatedAtom("carry", ["ball1", "right"])],
                                                  [Atom("free", ["right"])], [Atom("at", ["ball1", "rooma"])],
                                                  [NegatedAtom("at", ["ball2", "roomb"])],
                                                  [NegatedAtom("at", ["ball1", "roomb"])],
                                                  [NegatedAtom("at-robby", ["roomb"])], [Atom("at-robby", ["rooma"])]]

        self.resolution_kb_trivially_fullfil = [[Atom("free", ["left"])], [Atom("at-robby", ["rooma"])],
                                                [Atom("at", ["ball1", "rooma"])],
                                                [Atom("free", ["left"])], [NegatedAtom("carry", ["ball1", "left"])],
                                                [Atom("at", ["ball2", "rooma"])],
                                                [NegatedAtom("carry", ["ball2", "right"])],
                                                [NegatedAtom("carry", ["ball2", "left"])],
                                                [NegatedAtom("carry", ["ball1", "right"])],
                                                [Atom("free", ["right"])], [Atom("at", ["ball1", "rooma"])],
                                                [NegatedAtom("at", ["ball2", "roomb"])],
                                                [NegatedAtom("at", ["ball1", "roomb"])],
                                                [NegatedAtom("at-robby", ["roomb"])], [Atom("at-robby", ["rooma"])]]

        self.resolution_kb_medium = [[NegatedAtom("at", ["ball2", "roomb"])], [NegatedAtom("at", ["ball1", "roomb"])],
                                     [NegatedAtom("at", ["ball2", "roomb"]), Atom("at", ["ball2", "rooma"])],
                                     [NegatedAtom("at", ["ball2", "rooma"]), Atom("at", ["ball2", "rooma"])],
                                     [NegatedAtom("at", ["ball1", "roomb"]), Atom("at", ["ball2", "rooma"])],
                                     [NegatedAtom("at-robby", ["roomb"]), Atom("at", ["ball2", "rooma"])],
                                     [Atom("at", ["ball2", "rooma"]), NegatedAtom("carry", ["ball1", "right"])],
                                     [Atom("at-robby", ["rooma"]), Atom("at", ["ball2", "rooma"])],
                                     [Atom("at", ["ball2", "rooma"]), NegatedAtom("carry", ["ball1", "left"])],
                                     [Atom("at", ["ball1", "rooma"]), Atom("at", ["ball2", "rooma"])],
                                     [NegatedAtom("at", ["ball2", "roomb"]), Atom("free", ["left"])],
                                     [NegatedAtom("free", ["left"]), Atom("free", ["left"])],
                                     [NegatedAtom("carry", ["ball2", "right"]), Atom("free", ["left"])],
                                     [NegatedAtom("at", ["ball1", "roomb"]), Atom("free", ["left"])],
                                     [NegatedAtom("at-robby", ["roomb"]), Atom("free", ["left"])],
                                     [Atom("free", ["right"]), Atom("free", ["left"])],
                                     [Atom("free", ["left"]), NegatedAtom("carry", ["ball1", "right"])],
                                     [Atom("at-robby", ["rooma"]), Atom("free", ["left"])],
                                     [NegatedAtom("carry", ["ball2", "right"]),
                                      NegatedAtom("at", ["ball2", "roomb"])],
                                     [NegatedAtom("carry", ["ball2", "right"]),
                                      NegatedAtom("at", ["ball2", "rooma"])],
                                     [NegatedAtom("carry", ["ball2", "right"]), Atom("carry", ["ball2", "right"])],
                                     [NegatedAtom("carry", ["ball2", "right"]),
                                      NegatedAtom("at", ["ball1", "roomb"])],
                                     [NegatedAtom("carry", ["ball2", "right"]), NegatedAtom("at-robby", ["roomb"])],
                                     [NegatedAtom("carry", ["ball2", "right"]), NegatedAtom("free", ["right"])],
                                     [NegatedAtom("carry", ["ball2", "right"]),
                                      NegatedAtom("carry", ["ball1", "right"])],
                                     [NegatedAtom("carry", ["ball2", "right"]), Atom("at-robby", ["rooma"])],
                                     [NegatedAtom("carry", ["ball2", "right"]),
                                      NegatedAtom("carry", ["ball2", "left"])],
                                     [NegatedAtom("carry", ["ball2", "right"]),
                                      NegatedAtom("carry", ["ball1", "left"])],
                                     [NegatedAtom("carry", ["ball2", "right"]), Atom("at", ["ball1", "rooma"])],
                                     [NegatedAtom("at", ["ball2", "roomb"]), NegatedAtom("at-robby", ["roomb"])],
                                     [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("at", ["ball1", "roomb"])],
                                     [Atom("at-robby", ["roomb"]), NegatedAtom("at-robby", ["roomb"])],
                                     [Atom("free", ["right"]), NegatedAtom("at-robby", ["roomb"])],
                                     [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("carry", ["ball1", "right"])],
                                     [NegatedAtom("at-robby", ["rooma"]), NegatedAtom("at-robby", ["roomb"])],
                                     [NegatedAtom("carry", ["ball2", "left"]), NegatedAtom("at-robby", ["roomb"])],
                                     [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("carry", ["ball1", "left"])],
                                     [Atom("at", ["ball1", "rooma"]), NegatedAtom("at-robby", ["roomb"])],
                                     [Atom("free", ["right"]), NegatedAtom("at", ["ball2", "roomb"])],
                                     [Atom("free", ["right"]), NegatedAtom("at", ["ball1", "roomb"])],
                                     [NegatedAtom("free", ["right"]), Atom("free", ["right"])],
                                     [Atom("free", ["right"]), Atom("at-robby", ["rooma"])],
                                     [Atom("free", ["right"]), NegatedAtom("carry", ["ball2", "left"])],
                                     [Atom("free", ["right"]), NegatedAtom("carry", ["ball1", "left"])],
                                     [NegatedAtom("at", ["ball2", "roomb"]),
                                      NegatedAtom("carry", ["ball1", "right"])],
                                     [NegatedAtom("at", ["ball1", "roomb"]),
                                      NegatedAtom("carry", ["ball1", "right"])],
                                     [NegatedAtom("free", ["right"]), NegatedAtom("carry", ["ball1", "right"])],
                                     [Atom("carry", ["ball1", "right"]), NegatedAtom("carry", ["ball1", "right"])],
                                     [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball1", "right"])],
                                     [NegatedAtom("carry", ["ball2", "left"]),
                                      NegatedAtom("carry", ["ball1", "right"])],
                                     [NegatedAtom("carry", ["ball1", "left"]),
                                      NegatedAtom("carry", ["ball1", "right"])],
                                     [NegatedAtom("at", ["ball1", "rooma"]),
                                      NegatedAtom("carry", ["ball1", "right"])],
                                     [Atom("at-robby", ["rooma"]), NegatedAtom("at", ["ball2", "roomb"])],
                                     [Atom("at-robby", ["rooma"]), NegatedAtom("at", ["ball1", "roomb"])],
                                     [Atom("at-robby", ["roomb"]), Atom("at-robby", ["rooma"])],
                                     [NegatedAtom("at-robby", ["rooma"]), Atom("at-robby", ["rooma"])],
                                     [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball2", "left"])],
                                     [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball1", "left"])],
                                     [Atom("at", ["ball1", "rooma"]), Atom("at-robby", ["rooma"])],
                                     [NegatedAtom("carry", ["ball2", "left"]), NegatedAtom("at", ["ball2", "roomb"])],
                                     [NegatedAtom("at", ["ball2", "rooma"]), NegatedAtom("carry", ["ball2", "left"])],
                                     [NegatedAtom("free", ["left"]), NegatedAtom("carry", ["ball2", "left"])],
                                     [NegatedAtom("carry", ["ball2", "left"]), NegatedAtom("at", ["ball1", "roomb"])],
                                     [Atom("carry", ["ball2", "left"]), NegatedAtom("carry", ["ball2", "left"])],
                                     [NegatedAtom("carry", ["ball2", "left"]),
                                      NegatedAtom("carry", ["ball1", "left"])],
                                     [Atom("at", ["ball1", "rooma"]), NegatedAtom("carry", ["ball2", "left"])],
                                     [NegatedAtom("at", ["ball2", "roomb"]), NegatedAtom("carry", ["ball1", "left"])],
                                     [NegatedAtom("free", ["left"]), NegatedAtom("carry", ["ball1", "left"])],
                                     [NegatedAtom("at", ["ball1", "roomb"]), NegatedAtom("carry", ["ball1", "left"])],
                                     [Atom("carry", ["ball1", "left"]), NegatedAtom("carry", ["ball1", "left"])],
                                     [NegatedAtom("at", ["ball1", "rooma"]), NegatedAtom("carry", ["ball1", "left"])],
                                     [Atom("at", ["ball1", "rooma"]), NegatedAtom("at", ["ball2", "roomb"])],
                                     [Atom("at", ["ball1", "rooma"]), NegatedAtom("at", ["ball1", "roomb"])],
                                     [Atom("at", ["ball1", "rooma"]), NegatedAtom("at", ["ball1", "rooma"])]]

        self.resolution_kb_medium_2 = [[NegatedAtom("at", ["ball2", "roomb"])],
                                       [NegatedAtom("at", ["ball1", "roomb"])],
                                       [NegatedAtom("carry", ["ball1", "left"]), Atom("carry", ["ball1", "left"])],
                                       [NegatedAtom("at", ["ball1", "rooma"]), NegatedAtom("carry", ["ball1", "left"])],
                                       [NegatedAtom("carry", ["ball1", "left"]),
                                        NegatedAtom("carry", ["ball1", "right"])],
                                       [NegatedAtom("carry", ["ball1", "left"]),
                                        NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]), NegatedAtom("carry", ["ball1", "left"])],
                                       [NegatedAtom("carry", ["ball1", "left"]), NegatedAtom("free", ["left"])],
                                       [NegatedAtom("carry", ["ball1", "left"]), Atom("free", ["right"])],
                                       [Atom("at", ["ball2", "rooma"]), NegatedAtom("carry", ["ball1", "left"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]), NegatedAtom("carry", ["ball1", "left"])],
                                       [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball1", "left"])],
                                       [NegatedAtom("carry", ["ball1", "left"]),
                                        NegatedAtom("carry", ["ball2", "left"])],
                                       [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("carry", ["ball1", "left"])],
                                       [NegatedAtom("at", ["ball1", "rooma"]), Atom("at", ["ball1", "rooma"])],
                                       [Atom("at", ["ball1", "rooma"]), NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]), Atom("at", ["ball1", "rooma"])],
                                       [Atom("at", ["ball1", "rooma"]), Atom("at", ["ball2", "rooma"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]), Atom("at", ["ball1", "rooma"])],
                                       [Atom("at-robby", ["rooma"]), Atom("at", ["ball1", "rooma"])],
                                       [Atom("at", ["ball1", "rooma"]), NegatedAtom("carry", ["ball2", "left"])],
                                       [NegatedAtom("at-robby", ["roomb"]), Atom("at", ["ball1", "rooma"])],
                                       [NegatedAtom("at", ["ball1", "rooma"]),
                                        NegatedAtom("carry", ["ball1", "right"])],
                                       [NegatedAtom("carry", ["ball1", "right"]), Atom("carry", ["ball1", "right"])],
                                       [NegatedAtom("carry", ["ball1", "right"]),
                                        NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]),
                                        NegatedAtom("carry", ["ball1", "right"])],
                                       [NegatedAtom("carry", ["ball1", "right"]), Atom("free", ["left"])],
                                       [NegatedAtom("carry", ["ball1", "right"]), NegatedAtom("free", ["right"])],
                                       [Atom("at", ["ball2", "rooma"]), NegatedAtom("carry", ["ball1", "right"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]),
                                        NegatedAtom("carry", ["ball1", "right"])],
                                       [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball1", "right"])],
                                       [NegatedAtom("carry", ["ball1", "right"]),
                                        NegatedAtom("carry", ["ball2", "left"])],
                                       [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("carry", ["ball1", "right"])],
                                       [NegatedAtom("carry", ["ball2", "right"]), Atom("carry", ["ball2", "right"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]),
                                        NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("carry", ["ball2", "right"]), Atom("free", ["left"])],
                                       [NegatedAtom("carry", ["ball2", "right"]), NegatedAtom("free", ["right"])],
                                       [NegatedAtom("at", ["ball2", "rooma"]),
                                        NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]),
                                        NegatedAtom("carry", ["ball2", "right"])],
                                       [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("carry", ["ball2", "left"]),
                                        NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]), Atom("free", ["left"])],
                                       [NegatedAtom("free", ["left"]), Atom("free", ["left"])],
                                       [Atom("free", ["left"]), Atom("free", ["right"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]), Atom("free", ["left"])],
                                       [Atom("at-robby", ["rooma"]), Atom("free", ["left"])],
                                       [NegatedAtom("at-robby", ["roomb"]), Atom("free", ["left"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]), Atom("free", ["right"])],
                                       [NegatedAtom("free", ["right"]), Atom("free", ["right"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]), Atom("free", ["right"])],
                                       [Atom("at-robby", ["rooma"]), Atom("free", ["right"])],
                                       [NegatedAtom("carry", ["ball2", "left"]), Atom("free", ["right"])],
                                       [NegatedAtom("at-robby", ["roomb"]), Atom("free", ["right"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]), Atom("at", ["ball2", "rooma"])],
                                       [NegatedAtom("at", ["ball2", "rooma"]), Atom("at", ["ball2", "rooma"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]), Atom("at", ["ball2", "rooma"])],
                                       [Atom("at-robby", ["rooma"]), Atom("at", ["ball2", "rooma"])],
                                       [NegatedAtom("at-robby", ["roomb"]), Atom("at", ["ball2", "rooma"])],
                                       [Atom("at-robby", ["rooma"]), NegatedAtom("at", ["ball2", "roomb"])],
                                       [Atom("at-robby", ["rooma"]), NegatedAtom("at", ["ball1", "roomb"])],
                                       [NegatedAtom("at-robby", ["rooma"]), Atom("at-robby", ["rooma"])],
                                       [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball2", "left"])],
                                       [Atom("at-robby", ["rooma"]), Atom("at-robby", ["roomb"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]), NegatedAtom("carry", ["ball2", "left"])],
                                       [NegatedAtom("carry", ["ball2", "left"]), NegatedAtom("free", ["left"])],
                                       [NegatedAtom("at", ["ball2", "rooma"]), NegatedAtom("carry", ["ball2", "left"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]), NegatedAtom("carry", ["ball2", "left"])],
                                       [NegatedAtom("carry", ["ball2", "left"]), Atom("carry", ["ball2", "left"])],
                                       [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("carry", ["ball2", "left"])],
                                       [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("at", ["ball2", "roomb"])],
                                       [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("at", ["ball1", "roomb"])],
                                       [NegatedAtom("at-robby", ["rooma"]), NegatedAtom("at-robby", ["roomb"])],
                                       [NegatedAtom("at-robby", ["roomb"]), Atom("at-robby", ["roomb"])]]

        self.resolution_kb_medium_3 = [[NegatedAtom("at", ["ball2", "roomb"])],
                                       [NegatedAtom("at", ["ball1", "roomb"])],
                                       [NegatedAtom("carry", ["ball1", "right"]), Atom("carry", ["ball1", "right"])],
                                       [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("carry", ["ball1", "right"])],
                                       [NegatedAtom("carry", ["ball1", "right"]), NegatedAtom("free", ["right"])],
                                       [NegatedAtom("at", ["ball1", "rooma"]),
                                        NegatedAtom("carry", ["ball1", "right"])],
                                       [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball1", "right"])],
                                       [NegatedAtom("carry", ["ball1", "right"]),
                                        NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("carry", ["ball1", "right"]), Atom("free", ["left"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]),
                                        NegatedAtom("carry", ["ball1", "right"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]),
                                        NegatedAtom("carry", ["ball1", "right"])],
                                       [NegatedAtom("carry", ["ball1", "right"]),
                                        NegatedAtom("carry", ["ball2", "left"])],
                                       [Atom("at", ["ball2", "rooma"]), NegatedAtom("carry", ["ball1", "right"])],
                                       [NegatedAtom("carry", ["ball1", "left"]),
                                        NegatedAtom("carry", ["ball1", "right"])],
                                       [NegatedAtom("at-robby", ["roomb"]), Atom("at-robby", ["roomb"])],
                                       [NegatedAtom("at-robby", ["roomb"]), Atom("free", ["right"])],
                                       [NegatedAtom("at-robby", ["roomb"]), Atom("at", ["ball1", "rooma"])],
                                       [NegatedAtom("at-robby", ["rooma"]), NegatedAtom("at-robby", ["roomb"])],
                                       [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("at-robby", ["roomb"]), Atom("free", ["left"])],
                                       [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("at", ["ball2", "roomb"])],
                                       [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("at", ["ball1", "roomb"])],
                                       [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("carry", ["ball2", "left"])],
                                       [NegatedAtom("at-robby", ["roomb"]), Atom("at", ["ball2", "rooma"])],
                                       [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("carry", ["ball1", "left"])],
                                       [NegatedAtom("free", ["right"]), Atom("free", ["right"])],
                                       [Atom("at-robby", ["rooma"]), Atom("free", ["right"])],
                                       [Atom("free", ["left"]), Atom("free", ["right"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]), Atom("free", ["right"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]), Atom("free", ["right"])],
                                       [NegatedAtom("carry", ["ball2", "left"]), Atom("free", ["right"])],
                                       [NegatedAtom("carry", ["ball1", "left"]), Atom("free", ["right"])],
                                       [NegatedAtom("at", ["ball1", "rooma"]), Atom("at", ["ball1", "rooma"])],
                                       [Atom("at-robby", ["rooma"]), Atom("at", ["ball1", "rooma"])],
                                       [Atom("at", ["ball1", "rooma"]), NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]), Atom("at", ["ball1", "rooma"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]), Atom("at", ["ball1", "rooma"])],
                                       [Atom("at", ["ball1", "rooma"]), NegatedAtom("carry", ["ball2", "left"])],
                                       [Atom("at", ["ball1", "rooma"]), Atom("at", ["ball2", "rooma"])],
                                       [Atom("at-robby", ["rooma"]), Atom("at-robby", ["roomb"])],
                                       [NegatedAtom("at-robby", ["rooma"]), Atom("at-robby", ["rooma"])],
                                       [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball2", "right"])],
                                       [Atom("at-robby", ["rooma"]), Atom("free", ["left"])],
                                       [Atom("at-robby", ["rooma"]), NegatedAtom("at", ["ball2", "roomb"])],
                                       [Atom("at-robby", ["rooma"]), NegatedAtom("at", ["ball1", "roomb"])],
                                       [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball2", "left"])],
                                       [Atom("at-robby", ["rooma"]), Atom("at", ["ball2", "rooma"])],
                                       [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball1", "left"])],
                                       [NegatedAtom("carry", ["ball2", "right"]), NegatedAtom("free", ["right"])],
                                       [NegatedAtom("carry", ["ball2", "right"]), Atom("carry", ["ball2", "right"])],
                                       [NegatedAtom("carry", ["ball2", "right"]), Atom("free", ["left"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]),
                                        NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]),
                                        NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("carry", ["ball2", "left"]),
                                        NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("at", ["ball2", "rooma"]),
                                        NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("carry", ["ball1", "left"]),
                                        NegatedAtom("carry", ["ball2", "right"])],
                                       [NegatedAtom("free", ["left"]), Atom("free", ["left"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]), Atom("free", ["left"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]), Atom("free", ["left"])],
                                       [NegatedAtom("carry", ["ball2", "left"]), NegatedAtom("free", ["left"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]), NegatedAtom("carry", ["ball2", "left"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]), NegatedAtom("carry", ["ball2", "left"])],
                                       [NegatedAtom("carry", ["ball2", "left"]), Atom("carry", ["ball2", "left"])],
                                       [NegatedAtom("at", ["ball2", "rooma"]), NegatedAtom("carry", ["ball2", "left"])],
                                       [NegatedAtom("carry", ["ball1", "left"]),
                                        NegatedAtom("carry", ["ball2", "left"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]), Atom("at", ["ball2", "rooma"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]), Atom("at", ["ball2", "rooma"])],
                                       [NegatedAtom("at", ["ball2", "rooma"]), Atom("at", ["ball2", "rooma"])],
                                       [Atom("at", ["ball2", "rooma"]), NegatedAtom("carry", ["ball1", "left"])],
                                       [NegatedAtom("at", ["ball1", "rooma"]), NegatedAtom("carry", ["ball1", "left"])],
                                       [NegatedAtom("carry", ["ball1", "left"]), NegatedAtom("free", ["left"])],
                                       [NegatedAtom("at", ["ball2", "roomb"]), NegatedAtom("carry", ["ball1", "left"])],
                                       [NegatedAtom("at", ["ball1", "roomb"]), NegatedAtom("carry", ["ball1", "left"])],
                                       [NegatedAtom("carry", ["ball1", "left"]), Atom("carry", ["ball1", "left"])]]

        self.resolution_kb_medium_result = [[NegatedAtom("at", ["ball2", "roomb"])],
                                            [NegatedAtom("at", ["ball1", "roomb"])],
                                            [NegatedAtom("at", ["ball2", "roomb"]), Atom("at", ["ball2", "rooma"])],
                                            [NegatedAtom("at", ["ball2", "rooma"]), Atom("at", ["ball2", "rooma"])],
                                            [NegatedAtom("at", ["ball1", "roomb"]), Atom("at", ["ball2", "rooma"])],
                                            [NegatedAtom("at-robby", ["roomb"]), Atom("at", ["ball2", "rooma"])],
                                            [Atom("at", ["ball2", "rooma"]),
                                             NegatedAtom("carry", ["ball1", "right"])],
                                            [Atom("at-robby", ["rooma"]), Atom("at", ["ball2", "rooma"])],
                                            [Atom("at", ["ball2", "rooma"]), NegatedAtom("carry", ["ball1", "left"])],
                                            [Atom("at", ["ball1", "rooma"]), Atom("at", ["ball2", "rooma"])],
                                            [NegatedAtom("at", ["ball2", "roomb"]), Atom("free", ["left"])],
                                            [NegatedAtom("free", ["left"]), Atom("free", ["left"])],
                                            [NegatedAtom("carry", ["ball2", "right"]), Atom("free", ["left"])],
                                            [NegatedAtom("at", ["ball1", "roomb"]), Atom("free", ["left"])],
                                            [NegatedAtom("at-robby", ["roomb"]), Atom("free", ["left"])],
                                            [Atom("free", ["right"]), Atom("free", ["left"])],
                                            [Atom("free", ["left"]), NegatedAtom("carry", ["ball1", "right"])],
                                            [Atom("at-robby", ["rooma"]), Atom("free", ["left"])],
                                            [NegatedAtom("carry", ["ball2", "right"]),
                                             NegatedAtom("at", ["ball2", "roomb"])],
                                            [NegatedAtom("carry", ["ball2", "right"]),
                                             NegatedAtom("at", ["ball2", "rooma"])],
                                            [NegatedAtom("carry", ["ball2", "right"]),
                                             Atom("carry", ["ball2", "right"])],
                                            [NegatedAtom("carry", ["ball2", "right"]),
                                             NegatedAtom("at", ["ball1", "roomb"])],
                                            [NegatedAtom("carry", ["ball2", "right"]),
                                             NegatedAtom("at-robby", ["roomb"])],
                                            [NegatedAtom("carry", ["ball2", "right"]), NegatedAtom("free", ["right"])],
                                            [NegatedAtom("carry", ["ball2", "right"]),
                                             NegatedAtom("carry", ["ball1", "right"])],
                                            [NegatedAtom("carry", ["ball2", "right"]), Atom("at-robby", ["rooma"])],
                                            [NegatedAtom("carry", ["ball2", "right"]),
                                             NegatedAtom("carry", ["ball2", "left"])],
                                            [NegatedAtom("carry", ["ball2", "right"]),
                                             NegatedAtom("carry", ["ball1", "left"])],
                                            [NegatedAtom("carry", ["ball2", "right"]),
                                             Atom("at", ["ball1", "rooma"])], [NegatedAtom("at", ["ball2", "roomb"]),
                                                                               NegatedAtom("at-robby", ["roomb"])],
                                            [NegatedAtom("at-robby", ["roomb"]),
                                             NegatedAtom("at", ["ball1", "roomb"])],
                                            [Atom("at-robby", ["roomb"]), NegatedAtom("at-robby", ["roomb"])],
                                            [Atom("free", ["right"]), NegatedAtom("at-robby", ["roomb"])],
                                            [NegatedAtom("at-robby", ["roomb"]),
                                             NegatedAtom("carry", ["ball1", "right"])],
                                            [NegatedAtom("at-robby", ["rooma"]), NegatedAtom("at-robby", ["roomb"])],
                                            [NegatedAtom("carry", ["ball2", "left"]),
                                             NegatedAtom("at-robby", ["roomb"])], [NegatedAtom("at-robby", ["roomb"]),
                                                                                   NegatedAtom("carry",
                                                                                               ["ball1", "left"])],
                                            [Atom("at", ["ball1", "rooma"]), NegatedAtom("at-robby", ["roomb"])],
                                            [Atom("free", ["right"]), NegatedAtom("at", ["ball2", "roomb"])],
                                            [Atom("free", ["right"]), NegatedAtom("at", ["ball1", "roomb"])],
                                            [NegatedAtom("free", ["right"]), Atom("free", ["right"])],
                                            [Atom("free", ["right"]), Atom("at-robby", ["rooma"])],
                                            [Atom("free", ["right"]), NegatedAtom("carry", ["ball2", "left"])],
                                            [Atom("free", ["right"]), NegatedAtom("carry", ["ball1", "left"])],
                                            [NegatedAtom("at", ["ball2", "roomb"]),
                                             NegatedAtom("carry", ["ball1", "right"])],
                                            [NegatedAtom("at", ["ball1", "roomb"]),
                                             NegatedAtom("carry", ["ball1", "right"])],
                                            [NegatedAtom("free", ["right"]), NegatedAtom("carry", ["ball1", "right"])],
                                            [Atom("carry", ["ball1", "right"]),
                                             NegatedAtom("carry", ["ball1", "right"])],
                                            [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball1", "right"])],
                                            [NegatedAtom("carry", ["ball2", "left"]),
                                             NegatedAtom("carry", ["ball1", "right"])],
                                            [NegatedAtom("carry", ["ball1", "left"]),
                                             NegatedAtom("carry", ["ball1", "right"])],
                                            [NegatedAtom("at", ["ball1", "rooma"]),
                                             NegatedAtom("carry", ["ball1", "right"])],
                                            [Atom("at-robby", ["rooma"]), NegatedAtom("at", ["ball2", "roomb"])],
                                            [Atom("at-robby", ["rooma"]), NegatedAtom("at", ["ball1", "roomb"])],
                                            [Atom("at-robby", ["roomb"]), Atom("at-robby", ["rooma"])],
                                            [NegatedAtom("at-robby", ["rooma"]), Atom("at-robby", ["rooma"])],
                                            [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball2", "left"])],
                                            [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball1", "left"])],
                                            [Atom("at", ["ball1", "rooma"]), Atom("at-robby", ["rooma"])],
                                            [NegatedAtom("carry", ["ball2", "left"]),
                                             NegatedAtom("at", ["ball2", "roomb"])],
                                            [NegatedAtom("at", ["ball2", "rooma"]),
                                             NegatedAtom("carry", ["ball2", "left"])],
                                            [NegatedAtom("free", ["left"]), NegatedAtom("carry", ["ball2", "left"])],
                                            [NegatedAtom("carry", ["ball2", "left"]),
                                             NegatedAtom("at", ["ball1", "roomb"])],
                                            [Atom("carry", ["ball2", "left"]),
                                             NegatedAtom("carry", ["ball2", "left"])],
                                            [NegatedAtom("carry", ["ball2", "left"]),
                                             NegatedAtom("carry", ["ball1", "left"])],
                                            [Atom("at", ["ball1", "rooma"]), NegatedAtom("carry", ["ball2", "left"])],
                                            [NegatedAtom("at", ["ball2", "roomb"]),
                                             NegatedAtom("carry", ["ball1", "left"])],
                                            [NegatedAtom("free", ["left"]), NegatedAtom("carry", ["ball1", "left"])],
                                            [NegatedAtom("at", ["ball1", "roomb"]),
                                             NegatedAtom("carry", ["ball1", "left"])],
                                            [Atom("carry", ["ball1", "left"]),
                                             NegatedAtom("carry", ["ball1", "left"])],
                                            [NegatedAtom("at", ["ball1", "rooma"]),
                                             NegatedAtom("carry", ["ball1", "left"])],
                                            [Atom("at", ["ball1", "rooma"]), NegatedAtom("at", ["ball2", "roomb"])],
                                            [Atom("at", ["ball1", "rooma"]), NegatedAtom("at", ["ball1", "roomb"])],
                                            [Atom("at", ["ball1", "rooma"]), NegatedAtom("at", ["ball1", "rooma"])],
                                            [NegatedAtom("at", ["ball2", "roomb"]),
                                             NegatedAtom("carry", ["ball2", "right"])],
                                            [NegatedAtom("at", ["ball2", "roomb"]),
                                             NegatedAtom("carry", ["ball2", "left"])],
                                            [NegatedAtom("carry", ["ball1", "right"]),
                                             Atom("at", ["ball2", "rooma"])], [NegatedAtom("at", ["ball1", "roomb"]),
                                                                               NegatedAtom("carry",
                                                                                           ["ball2", "right"])],
                                            [NegatedAtom("at", ["ball1", "roomb"]),
                                             NegatedAtom("carry", ["ball2", "left"])],
                                            [NegatedAtom("at-robby", ["roomb"]),
                                             NegatedAtom("carry", ["ball2", "right"])],
                                            [NegatedAtom("at-robby", ["roomb"]),
                                             NegatedAtom("carry", ["ball2", "left"])],
                                            [NegatedAtom("carry", ["ball1", "right"]),
                                             NegatedAtom("carry", ["ball2", "left"])],
                                            [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball2", "right"])],
                                            [NegatedAtom("carry", ["ball1", "right"]), Atom("free", ["left"])],
                                            [NegatedAtom("carry", ["ball2", "left"]), NegatedAtom("free", ["left"])],
                                            [NegatedAtom("carry", ["ball1", "left"]), NegatedAtom("free", ["left"])],
                                            [NegatedAtom("carry", ["ball1", "right"]),
                                             NegatedAtom("carry", ["ball1", "left"])],
                                            [NegatedAtom("carry", ["ball1", "right"]),
                                             NegatedAtom("carry", ["ball2", "right"])],
                                            [NegatedAtom("at-robby", ["roomb"]),
                                             NegatedAtom("at", ["ball2", "roomb"])],
                                            [NegatedAtom("at-robby", ["roomb"]), Atom("free", ["right"])],
                                            [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("at-robby", ["rooma"])],
                                            [NegatedAtom("at-robby", ["roomb"]), Atom("at", ["ball1", "rooma"])],
                                            [Atom("at-robby", ["rooma"]), Atom("at-robby", ["roomb"])],
                                            [Atom("at-robby", ["rooma"]), Atom("free", ["right"])],
                                            [NegatedAtom("at-robby", ["roomb"]), Atom("at-robby", ["roomb"])],
                                            [Atom("at-robby", ["rooma"]), NegatedAtom("at-robby", ["rooma"])],
                                            [Atom("at-robby", ["rooma"]), Atom("at", ["ball1", "rooma"])],
                                            [NegatedAtom("at", ["ball2", "roomb"]), Atom("free", ["right"])],
                                            [NegatedAtom("at", ["ball1", "roomb"]), Atom("free", ["right"])],
                                            [NegatedAtom("carry", ["ball1", "right"]), NegatedAtom("free", ["right"])],
                                            [NegatedAtom("carry", ["ball1", "left"]),
                                             NegatedAtom("carry", ["ball2", "left"])],
                                            [NegatedAtom("at", ["ball2", "roomb"]), Atom("at", ["ball1", "rooma"])],
                                            [NegatedAtom("at", ["ball1", "roomb"]), Atom("at", ["ball1", "rooma"])]]

        self.resolution_kb_medium_unfullfil = [[Atom("free", ["right"])], [Atom("at-robby", ["rooma"])],
                                               [Atom("at", ["ball1", "rooma"])], [NegatedAtom("free", ["left"])],
                                               [NegatedAtom("at", ["ball2", "roomb"])],
                                               [NegatedAtom("at", ["ball1", "roomb"])],
                                               [NegatedAtom("free", ["left"]), Atom("free", ["left"])],
                                               [Atom("free", ["left"]), NegatedAtom("carry", ["ball2", "right"])],
                                               [Atom("free", ["left"]), NegatedAtom("carry", ["ball1", "right"])],
                                               [Atom("free", ["right"]), Atom("free", ["left"])],
                                               [NegatedAtom("at", ["ball2", "roomb"]), Atom("free", ["left"])],
                                               [NegatedAtom("at", ["ball1", "roomb"]), Atom("free", ["left"])],
                                               [Atom("free", ["left"]), NegatedAtom("at-robby", ["roomb"])],
                                               [Atom("free", ["left"]), Atom("at-robby", ["rooma"])],
                                               [NegatedAtom("free", ["left"]),
                                                NegatedAtom("carry", ["ball1", "left"])],
                                               [NegatedAtom("carry", ["ball1", "left"]),
                                                Atom("carry", ["ball1", "left"])],
                                               [NegatedAtom("carry", ["ball1", "left"]),
                                                Atom("at", ["ball2", "rooma"])],
                                               [NegatedAtom("carry", ["ball1", "left"]),
                                                NegatedAtom("carry", ["ball2", "right"])],
                                               [NegatedAtom("carry", ["ball2", "left"]),
                                                NegatedAtom("carry", ["ball1", "left"])],
                                               [NegatedAtom("carry", ["ball1", "left"]),
                                                NegatedAtom("carry", ["ball1", "right"])],
                                               [Atom("free", ["right"]), NegatedAtom("carry", ["ball1", "left"])],
                                               [NegatedAtom("carry", ["ball1", "left"]),
                                                NegatedAtom("at", ["ball1", "rooma"])],
                                               [NegatedAtom("at", ["ball2", "roomb"]),
                                                NegatedAtom("carry", ["ball1", "left"])],
                                               [NegatedAtom("at", ["ball1", "roomb"]),
                                                NegatedAtom("carry", ["ball1", "left"])],
                                               [NegatedAtom("carry", ["ball1", "left"]),
                                                NegatedAtom("at-robby", ["roomb"])],
                                               [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball1", "left"])],
                                               [Atom("at", ["ball2", "rooma"]),
                                                NegatedAtom("at", ["ball2", "rooma"])],
                                               [NegatedAtom("carry", ["ball1", "right"]),
                                                Atom("at", ["ball2", "rooma"])],
                                               [Atom("at", ["ball1", "rooma"]), Atom("at", ["ball2", "rooma"])],
                                               [NegatedAtom("at", ["ball2", "roomb"]),
                                                Atom("at", ["ball2", "rooma"])],
                                               [NegatedAtom("at", ["ball1", "roomb"]),
                                                Atom("at", ["ball2", "rooma"])],
                                               [NegatedAtom("at-robby", ["roomb"]), Atom("at", ["ball2", "rooma"])],
                                               [Atom("at-robby", ["rooma"]), Atom("at", ["ball2", "rooma"])],
                                               [NegatedAtom("carry", ["ball2", "right"]),
                                                NegatedAtom("at", ["ball2", "rooma"])],
                                               [Atom("carry", ["ball2", "right"]),
                                                NegatedAtom("carry", ["ball2", "right"])],
                                               [NegatedAtom("carry", ["ball2", "left"]),
                                                NegatedAtom("carry", ["ball2", "right"])],
                                               [NegatedAtom("carry", ["ball1", "right"]),
                                                NegatedAtom("carry", ["ball2", "right"])],
                                               [NegatedAtom("free", ["right"]),
                                                NegatedAtom("carry", ["ball2", "right"])],
                                               [Atom("at", ["ball1", "rooma"]),
                                                NegatedAtom("carry", ["ball2", "right"])],
                                               [NegatedAtom("at", ["ball2", "roomb"]),
                                                NegatedAtom("carry", ["ball2", "right"])],
                                               [NegatedAtom("at", ["ball1", "roomb"]),
                                                NegatedAtom("carry", ["ball2", "right"])],
                                               [NegatedAtom("at-robby", ["roomb"]),
                                                NegatedAtom("carry", ["ball2", "right"])],
                                               [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball2", "right"])],
                                               [NegatedAtom("free", ["left"]),
                                                NegatedAtom("carry", ["ball2", "left"])],
                                               [NegatedAtom("carry", ["ball2", "left"]),
                                                NegatedAtom("at", ["ball2", "rooma"])],
                                               [Atom("carry", ["ball2", "left"]),
                                                NegatedAtom("carry", ["ball2", "left"])],
                                               [NegatedAtom("carry", ["ball2", "left"]),
                                                NegatedAtom("carry", ["ball1", "right"])],
                                               [Atom("free", ["right"]), NegatedAtom("carry", ["ball2", "left"])],
                                               [NegatedAtom("carry", ["ball2", "left"]),
                                                Atom("at", ["ball1", "rooma"])],
                                               [NegatedAtom("at", ["ball2", "roomb"]),
                                                NegatedAtom("carry", ["ball2", "left"])],
                                               [NegatedAtom("at", ["ball1", "roomb"]),
                                                NegatedAtom("carry", ["ball2", "left"])],
                                               [NegatedAtom("carry", ["ball2", "left"]),
                                                NegatedAtom("at-robby", ["roomb"])],
                                               [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball2", "left"])],
                                               [NegatedAtom("carry", ["ball1", "right"]),
                                                Atom("carry", ["ball1", "right"])], [NegatedAtom("free", ["right"]),
                                                                                     NegatedAtom("carry",
                                                                                                 ["ball1", "right"])],
                                               [NegatedAtom("carry", ["ball1", "right"]),
                                                NegatedAtom("at", ["ball1", "rooma"])],
                                               [NegatedAtom("at", ["ball2", "roomb"]),
                                                NegatedAtom("carry", ["ball1", "right"])],
                                               [NegatedAtom("at", ["ball1", "roomb"]),
                                                NegatedAtom("carry", ["ball1", "right"])],
                                               [NegatedAtom("carry", ["ball1", "right"]),
                                                NegatedAtom("at-robby", ["roomb"])],
                                               [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball1", "right"])],
                                               [NegatedAtom("free", ["right"]), Atom("free", ["right"])],
                                               [NegatedAtom("at", ["ball2", "roomb"]), Atom("free", ["right"])],
                                               [Atom("free", ["right"]), NegatedAtom("at", ["ball1", "roomb"])],
                                               [Atom("free", ["right"]), NegatedAtom("at-robby", ["roomb"])],
                                               [Atom("free", ["right"]), Atom("at-robby", ["rooma"])],
                                               [Atom("at", ["ball1", "rooma"]),
                                                NegatedAtom("at", ["ball1", "rooma"])],
                                               [NegatedAtom("at", ["ball2", "roomb"]),
                                                Atom("at", ["ball1", "rooma"])],
                                               [NegatedAtom("at", ["ball1", "roomb"]),
                                                Atom("at", ["ball1", "rooma"])],
                                               [Atom("at", ["ball1", "rooma"]), NegatedAtom("at-robby", ["roomb"])],
                                               [Atom("at-robby", ["rooma"]), Atom("at", ["ball1", "rooma"])],
                                               [NegatedAtom("at", ["ball2", "roomb"]),
                                                NegatedAtom("at-robby", ["roomb"])],
                                               [NegatedAtom("at", ["ball1", "roomb"]),
                                                NegatedAtom("at-robby", ["roomb"])],
                                               [NegatedAtom("at-robby", ["roomb"]), Atom("at-robby", ["roomb"])],
                                               [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("at-robby", ["rooma"])],
                                               [NegatedAtom("at", ["ball2", "roomb"]), Atom("at-robby", ["rooma"])],
                                               [NegatedAtom("at", ["ball1", "roomb"]), Atom("at-robby", ["rooma"])],
                                               [Atom("at-robby", ["rooma"]), Atom("at-robby", ["roomb"])],
                                               [Atom("at-robby", ["rooma"]), NegatedAtom("at-robby", ["rooma"])],
                                               [NegatedAtom("carry", ["ball2", "right"]), Atom("free", ["left"])],
                                               [Atom("free", ["left"]), Atom("free", ["right"])],
                                               [Atom("free", ["left"]), NegatedAtom("at", ["ball2", "roomb"])],
                                               [Atom("free", ["left"]), NegatedAtom("at", ["ball1", "roomb"])],
                                               [NegatedAtom("carry", ["ball1", "left"]),
                                                NegatedAtom("free", ["left"])],
                                               [NegatedAtom("carry", ["ball2", "right"]),
                                                NegatedAtom("carry", ["ball2", "left"])],
                                               [NegatedAtom("carry", ["ball1", "left"]), Atom("free", ["right"])],
                                               [NegatedAtom("carry", ["ball1", "left"]),
                                                NegatedAtom("at", ["ball2", "roomb"])],
                                               [NegatedAtom("carry", ["ball1", "left"]),
                                                NegatedAtom("at", ["ball1", "roomb"])],
                                               [NegatedAtom("at-robby", ["roomb"]),
                                                NegatedAtom("carry", ["ball2", "left"])],
                                               [NegatedAtom("carry", ["ball1", "left"]), Atom("at-robby", ["rooma"])],
                                               [NegatedAtom("carry", ["ball1", "left"]),
                                                NegatedAtom("carry", ["ball2", "left"])],
                                               [Atom("at", ["ball2", "rooma"]),
                                                NegatedAtom("carry", ["ball1", "right"])],
                                               [Atom("at", ["ball2", "rooma"]), Atom("at", ["ball1", "rooma"])],
                                               [NegatedAtom("carry", ["ball2", "right"]),
                                                NegatedAtom("carry", ["ball1", "right"])],
                                               [NegatedAtom("carry", ["ball2", "right"]),
                                                Atom("at", ["ball1", "rooma"])],
                                               [NegatedAtom("carry", ["ball2", "right"]),
                                                NegatedAtom("at", ["ball2", "roomb"])],
                                               [NegatedAtom("carry", ["ball2", "right"]),
                                                NegatedAtom("at", ["ball1", "roomb"])],
                                               [NegatedAtom("carry", ["ball2", "right"]),
                                                NegatedAtom("at-robby", ["roomb"])],
                                               [NegatedAtom("carry", ["ball2", "right"]), Atom("at-robby", ["rooma"])],
                                               [NegatedAtom("at", ["ball1", "rooma"]),
                                                NegatedAtom("carry", ["ball1", "right"])],
                                               [NegatedAtom("at-robby", ["roomb"]),
                                                NegatedAtom("carry", ["ball1", "right"])],
                                               [NegatedAtom("at-robby", ["roomb"]), Atom("at", ["ball1", "rooma"])],
                                               [Atom("at-robby", ["rooma"]), NegatedAtom("at", ["ball1", "roomb"])],
                                               [NegatedAtom("at-robby", ["rooma"]), NegatedAtom("at-robby", ["roomb"])],
                                               [NegatedAtom("at-robby", ["rooma"]), Atom("at-robby", ["rooma"])]]

        self.resolution_kb_medium_fullfil = [[Atom("free", ["left"])], [Atom("at-robby", ["rooma"])],
                                             [Atom("at", ["ball1", "rooma"])], [NegatedAtom("free", ["right"])],
                                             [NegatedAtom("at", ["ball2", "roomb"])],
                                             [NegatedAtom("at", ["ball1", "roomb"])],
                                             [NegatedAtom("free", ["left"]), Atom("free", ["left"])],
                                             [Atom("free", ["left"]), NegatedAtom("carry", ["ball2", "right"])],
                                             [Atom("free", ["left"]), NegatedAtom("carry", ["ball1", "right"])],
                                             [Atom("free", ["right"]), Atom("free", ["left"])],
                                             [NegatedAtom("at", ["ball2", "roomb"]), Atom("free", ["left"])],
                                             [NegatedAtom("at", ["ball1", "roomb"]), Atom("free", ["left"])],
                                             [Atom("free", ["left"]), NegatedAtom("at-robby", ["roomb"])],
                                             [Atom("free", ["left"]), Atom("at-robby", ["rooma"])],
                                             [NegatedAtom("free", ["left"]), NegatedAtom("carry", ["ball1", "left"])],
                                             [NegatedAtom("carry", ["ball1", "left"]),
                                              Atom("carry", ["ball1", "left"])],
                                             [NegatedAtom("carry", ["ball1", "left"]),
                                              Atom("at", ["ball2", "rooma"])],
                                             [NegatedAtom("carry", ["ball1", "left"]),
                                              NegatedAtom("carry", ["ball2", "right"])],
                                             [NegatedAtom("carry", ["ball2", "left"]),
                                              NegatedAtom("carry", ["ball1", "left"])],
                                             [NegatedAtom("carry", ["ball1", "left"]),
                                              NegatedAtom("carry", ["ball1", "right"])],
                                             [Atom("free", ["right"]), NegatedAtom("carry", ["ball1", "left"])],
                                             [NegatedAtom("carry", ["ball1", "left"]),
                                              NegatedAtom("at", ["ball1", "rooma"])],
                                             [NegatedAtom("at", ["ball2", "roomb"]),
                                              NegatedAtom("carry", ["ball1", "left"])],
                                             [NegatedAtom("at", ["ball1", "roomb"]),
                                              NegatedAtom("carry", ["ball1", "left"])],
                                             [NegatedAtom("carry", ["ball1", "left"]),
                                              NegatedAtom("at-robby", ["roomb"])],
                                             [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball1", "left"])],
                                             [Atom("at", ["ball2", "rooma"]), NegatedAtom("at", ["ball2", "rooma"])],
                                             [NegatedAtom("carry", ["ball1", "right"]),
                                              Atom("at", ["ball2", "rooma"])],
                                             [Atom("at", ["ball1", "rooma"]), Atom("at", ["ball2", "rooma"])],
                                             [NegatedAtom("at", ["ball2", "roomb"]), Atom("at", ["ball2", "rooma"])],
                                             [NegatedAtom("at", ["ball1", "roomb"]), Atom("at", ["ball2", "rooma"])],
                                             [NegatedAtom("at-robby", ["roomb"]), Atom("at", ["ball2", "rooma"])],
                                             [Atom("at-robby", ["rooma"]), Atom("at", ["ball2", "rooma"])],
                                             [NegatedAtom("carry", ["ball2", "right"]),
                                              NegatedAtom("at", ["ball2", "rooma"])],
                                             [Atom("carry", ["ball2", "right"]),
                                              NegatedAtom("carry", ["ball2", "right"])],
                                             [NegatedAtom("carry", ["ball2", "left"]),
                                              NegatedAtom("carry", ["ball2", "right"])],
                                             [NegatedAtom("carry", ["ball1", "right"]),
                                              NegatedAtom("carry", ["ball2", "right"])],
                                             [NegatedAtom("free", ["right"]),
                                              NegatedAtom("carry", ["ball2", "right"])],
                                             [Atom("at", ["ball1", "rooma"]),
                                              NegatedAtom("carry", ["ball2", "right"])],
                                             [NegatedAtom("at", ["ball2", "roomb"]),
                                              NegatedAtom("carry", ["ball2", "right"])],
                                             [NegatedAtom("at", ["ball1", "roomb"]),
                                              NegatedAtom("carry", ["ball2", "right"])],
                                             [NegatedAtom("at-robby", ["roomb"]),
                                              NegatedAtom("carry", ["ball2", "right"])],
                                             [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball2", "right"])],
                                             [NegatedAtom("free", ["left"]), NegatedAtom("carry", ["ball2", "left"])],
                                             [NegatedAtom("carry", ["ball2", "left"]),
                                              NegatedAtom("at", ["ball2", "rooma"])],
                                             [Atom("carry", ["ball2", "left"]),
                                              NegatedAtom("carry", ["ball2", "left"])],
                                             [NegatedAtom("carry", ["ball2", "left"]),
                                              NegatedAtom("carry", ["ball1", "right"])],
                                             [Atom("free", ["right"]), NegatedAtom("carry", ["ball2", "left"])],
                                             [NegatedAtom("carry", ["ball2", "left"]),
                                              Atom("at", ["ball1", "rooma"])], [NegatedAtom("at", ["ball2", "roomb"]),
                                                                                NegatedAtom("carry",
                                                                                            ["ball2", "left"])],
                                             [NegatedAtom("at", ["ball1", "roomb"]),
                                              NegatedAtom("carry", ["ball2", "left"])],
                                             [NegatedAtom("carry", ["ball2", "left"]),
                                              NegatedAtom("at-robby", ["roomb"])],
                                             [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball2", "left"])],
                                             [NegatedAtom("carry", ["ball1", "right"]),
                                              Atom("carry", ["ball1", "right"])], [NegatedAtom("free", ["right"]),
                                                                                   NegatedAtom("carry",
                                                                                               ["ball1", "right"])],
                                             [NegatedAtom("carry", ["ball1", "right"]),
                                              NegatedAtom("at", ["ball1", "rooma"])],
                                             [NegatedAtom("at", ["ball2", "roomb"]),
                                              NegatedAtom("carry", ["ball1", "right"])],
                                             [NegatedAtom("at", ["ball1", "roomb"]),
                                              NegatedAtom("carry", ["ball1", "right"])],
                                             [NegatedAtom("carry", ["ball1", "right"]),
                                              NegatedAtom("at-robby", ["roomb"])],
                                             [Atom("at-robby", ["rooma"]), NegatedAtom("carry", ["ball1", "right"])],
                                             [NegatedAtom("free", ["right"]), Atom("free", ["right"])],
                                             [NegatedAtom("at", ["ball2", "roomb"]), Atom("free", ["right"])],
                                             [Atom("free", ["right"]), NegatedAtom("at", ["ball1", "roomb"])],
                                             [Atom("free", ["right"]), NegatedAtom("at-robby", ["roomb"])],
                                             [Atom("free", ["right"]), Atom("at-robby", ["rooma"])],
                                             [Atom("at", ["ball1", "rooma"]), NegatedAtom("at", ["ball1", "rooma"])],
                                             [NegatedAtom("at", ["ball2", "roomb"]), Atom("at", ["ball1", "rooma"])],
                                             [NegatedAtom("at", ["ball1", "roomb"]), Atom("at", ["ball1", "rooma"])],
                                             [Atom("at", ["ball1", "rooma"]), NegatedAtom("at-robby", ["roomb"])],
                                             [Atom("at-robby", ["rooma"]), Atom("at", ["ball1", "rooma"])],
                                             [NegatedAtom("at", ["ball2", "roomb"]),
                                              NegatedAtom("at-robby", ["roomb"])],
                                             [NegatedAtom("at", ["ball1", "roomb"]),
                                              NegatedAtom("at-robby", ["roomb"])],
                                             [NegatedAtom("at-robby", ["roomb"]), Atom("at-robby", ["roomb"])],
                                             [NegatedAtom("at-robby", ["roomb"]), NegatedAtom("at-robby", ["rooma"])],
                                             [NegatedAtom("at", ["ball2", "roomb"]), Atom("at-robby", ["rooma"])],
                                             [NegatedAtom("at", ["ball1", "roomb"]), Atom("at-robby", ["rooma"])],
                                             [Atom("at-robby", ["rooma"]), Atom("at-robby", ["roomb"])],
                                             [Atom("at-robby", ["rooma"]), NegatedAtom("at-robby", ["rooma"])],
                                             [NegatedAtom("carry", ["ball2", "right"]), Atom("free", ["left"])],
                                             [Atom("free", ["left"]), Atom("free", ["right"])],
                                             [Atom("free", ["left"]), NegatedAtom("at", ["ball2", "roomb"])],
                                             [Atom("free", ["left"]), NegatedAtom("at", ["ball1", "roomb"])],
                                             [NegatedAtom("carry", ["ball1", "left"]), NegatedAtom("free", ["left"])],
                                             [NegatedAtom("carry", ["ball2", "right"]),
                                              NegatedAtom("carry", ["ball2", "left"])],
                                             [NegatedAtom("carry", ["ball1", "left"]), Atom("free", ["right"])],
                                             [NegatedAtom("carry", ["ball1", "left"]),
                                              NegatedAtom("at", ["ball2", "roomb"])],
                                             [NegatedAtom("carry", ["ball1", "left"]),
                                              NegatedAtom("at", ["ball1", "roomb"])],
                                             [NegatedAtom("at-robby", ["roomb"]),
                                              NegatedAtom("carry", ["ball2", "left"])],
                                             [NegatedAtom("carry", ["ball1", "left"]), Atom("at-robby", ["rooma"])],
                                             [NegatedAtom("carry", ["ball1", "left"]),
                                              NegatedAtom("carry", ["ball2", "left"])],
                                             [Atom("at", ["ball2", "rooma"]),
                                              NegatedAtom("carry", ["ball1", "right"])],
                                             [Atom("at", ["ball2", "rooma"]), Atom("at", ["ball1", "rooma"])],
                                             [NegatedAtom("carry", ["ball2", "right"]),
                                              NegatedAtom("carry", ["ball1", "right"])],
                                             [NegatedAtom("carry", ["ball2", "right"]),
                                              Atom("at", ["ball1", "rooma"])],
                                             [NegatedAtom("carry", ["ball2", "right"]),
                                              NegatedAtom("at", ["ball2", "roomb"])],
                                             [NegatedAtom("carry", ["ball2", "right"]),
                                              NegatedAtom("at", ["ball1", "roomb"])],
                                             [NegatedAtom("carry", ["ball2", "right"]),
                                              NegatedAtom("at-robby", ["roomb"])],
                                             [NegatedAtom("carry", ["ball2", "right"]), Atom("at-robby", ["rooma"])],
                                             [NegatedAtom("at", ["ball1", "rooma"]),
                                              NegatedAtom("carry", ["ball1", "right"])],
                                             [NegatedAtom("at-robby", ["roomb"]),
                                              NegatedAtom("carry", ["ball1", "right"])],
                                             [NegatedAtom("at-robby", ["roomb"]), Atom("at", ["ball1", "rooma"])],
                                             [Atom("at-robby", ["rooma"]), NegatedAtom("at", ["ball1", "roomb"])],
                                             [NegatedAtom("at-robby", ["rooma"]), NegatedAtom("at-robby", ["roomb"])],
                                             [NegatedAtom("at-robby", ["rooma"]), Atom("at-robby", ["rooma"])]]

    def test_resolution_trivial(self):
        # init and trivial
        self.assertEqual(self.resolution_kb_init_result, resolution(self.resolution_kb_init, get_full_kb=True)[1])
        self.assertFalse(
            resolution(self.resolution_kb_trivially_unfullfil, get_full_kb=False, only_check_first=True, length=2)[0])
        self.assertTrue(
            resolution(self.resolution_kb_trivially_fullfil, get_full_kb=False, only_check_first=True, length=2)[0])

    def test_resolution_medium(self):
        # bigger and harder
        res_run = resolution(self.resolution_kb_medium, get_full_kb=True)[1]
        # self.assertEqual(self.resolution_kb_medium_result, res_run)
        res1 = resolution(self.resolution_kb_medium, get_full_kb=True)[1]
        res2 = resolution(self.resolution_kb_medium_2, get_full_kb=True)[1]
        res3 = resolution(self.resolution_kb_medium_3, get_full_kb=True)[1]

        def ll_to_set(ll):
            result = set()
            for l in ll:
                result.add(sort_by_string(l))
            return result

        res1_set = ll_to_set(res1)
        res2_set = ll_to_set(res2)
        print(res2_set.difference(res1_set))
        print("lenght l1:" + str(len(res1)) + "lenght s1:" + str(len(res1_set)) + "lenght l2:" + str(
            len(res2)) + "lenght s2:" + str(len(res2_set)))

        self.assertEqual(res1, res2)

        self.assertEqual(res2, res3)

        self.assertFalse(
            resolution(self.resolution_kb_medium_unfullfil, get_full_kb=False, only_check_first=True, length=2)[0])
        self.assertTrue(
            resolution(self.resolution_kb_medium_fullfil, get_full_kb=False, only_check_first=True, length=2)[0])

    def test_regression(self):
        self.assertEqual(None, recurs_and_negate(self.o1, self.fn0))
        self.assertEqual(self.fp0_o2_rnr, recurs_and_negate(self.o2, self.fp0))

    def test_satisfy(self):
        self.assertTrue(satisfies(self.fp0_o2_rnr, self.kb0))
        self.assertFalse(satisfies(None, self.kb0))

    # def test_satisfy_3wayfalsum(self):
    #     self.assertFalse(satisfies(self.fn1_ox_rnr, self.kb1))

    def aaatest_self(self):
        self.assertEqual('foo'.upper(), 'FOO')
        # check that s.split fails when the separator is not a string
        # with self.assertRaises(TypeError):
        # s.split(2)


if __name__ == '__main__':
    unittest.main()
