#! /usr/bin/env python
#
# Downward Lab uses the Lab package to conduct experiments with the
# Fast Downward planning system.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Regular expressions and functions for parsing translator logs.
"""

import ast
import re
# TODO all the above and authorship etc
from lab.parser import Parser


def parse_statistics(content, props):
    """Parse all translator output of the following form:

        Translator xxx: yyy
    """
    pattern = re.compile(r"^Translator, Invariant (.+): (.+?)(?: KB|)$")
    for line in content.splitlines():
        match = pattern.match(line)
        if match:
            attr = match.group(1).lower().replace(" ", "_")
            # Support strings, numbers, tuples, lists, dicts, booleans, and None.
            props[f"translator_invariant_{attr}"] = ast.literal_eval(match.group(2))
        if line.startswith("Done!"):
            return


class TranslatorInvariantParser(Parser):
    def __init__(self):
        Parser.__init__(self)
        self.add_function(parse_statistics)


if __name__ == "__main__":
    parser = TranslatorInvariantParser()
    parser.parse()
