#! /usr/bin/env python

"""Solve a few STRIPS tasks with A* and the LM-Cut heuristic. Once with Translation done with Helmerts Algorithm from 2009 and once done with Rintans Algorithm from 2008"""

import os
import os.path
import platform

from downward.experiment import FastDownwardExperiment
from downward.reports.absolute import AbsoluteReport
from downward.reports.scatter import ScatterPlotReport
from lab import cached_revision
from lab.environments import BaselSlurmEnvironment, LocalEnvironment

# Addapt filter according to desired comparison (inclusiv or exclusiv)
# "blind","hmax","ipdb","ff","lmcut","merge_and_shrink"
algo = "blind"

filter = ["helmert_" + algo, "rin08_" + algo]
# TODO simplify this settup
fnkt = lambda run: True #filter[0] in run["algorithm"] or filter[1] in run["algorithm"]

ATTRIBUTES = ["cost", "plan_length", "coverage", "error", "total_time", "search_time",
              "evaluations", "expansions", "generated", "generated_until_last_jump", "initial_h_value"]

"""
"translator_time_finding_invariants","translator_invariant_number_of_predicates", "translator_invariant_number_of_objects",
              "translator_invariant_number_of_facts", "translator_invariant_number_of_actions",
              "translator_invariant_number_of_grounded_actions", "translator_invariant_number_of_iterations",
              "translator_invariant_number_of_candidates_considered", "translator_invariant_number_of_found_invariants",
              "translator_invariant_number_of_found_mutexes", "translator_variables", "translator_binary_variables",
              "translator_facts", "translator_operators",
"""

NODE = platform.node()
if NODE.endswith(".scicore.unibas.ch") or NODE.endswith(".cluster.bc2.ch"):
    ENV = BaselSlurmEnvironment(email="severin.wyss@stud.unibas.ch")
else:
    ENV = LocalEnvironment(processes=2)

# If REVISION_CACHE is None, the default ./data/revision-cache is used.
REVISION_CACHE = os.environ.get("DOWNWARD_REVISION_CACHE")

exp = FastDownwardExperiment(environment=ENV, revision_cache=REVISION_CACHE)

# Add built-in parsers to the experiment.
exp.add_parser(exp.EXITCODE_PARSER)
exp.add_parser(exp.TRANSLATOR_PARSER)
exp.add_parser(exp.SINGLE_SEARCH_PARSER)
exp.add_parser(exp.PLANNER_PARSER)

# Add step that collects properties from run directories and
# writes them to *-eval/properties.
# eval_rin08_strips-20_8_27-gripper-eval
# exp.add_fetcher(
#   "/home/sev/MT1/Code/experiments/severin-invariant-comparison/data/strips-20_9_01-search_rin08-translation/adapted_properties",
#  name="translation", merge="False")

"""
    merge doesn't work as you would expect, if False, fails if directory does not exist, meanwhile will not override 
    dir if no data build steps integrated (which in turn fails because there are no algos)
    TODO: fix this in lab
"""
DATA_DIR = os.path.join(os.path.dirname(os.path.abspath(__file__)),"data")
exp.add_fetcher(
    os.path.join(DATA_DIR, "strips-20_8_28-search_rin08-eval"),
    name="fetch_rin08", merge="False", filter=fnkt)
exp.add_fetcher(
    os.path.join(DATA_DIR, "strips-20_8_28-search_helmert-eval"),
    name="fetch_helmert", merge="True", filter=fnkt)

# Add report step (AbsoluteReport is the standard report).
exp.add_report(AbsoluteReport(attributes=ATTRIBUTES), outfile="report.html")

# exp.add_report(
#    AbsoluteReport(attributes=ATTRIBUTES, format="tex"),
#    outfile="report-abs-combined.tex",
# )

# Parse the commandline and show or run experiment steps.
exp.run_steps()
