#! /usr/bin/env python

"""Solve a few STRIPS tasks with A* and the LM-Cut heuristic. Once with Translation done with Helmerts Algorithm
from 2009 and once done with Rintans Algorithm from 2008"""

import os
import os.path
import platform
from collections import defaultdict

from downward.experiment import FastDownwardExperiment
from downward.reports.absolute import AbsoluteReport
from downward.reports.scatter import ScatterPlotReport
from downward.reports.taskwise import TaskwiseReport
from lab import cached_revision
from lab.environments import BaselSlurmEnvironment, LocalEnvironment

NODE = platform.node()
if NODE.endswith(".scicore.unibas.ch") or NODE.endswith(".cluster.bc2.ch"):
    ENV = BaselSlurmEnvironment(email="severin.wyss@stud.unibas.ch")
else:
    ENV = LocalEnvironment(processes=2)
REVISION_CACHE = os.environ.get("DOWNWARD_REVISION_CACHE")
exp = FastDownwardExperiment(environment=ENV, revision_cache=REVISION_CACHE)

# Add built-in parsers to the experiment.
exp.add_parser(exp.EXITCODE_PARSER)
exp.add_parser(exp.TRANSLATOR_PARSER)
exp.add_parser(exp.SINGLE_SEARCH_PARSER)
exp.add_parser(exp.PLANNER_PARSER)

"""
    merge doesn't work as you would expect, if False, fails if directory does not exist, meanwhile will not override 
    dir if no data build steps integrated (which in turn fails because there are no algos)
    TODO: fix this in lab
"""
DATA_DIR = os.path.join(os.path.dirname(os.path.abspath(__file__)), "data")

# TODO cleanup somehow different (more stable etc)
properties_to_be_deleted = os.path.join(DATA_DIR, os.path.splitext(os.path.basename(__file__))[0] + "-eval",
                                        "properties")
print("poperties path: " + str(properties_to_be_deleted))

if os.path.exists(properties_to_be_deleted):
    os.remove(properties_to_be_deleted)

# Addapt filter according to desired comparison (inclusiv or exclusiv)
# "ipdb","merge_and_shrink"

# ATTRIBUTES = ["generated_until_last_jump"]
# evaluations_until_last_jump, generated_until_last_jump, expansions_until_last_jump, search_time
# rin08_ipdb , helmert_ipdb, rin08_merge_and_shrink, helmert_merge_and_shrink
translator = "rin08_"
eval_or_time = "time"
h = "ipdb"  # m erge_and_shrink
input = "t_b_search_both_" + h + "_interesting" + eval_or_time
if "eval" in eval_or_time:
    attrib_eort = "eval_|r-h|)/(r+h)"
else:
    attrib_eort = "time_|r-h|)/(r+h)"

attributes = [attrib_eort, "search_time", "evaluations_until_last_jump", "t_translator_binary_variables",
              "t_translator_facts", "t_translator_operators", "t_translator_variables"]  # ,"","","","","","",""
filter_algorithm = [translator + h]

""" 
translation:
"translator_time_finding_invariants","translator_invariant_number_of_predicates", 
"translator_invariant_number_of_objects", "translator_invariant_number_of_facts", 
"translator_invariant_number_of_actions","translator_invariant_number_of_grounded_actions", 
"translator_invariant_number_of_iterations",
              "translator_invariant_number_of_candidates_considered", "translator_invariant_number_of_found_invariants",
              "translator_invariant_number_of_found_mutexes", "translator_variables", "translator_binary_variables",
              "translator_facts", "translator_operators",

search:
"cost", "plan_length", "coverage", "error", "total_time", "search_time",
              "evaluations", "expansions", "generated", "generated_until_last_jump", "initial_h_value"
"""

"""
dirs:
eval_rin08_strips-20_8_28-cluster-eval
strips-20_9_29-5mallopt-translation-cluster-eval
a_scatter_plot_input
"""
exp.add_fetcher(os.path.join(DATA_DIR, "a_scatter_plot_input", input), name="fetch_translation", merge="False")

exp.add_report(TaskwiseReport(attributes=attributes, filter_algorithm=filter_algorithm),
               outfile=translator + "taskwisereport-" + h + "-" + eval_or_time + ".html")

exp.run_steps()
