// BSC-Thesis.cpp : Defines the entry point for the console application.
//

//----------INCLUDES----------
#include "stdafx.h"
#include <array>
#include <stdio.h>
#include <unordered_map>
#include <vector>
#include <cassert>
#include <iostream>
#include <exception>
#include <fstream>
#include <string> 
#include <sstream>
#include <ctime>
#include <BWAPI.h>
#include <BWAPI/Unittype.h>
// with migwin a hack is required here: the include from BWAPI must be in the include directory of the compiler 
//TODO needed? #include <algorithmfwd.h>
// uncomment to disable assert()
// #define NDEBUG

//MinGW has bug: to_string() does not work under windows
namespace patch{
	template < typename T > std::string to_string(const T& n){
		std::ostringstream stm;
		stm << n;
		return stm.str();
	}

	//TODO template for vector and array to string


}


//----------Macros----------
//comment in release:
//#define DEBUG_SEV
#ifdef DEBUG_SEV
#define DEBUG_ERR(x) (write_text_to_err_file(__FILE__ ,__LINE__ ,"sthm"/*VS2013 does not know this: __func__*/,x ));
#define DEBUG_LOG(x) (write_text_to_log_file(__FILE__ ,__LINE__ ,"sthm"/*VS2013 does not know this: __func__*/,x ));
#else 
#define DEBUG_ERR(x)
#define DEBUG_LOG(x)
#endif

//---------Global------------------
int generatedNodes = 0;
int expandedNodes = 0;

//----------Constants - move to config file in future----------
#define Nmb_Units BWAPI::UnitTypes::Enum::MAX


#define IDLE_TASK -1 //in case of worker this means Mineral gathering
#define Gas_Gathering_TASK -2
#define INF -1
#define NO_PARTNER -1

#define Nmb_Upgrades 10

//Income per worker per frame
#define M_INC 0.045
#define G_INC 0.07

//----------Code----------

//DEBUG_LOG(x)
void write_text_to_log_file(const char* file, const int line, const std::string &func, const std::string &text){
	std::ofstream log_file("log_file.txt", std::ios_base::out | std::ios_base::app);
	log_file << file << " at " << line << " in " << func << " || message: " << text << std::endl;
}
//DEBUG_ERR(x)
void write_text_to_err_file(const char* file, const int line, const std::string &func, const std::string &text){
	std::ofstream log_file("log_file.txt", std::ios_base::out | std::ios_base::app);
	log_file << "ERR" << file << " at " << line << " in " << func << " || message: " << text << std::endl;

	std::ofstream err_file("err_file.txt", std::ios_base::out | std::ios_base::app);
	err_file << file << " at " << line << " in " << func << " || message: " << text << std::endl;
}


class Task{
public:
	int type;
	int timeTillDone;
	Task(){
		//DEBUG_LOG("deault")
		type = -1;
		timeTillDone = -1;
	}
	Task(int ntype, int ntime){
		//DEBUG_LOG("type: " + patch::to_string(ntype) + ", time:" + patch::to_string(ntime));
		type = ntype;
		timeTillDone = ntime;
	}
	std::string toString(){
		return "Task=(t: " + patch::to_string(type) + ", t: " + patch::to_string(timeTillDone) + ")";
	}
};

class Unit{
public:
	int Type;
	int Partner;
	Task task;
	Unit(int ntype, int npartner, Task& ntask){
		DEBUG_LOG("Type: " + patch::to_string(ntype) + " Partner: " + patch::to_string(npartner) + " task: " + ntask.toString())
			Type = ntype;
		Partner = npartner;
		task = ntask;
	}
	Unit(const  Unit & vorbild){
		//DEBUG_LOG("Vorbild wird abgekupfert")
		Type = vorbild.Type;
		Partner = vorbild.Partner;
		task = vorbild.task;
		//DEBUG_LOG(this->toString())
	}
	std::string toString(){
		return "U=(T:" + patch::to_string(Type) + ", P: " + patch::to_string(Partner) + " " + task.toString() + ")";
	}
};


std::string vec_to_string(std::vector<Unit>& n) {
	std::ostringstream stm;

	std::vector<Unit>::iterator pos = n.begin();
	while (pos != n.end()){
		stm << pos->toString();
		pos++;
	}
	return stm.str();
}

class State{
public:
	double Minerals;
	double Gas;
	int frame;
	std::array<bool, Nmb_Upgrades>* upgrades;
	std::vector<Unit> Units;

	State(const double &nminerals, const double& ngas, const int& nframe, std::array<bool, Nmb_Upgrades>* nupades, std::vector<Unit> nuits){
		DEBUG_LOG("State=(Minerals: " + patch::to_string(nminerals) + " Gas: " + patch::to_string(ngas) + " upgrades*: " + patch::to_string(nupades) + " Units*: " + patch::to_string(&nuits) + " containing: " + vec_to_string(nuits) + ")")
			Minerals = nminerals;
		Gas = ngas;
		frame = nframe;
		if (nupades == NULL){ DEBUG_ERR("upgrades are NULL") }
		upgrades = nupades; //TODO is this realy correct!!?? http://stackoverflow.com/questions/16137953/is-there-a-function-to-copy-an-array-in-c-c    probably wrong!!!!!!!!
		if (nuits.size() == 0){ DEBUG_ERR("nuits.size= " + patch::to_string(nuits.size())) };
		Units = nuits;
		DEBUG_LOG(this->toString())
	}
	State(const State & s) :State(s.Minerals, s.Gas, s.frame, s.upgrades, s.Units){
		DEBUG_LOG("generating a state from state")
			DEBUG_LOG(s.toString())
			;
		DEBUG_LOG(this->toString())
	}
	State(const State* s) :State(s->Minerals, s->Gas, s->frame, s->upgrades, s->Units){
		;
		DEBUG_LOG(this->toString())
	}

	State(){
		Minerals = 0;
		Gas = 0;
		frame = 0;
		upgrades = new std::array<bool, Nmb_Upgrades>();
		Units = *(new std::vector<Unit>());
		DEBUG_LOG("Default : " + this->toString())
	}
	std::string  toString()const{
		return "State=(Minerals: " + patch::to_string(Minerals) + " Gas: " + patch::to_string(Gas) + " upgrades*: " + patch::to_string(upgrades) + " Units*: " + patch::to_string(&Units) + " containing: " + ")";
	}
};

class Goal{
public:
	std::array<int, Nmb_Units> * unitsRequiered;// at position: number of requried units
	std::array<bool, Nmb_Upgrades>* upgradesRequiered;
	Goal(std::array<int, Nmb_Units> *UnR, std::array<bool, Nmb_Upgrades> *UpR){
		unitsRequiered = UnR;
		upgradesRequiered = UpR;
	}
	// TODO to string implementieren

	std::string  toString()const{
		return "Goal=(units: " + patch::to_string(unitsRequiered) + " upgrades: " + patch::to_string(upgradesRequiered) + ")";
	}
};

class Action{
private:
	const BWAPI::UnitType::set* Unittypes;//something map Unittype/upgradtype to preconditions and cost   // * to preknowledge
	const BWAPI::UnitType* CreatingUnit;//current!!


	//Tech
	int unitsAvaiability(State &s){
		int ttunitAvaiable = 0;
		//TODO ;//returns time until last needed unit is finished constructed or -1 if never posible
		DEBUG_LOG("fullfilled in :" + patch::to_string(ttunitAvaiable))
			return ttunitAvaiable;
	}
	//Rule

	//idle
	int UnitHasTask(State* s, const std::pair< BWAPI::UnitType, int > type, int task){
		std::pair< BWAPI::UnitType, int > typeInt(type);
		//DEBUG_LOG("looking for type: "+patch::to_string(type)+" task: "+patch::to_string(task))
		int timeTillTaskUnit = -1;
		std::vector<Unit>::iterator pos = s->Units.begin();
		while (pos != s->Units.end()){
			if ((*pos).Type == typeInt.first){
				Task * curT = &(*pos).task;
				if (task == curT->type){
					typeInt.second--;
					if (typeInt.second == 0){
						timeTillTaskUnit = 0;
						break;
					}
				}
				else{
					if (timeTillTaskUnit > curT->timeTillDone || timeTillTaskUnit == -1){
						timeTillTaskUnit = curT->timeTillDone;
					}
				}
			}
			pos++;
		}
		DEBUG_LOG("fullfilled in :" + patch::to_string(timeTillTaskUnit))
			return timeTillTaskUnit;
	}
	//Supply
	int enoughSupply(State* s, const int supply){
		if (supply <= 0){ DEBUG_LOG("trivialy fullfilled: req = 0")return 0; }
		else{
			return 0;
			int ttenoughSupply = -1;
			int consumed = 0;
			std::vector<Unit*> incoming_supplier = {};
			std::vector<Unit>::iterator pos = s->Units.begin();
			int leastTimeTillIdle = 10000000;
			while (pos != s->Units.end()){
				BWAPI::UnitType u = BWAPI::UnitType((*pos).Type);
				consumed -= u.supplyProvided();
				consumed += u.supplyRequired();

				if ((*pos).task.type >= 0){
					BWAPI::UnitType temp = BWAPI::UnitType((*pos).task.type);
					if (temp.supplyRequired() > 0){
						consumed += temp.supplyRequired();
					}
					else{
						incoming_supplier.push_back(&*pos);
						if ((*pos).task.timeTillDone < leastTimeTillIdle){
							leastTimeTillIdle = (*pos).task.timeTillDone;
						}
					}
				}
				pos++;
			}
			consumed -= supply;
			int newsupply = 0;
			int t = 0;
			const int limit = 1000000000;
			int tn = limit;
			int count = 0;
			while (consumed + newsupply < 0 && t != limit){
				std::vector<Unit*>::iterator cur = incoming_supplier.begin();
				while (cur != incoming_supplier.end()){
					if ((*cur)->task.timeTillDone <= t){
						newsupply += BWAPI::UnitType((*cur)->task.type).supplyProvided();
					}
					else{
						if ((*cur)->task.timeTillDone < tn){
							tn = (*cur)->task.timeTillDone;
						}
					}
					cur++;
				}
				t = tn;
				tn = limit;
				newsupply = 0;
				count++;
				assert(count < 1000);
			}
			DEBUG_LOG("fullfilled in: " + patch::to_string(ttenoughSupply))
				return ttenoughSupply;
		}
	}
	//Res
	int enoughMinerals(State* s, const int M){
		if (s->Minerals >= M) return 0;
		//init
		int timeTillMinerals = -1;
		int leastTimeTillIdle = 1000000; //TODO better value, should be high enough for this case
		int curCollectors = 0;
		double stillNeeded = M - s->Minerals;
		std::vector<Unit*> worker_with_task = {};
		std::vector<Unit>::iterator pos = s->Units.begin();
		//DEBUG_LOG("stillNeeded :"+patch::to_string(stillNeeded))
		//over all units
		while (pos != s->Units.end()){
			if ((*pos).Type == BWAPI::UnitTypes::Terran_SCV){
				//only workers
				Task * curT = &(*pos).task;
				if (curT->type == IDLE_TASK){
					curCollectors++;
				}
				else{
					worker_with_task.push_back(&*pos);
					if (curT->timeTillDone < leastTimeTillIdle){
						leastTimeTillIdle = curT->timeTillDone;
					}
				}
			}
			pos++;
		}
		
		if (curCollectors + worker_with_task.size()>0){
			stillNeeded -= curCollectors * leastTimeTillIdle*M_INC;
			//DEBUG_LOG("stillNeeded :"+patch::to_string(stillNeeded))
			timeTillMinerals = leastTimeTillIdle;
			while (stillNeeded > 0){
				DEBUG_LOG("performing while")
					leastTimeTillIdle = 1000000;
				std::vector<Unit*>::iterator posp = worker_with_task.begin();
				while (posp != worker_with_task.end()){
					if ((*posp)->task.timeTillDone > timeTillMinerals && leastTimeTillIdle > (*posp)->task.timeTillDone){
						leastTimeTillIdle = (*posp)->task.timeTillDone;
					}
					if (timeTillMinerals == (*posp)->task.timeTillDone){
						curCollectors++;
					}
					posp++;
				}
				DEBUG_LOG("stillNeeded :" + patch::to_string(stillNeeded))
					stillNeeded -= curCollectors * leastTimeTillIdle*M_INC;
				timeTillMinerals += leastTimeTillIdle;
			}
			//stillNeeded <=0
			//DEBUG_LOG("stillNeeded :"+patch::to_string(stillNeeded)+" curColl: "+patch::to_string(curCollectors) + " result: " +patch::to_string(stillNeeded/(curCollectors*M_INC)))
			int overTime = stillNeeded / (curCollectors*M_INC); //intended conversion, equal to round down ->implicit if(not 0.0) timeTillMinerals++;
			timeTillMinerals += overTime;
			//result
			DEBUG_LOG("fullfilled in :" + patch::to_string(timeTillMinerals))
		}
		else{
			DEBUG_LOG("state with no mineral income: " + s->toString())
		}
		return timeTillMinerals;
	}
	//TODOO both min and gas might be wrong - to long time maybe? timetillres =leasttimetililde
	int enoughGas(State* s, const int G){
		if (s->Gas >= G) return 0;
		return -1;
		const std::pair< BWAPI::UnitType, int > temp(BWAPI::UnitTypes::Enum::Terran_SCV, 1);
		if (-1 == UnitHasTask(s, temp, Gas_Gathering_TASK) && -1 == UnitHasTask(s, temp, BWAPI::UnitTypes::Terran_Refinery)){
			DEBUG_LOG("state with no gas income: " + s->toString()); return -1;
		}
		int timeTillGas = -1;
		int leastTimeTillIdle = 1000000; //TODO better value, should be high enough for this case
		int curCollectors = 0;
		double stillNeeded = G - s->Gas;
		std::vector<Unit*> worker_with_task = {};
		std::vector<Unit>::iterator pos = s->Units.begin();

		while (pos != s->Units.end()){
			if ((*pos).Type == BWAPI::UnitTypes::Terran_SCV){
				//only workers
				Task * curT = &(*pos).task;
				if (curT->type == Gas_Gathering_TASK){
					curCollectors++;
				}
				else{
					if (curT->type == BWAPI::UnitTypes::Terran_Refinery){
						worker_with_task.push_back(&*pos);
						if (curT->timeTillDone < leastTimeTillIdle){
							leastTimeTillIdle = curT->timeTillDone;
						}
					}
				}
			}
			pos++;
		}
		stillNeeded -= curCollectors * leastTimeTillIdle*G_INC;
		//DEBUG_LOG("stillNeeded :"+patch::to_string(stillNeeded))
		timeTillGas = leastTimeTillIdle;
		while (stillNeeded > 0){
			DEBUG_LOG("performing while")
			leastTimeTillIdle = 1000000;
			std::vector<Unit*>::iterator posp = worker_with_task.begin();
			while (posp != worker_with_task.end()){
				if ((*posp)->task.timeTillDone > timeTillGas && leastTimeTillIdle > (*posp)->task.timeTillDone){
					leastTimeTillIdle = (*posp)->task.timeTillDone;
				}
				if (timeTillGas == (*posp)->task.timeTillDone){
					curCollectors+=3;
				}
				posp++;
			}
			DEBUG_LOG("stillNeeded :" + patch::to_string(stillNeeded))
			stillNeeded -= curCollectors * leastTimeTillIdle*G_INC;
			timeTillGas += leastTimeTillIdle;
		}

		DEBUG_LOG("fullfilled in :" + patch::to_string(timeTillMinerals))
		return timeTillGas;
		//TODO not that easy sorry
	}
	//--------------------------------------------
	//effects
	State* fastForward(const State* s, int fastForwardTime){
		State* next = new State(s);
		DEBUG_LOG("fast forward uses: " + next->toString() + " for time: " + patch::to_string(fastForwardTime))
			if (fastForwardTime != 0){
				assert(fastForwardTime > 0);

				DEBUG_LOG("next->units size: " + patch::to_string(next->Units.size()))
				std::vector<Unit>::iterator pos = next->Units.begin();
				std::vector<Unit>* babies = new std::vector<Unit>();
				double remainingTime = 0.0;
				int doubleCheck = next->Units.size();
				while (pos != next->Units.end()){
					assert(doubleCheck >= 0);
					if ((*pos).task.type == IDLE_TASK || (*pos).task.type == Gas_Gathering_TASK){
						remainingTime = fastForwardTime;
					}else{
						if ((*pos).task.timeTillDone <= fastForwardTime){
							Task idleTask{ IDLE_TASK, INF };
							Unit* baby = new Unit((*pos).task.type, NO_PARTNER, idleTask);
							DEBUG_LOG(baby->toString())
							babies->push_back(*baby);
							remainingTime = fastForwardTime - (*pos).task.timeTillDone;
							(*pos).task.timeTillDone = INF;
							(*pos).task.type = IDLE_TASK;
						}else{
							remainingTime = 0.0;
						}
					}
					DEBUG_LOG("itertesting: " + next->toString())
						//provide income if worker is doing smth
						//TODO double check baby logic
						if (((*pos).Type == BWAPI::UnitTypes::Terran_SCV || (*pos).task.type == BWAPI::UnitTypes::Terran_SCV)&& remainingTime > 0.0){
							if ((*pos).task.type == IDLE_TASK){
								next->Minerals += M_INC * remainingTime;
							}
							if ((*pos).task.type == Gas_Gathering_TASK){
								next->Gas += G_INC * remainingTime;
							}
						}
					pos++;
					doubleCheck--;
				}
				next->Units.insert(next->Units.end(), babies->begin(), babies->end());
			}
		DEBUG_LOG("fast forward produced: " + next->toString())
			return next;
	}//returns s', state after fast Forward effect (not successor!)
	State* consumeResources(State* next, const int type){
		next->Minerals -= Unittypes->find(type)->mineralPrice();
		next->Gas -= Unittypes->find(type)->gasPrice();
		DEBUG_LOG("state after consumed resources: " + next->toString())
			if (next->Minerals<0){
				DEBUG_ERR("eps danger")
			}
			assert(next->Minerals >= -0.0001);
			assert(next->Gas >= -0.0001);
		return next;
	}

	State* giveTask(State* next, const int builder){
		//TODO not consistend, does not give any task, but only start the creation of the unit the action stands for
		DEBUG_LOG("CONFIRMED THIS IS USSED -----------------")
			std::vector<Unit>::iterator pos = next->Units.begin();
		while (pos != next->Units.end()){
			if ((*pos).Type == builder){
				Task * curT = &(*pos).task;
				if (curT->type == IDLE_TASK){
					int bt = Unittypes->find(*CreatingUnit)->buildTime();
					if (builder == BWAPI::UnitTypes::Terran_SCV){
						bt += 96;
					}
					*curT = Task(*CreatingUnit, bt);
					return next;
				}
			}
			pos++;
		}
		DEBUG_LOG("should not get here")
		assert(false);
		return NULL; //Should never be reached - conditionchck befor applied
	}//only one int, the other must be null
	//preconditions
	int preconditionsFullfilled(State& s){
		int t = unitsAvaiability(s);
		int temp = UnitHasTask(&s, CreatingUnit->whatBuilds(), IDLE_TASK);//Unittypes->find(type)
		if ((t < temp && t>-1) || temp == -1) t = temp;
		temp = enoughSupply(&s, CreatingUnit->supplyRequired());
		if ((t < temp && t>-1) || temp == -1) t = temp;
		temp = enoughMinerals(&s, CreatingUnit->mineralPrice());
		if ((t < temp && t>-1) || temp == -1) t = temp;
		temp = enoughGas(&s, CreatingUnit->gasPrice());
		if ((t < temp && t>-1) || temp == -1) t = temp;
		return t;
	}// returns time until unit can be build or -1 if impossible
public:
	int getSuccessor(State& parent, State** next){
		DEBUG_LOG("action starts successor generation: " + this->toString())
			int t = preconditionsFullfilled(parent);
		DEBUG_LOG("preconditions fullfilled: " + patch::to_string(t))
			if (t != -1){
				const std::pair< BWAPI::UnitType,int> buildingPair=Unittypes->find(*CreatingUnit)->whatBuilds();//TODO give task may be for several
				*next = giveTask(consumeResources(fastForward(&parent, t), *CreatingUnit), buildingPair.first);
				generatedNodes++;
				DEBUG_LOG("action did successor generation")
					return t;
			}
		DEBUG_ERR("action failed with successor generation: " + toString())
			DEBUG_ERR("state  failed with successor generation: " + parent.toString())
			return -1;
	}
	Action(const BWAPI::UnitType::set& uT, const BWAPI::UnitType *CU) {
		Unittypes=&uT;
		CreatingUnit = CU;
		//TODO ;
		//unitsRequired declared
		DEBUG_LOG(this->toString())
	}

	const BWAPI::UnitType* getCu(){
		return CreatingUnit;
	}

	std::string toString(){
		return "A=(cU: " + patch::to_string(CreatingUnit)+ ")";
	}
};

class BuildOrder{
public:
	std::vector<Action*>* path;
	//TODO tostring
};

class Node{
public:
	Node* parent;
	Action* lastAction;
	int lastWaitingTime;
	State state;
	std::vector<Action> *ActionList;

	Node(Node* p, Action* a, int l, State& s, std::vector<Action> * al){
		//DEBUG_LOG("generating node with: "+s.toString())
		parent = p;
		ActionList = al;
		state = s;
		lastAction = a;
		lastWaitingTime = l;
		DEBUG_LOG("generated node with: " + state.toString())
	}

	std::vector<Node>* createSuccessors();
	void solutionPath(BuildOrder * bo);
	int duration();
	int h();
	int isGoal(const Goal G);

	std::string toString(){
		return "Node=(parent*: " + patch::to_string(parent) + " lastAction*: " + patch::to_string(lastAction) + "lastWaitingTime: " + patch::to_string(lastWaitingTime) + " state: " + state.toString() + " ActionList*: " + patch::to_string(ActionList) + ")";
	}
};

//Node --------------------------------------- Start
std::vector<Node>* Node::createSuccessors(){
	std::vector<Node> *succs = new std::vector<Node>(); //TODO delet - and correct so?? 
	std::vector<Action>::iterator pos = ActionList->begin();
	Node* temp = NULL;
	DEBUG_LOG("initiation in successocreation done")
		while (pos != ActionList->end()){
			Action* a = &(*pos);
			State * successorState = NULL;
			int d = (*pos).getSuccessor(state, &successorState);
			if (successorState == NULL){
				DEBUG_LOG("one action was unaplicable");
			}
			else{
				DEBUG_LOG("action succesfully applied")
					DEBUG_LOG(successorState->toString())
					temp = new Node(this, a, d, *(successorState), ActionList);
				//this gives the wrong action address!!! i think
				// front?t
				if (temp != NULL){
					succs->push_back(*temp);
				}
			}
			pos++;
		}
	return succs;
}

void Node::solutionPath(BuildOrder * bo){
	DEBUG_LOG("building solution in: " + this->toString())
		if (parent != NULL){
			parent->solutionPath(bo);
			DEBUG_LOG("adding last action: " + lastAction->toString());
			bo->path->push_back(lastAction);
		}

	return;
}

int Node::duration(){
	int d = 0;
	Node* c = this;
	while (c->parent != NULL){
		d += c->lastWaitingTime;
		c = c->parent;
	}
	return d;
}

int Node::h(){
	//TODO ;
	return 0;
}

int Node::isGoal(const Goal G){
	//Units
	int needNmb = 0;
	int haveNmb = 0;
	int latest = 0;
	for (int cU = 0; cU < Nmb_Units; cU++){
		needNmb = G.unitsRequiered->at(cU);
		std::vector<Unit>::iterator pos = state.Units.begin();
		while (haveNmb < needNmb && pos != state.Units.end()){
			if (pos->Type == cU) haveNmb++;
			if (pos->task.type == cU) {
				haveNmb++;
				if (latest < pos->task.timeTillDone){
					latest = pos->task.timeTillDone;
				}
			}
			pos++;
		}
		if (haveNmb < needNmb) {
			latest = -1;
			break;
		}
		haveNmb = 0;
	}
	//upgrades
	if (*(G.upgradesRequiered) != *(state.upgrades)){
		 //TODO wrong
	}
	if (latest == -1){
		DEBUG_LOG("is not goal: " + this->toString())
			DEBUG_LOG("remember goal is: " + G.toString())
	}
	else{
		DEBUG_LOG("is goal: " + this->toString())
	}
	return latest;
}
//Node --------------------------------------- END

BuildOrder *DFBB(Node& n, const Goal G, const int timeEnd, int* bound, BuildOrder *bestSolution){
	/*   if(currentTime >= timeEnd){
	return;
	}*/
	DEBUG_LOG("in dfbb")
		expandedNodes++;//TODO corect place?
	int goalduration = n.isGoal(G);
	if (goalduration>-1){
		DEBUG_LOG("found a solution")
			goalduration += n.duration();
				if (*bound > goalduration){
					*bound = std::min(*bound, goalduration);
					//TODO deep deletion?
					bestSolution->path = new std::vector<Action*>();
					n.solutionPath(bestSolution);
				}
		}
		else{
		DEBUG_LOG("successors are beeing generated")
		std::vector<Node>* succ = n.createSuccessors();
			if (succ != NULL){
			DEBUG_LOG("size of succ: " + patch::to_string(succ->size()))
					for (unsigned int i = 0; i < succ->size(); i++){
						Node next = succ->at(i);
						next.parent = &n;
						int h = next.h();
						if (n.duration() + h < *bound){
							DFBB(next, G, timeEnd, bound, bestSolution);
						}
						else{
							DEBUG_LOG("dead end")
						}
					}
			}
			else{
				DEBUG_LOG("dead end")
			}
		}
		DEBUG_LOG("end dfbb")
			return bestSolution;
}

//----------main----------
int _tmain(int argc, _TCHAR* argv[])
{
	//int main(int argc, char **argv){
	const BWAPI::UnitType::set& allUnitTypes = BWAPI::UnitTypes::allUnitTypes();
	//clear loggers
	std::cout << "clear log and err -_file" << std::endl;
	std::ofstream ofs;
	ofs.open("log_file.txt", std::ofstream::out | std::ofstream::trunc);
	ofs.close();
	std::ofstream ers;
	ers.open("err_file.txt", std::ofstream::out | std::ofstream::trunc);
	ers.close();

	try{
		std::cout << "initializing Search" << std::endl;
		DEBUG_LOG("initializing Search")
			//Unittype worker(50, 0, -1, BWAPI::UnitTypes::Terran_Command_Center, 35, BWAPI::UnitTypes::Terran_Command_Center);
			//TODO this is not quite correct - though i think they have no techrequisition, so this would be okey (as it needs a builder anyway) but supotimal for performance
			//Unittype cc(400, 0, 10, BWAPI::UnitTypes::Terran_SCV, 120, BWAPI::UnitTypes::Terran_SCV);
			/*std::unordered_map<int, Unittype> Unittypes{
				{ BWAPI::UnitTypes::Terran_SCV, worker },
				{ BWAPI::UnitTypes::Terran_Command_Center, cc }
				};*/
				// works 
				//Action createCC(allUnitTypes, &BWAPI::UnitTypes::Terran_Command_Center);
				//Action createWK(allUnitTypes, &BWAPI::UnitTypes::Terran_SCV);

				//std::vector<Action> actions{ createCC, createWK };
				//TODO build all actions
				std::vector<Action> actions = std::vector<Action>();
		const BWAPI::UnitType::set& aUT = BWAPI::UnitTypes::allUnitTypes();
		BWAPI::UnitType::set::iterator iter = aUT.begin();
		while (iter != aUT.end()){
			if ((*iter).getRace() == BWAPI::Races::Terran){
				Action createNext(allUnitTypes, &(*iter));
				actions.push_back(createNext);
			}
			iter++;
		}

		std::array<bool, Nmb_Upgrades> supgrades = std::array<bool, Nmb_Upgrades>();
		Task defaultTask{ IDLE_TASK, INF };
		Unit wo1(BWAPI::UnitTypes::Terran_SCV, NO_PARTNER, defaultTask);
		Unit wo2(wo1);
		Unit wo3(wo1);
		Unit wo4(wo1);
		Unit cc1(BWAPI::UnitTypes::Terran_Command_Center, NO_PARTNER, defaultTask);
		DEBUG_LOG("now initiating vector")
			std::vector<Unit> sunits{ wo1, wo2, wo3, wo4, cc1 };
		DEBUG_LOG(vec_to_string(sunits))

			State initState(50.0, 0.0, 0, &supgrades, sunits);
		DEBUG_LOG("initState done:" + initState.toString())
			Node* nullNode = (Node *)0;
		DEBUG_LOG("nodepointer done")
			Action* nullAction = (Action *)0;
		DEBUG_LOG("actionpointer done")
			Node init(nullNode, nullAction, 0, initState, &actions);

		DEBUG_LOG("init: " + init.toString())
			DEBUG_LOG("init done")


			std::array<int, Nmb_Units> goalUnits = *(new std::array<int, Nmb_Units>());
		goalUnits[BWAPI::UnitTypes::Terran_Supply_Depot] = 1;
		goalUnits[BWAPI::UnitTypes::Terran_SCV] = 6;
		Goal g(&goalUnits, &supgrades);
		std::cout << "Starting Search" << std::endl;
		DEBUG_LOG("Starting Search")

			//TODO find trivial solution
			int bound = 1500;
		BuildOrder* solution = new BuildOrder();
		// -------------- actual search --------------
		std::clock_t begin = std::clock();
		DFBB(init, g, 50, &bound, solution);
		std::clock_t end = std::clock();
		double elapsed_secs = double(end - begin) / CLOCKS_PER_SEC;
		// -------------- actual search  end--------------
		write_text_to_log_file(__FILE__, __LINE__, "sthm"/*VS2013 does not know this: __func__*/, "time needed: " + patch::to_string(elapsed_secs) + "sec");
		write_text_to_log_file(__FILE__, __LINE__, "sthm"/*VS2013 does not know this: __func__*/, "generated nodes: " + patch::to_string(generatedNodes));
		write_text_to_log_file(__FILE__, __LINE__, "sthm"/*VS2013 does not know this: __func__*/, "expanded nodes: " + patch::to_string(expandedNodes));
		DEBUG_LOG("sol pntr: " + patch::to_string(solution))
		std::cout << "Search finished after: " << elapsed_secs << "sec" << std::endl << "generated nodes: " << patch::to_string(generatedNodes) << std::endl << "expanded nodes: " << patch::to_string(expandedNodes) << std::endl;
		assert(solution->path != NULL);
		std::cout << "found a solution!" << std::endl;;
		write_text_to_log_file(__FILE__, __LINE__, "sthm"/*VS2013 does not know this: __func__*/, "solution found, size: " + patch::to_string(solution->path->size()));
		write_text_to_log_file(__FILE__, __LINE__, "sthm"/*VS2013 does not know this: __func__*/, "solution found, duration: " + patch::to_string(bound));

		std::cout << "Build Order: ";
		std::vector<Action*> boso = *(solution->path);
		for (int i = 0; i < solution->path->size(); i++){
			Action* ac = boso[i];
			std::cout << *(ac->getCu()) <<"   ";
		}
		std::cout << std::endl;
		std::cout << "solution size: " << solution->path->size() << std::endl;
		std::cout << "solution duration (makespan): " << bound << std::endl;
	}
	catch (std::exception& e){
		std::cout << e.what() << '\n';
		char a;
		std::cin >> a;
	}
	char a;
	std::cin >> a;
	return 0;
}

