#ifndef SEARCH_ENGINES_BSW_SEARCH_H
#define SEARCH_ENGINES_BSW_SEARCH_H

#include "../search_engine.h"

#include "../open_lists/open_list.h"

#include <memory>
#include <vector>

class GlobalOperator;
class Heuristic;
class PruningMethod;
class ScalarEvaluator;

namespace options {
    class Options;
}

namespace bsw_search {
    class BswSearch : public SearchEngine {
        const bool reopen_closed_nodes;
        const double w;

        std::unique_ptr<StateOpenList> open_list;
        std::unique_ptr<StateOpenList> cleanup_list;
        std::unique_ptr<StateOpenList> focal_list;
        std::unique_ptr<StateOpenList> focal_backup;
        ScalarEvaluator *f_evaluator;
        ScalarEvaluator *f_inad_evaluator;


        std::vector<Heuristic *> heuristics;
        std::vector<Heuristic *> preferred_operator_heuristics;

        std::shared_ptr<PruningMethod> pruning_method;

        std::pair<SearchNode, bool> fetch_next_node();
        std::tuple<SearchNode, EvaluationContext, bool> fetch_best_from(std::unique_ptr<StateOpenList> const& list);

        void start_f_value_statistics(EvaluationContext &eval_context);
        void update_f_value_statistics(const SearchNode &node);
        void reward_progress();
        void print_checkpoint_line(int g) const;

    protected:
        virtual void initialize() override;
        virtual SearchStatus step() override;

    public:
        explicit BswSearch(const options::Options &opts);
        virtual ~BswSearch() = default;

        virtual void print_statistics() const override;

        void dump_search_space() const;
    };
}

#endif
