#ifndef HEURISTICS_NOVELTY_HEURISTIC_H
#define HEURISTICS_NOVELTY_HEURISTIC_H

#include "../heuristic.h"
#include <list>
#include <map>

using namespace std;
namespace novelty_heuristic{
class NoveltyHeuristic : public Heuristic {
    std::map<int, std::vector<bool> > lookup;
    std::vector<int> offsets;
    std::vector<std::vector<int> > subsets;
    std::vector<int> domain_sizes;
    ScalarEvaluator *bucket_h;

    const int novelty_bound;
    unsigned int lookup_size;

    int compute_heuristic(const GlobalState &global_state) override;
    void comb(int K);
    unsigned int factorial(unsigned int n);
public:
    explicit NoveltyHeuristic(const options::Options &opts);
    virtual ~NoveltyHeuristic() override;
};
}


#endif
