/*
 * MapLoader.h
 *
 * Reads maps for use in my MapGraphNode class.
 * Specifically reads maps from Nathan Sturtevant's benchmarks
 * 	( http://www.movingai.com/benchmarks/ )
 *
 * As it seems ScenarioLoader only reads the agent descriptions, not the map descriptions,
 * I had to write this one myself.
 *
 * I used a static method for loading maps and a struct for passing it.
 * Personal preference, really. But this way it is easier to later add
 * functions for reading different map formats if I want to.
 *
 *  Created on: 16.10.2017
 *      Author: Simon
 */

#ifndef MAPLOADER_H_
#define MAPLOADER_H_

struct MapData {
	bool* map;
	int width;
	int height;
	bool eightAdjacency;
};

class MapLoader {

public:
	static MapData _loadSturtevantMapAsBoolArray(const char * filename);

private:
	MapLoader() {} //don't actually instantiate this class.

};


#endif /* MAPLOADER_H_ */
