/*
 * MDD.h
 * Single-agent MDD
 *
 *  Created on: 19.10.2017
 *      Author: Simon
 */

#ifndef MDD_H_
#define MDD_H_

class MDDNode;

class MDD {
private:
	MDDNode* head;
	MDDNode* tail;
	int cost;

public:
	/**
	 * Makes a new MDD object to wrap around an existing structure of linked MDDNodes
	 */
	MDD(MDDNode* head, MDDNode* tail, int cost);

	/**
	 * deletes the MDDNodes
	 */
	~MDD();

	MDDNode* getHead();
	MDDNode* getTail();
	int getCost();
};



#endif /* MDD_H_ */
