/*
 * JMDD.cpp
 *
 *  Created on: 20.10.2017
 *      Author: Simon
 */

#include "JMDD.h"

#include <algorithm>
#include <iterator>
#include <set>
#include <utility>

JMDD::JMDD(JMDDNode* head, JMDDNode* tail, int cost) {
	this->head = head;
	this->tail = tail;
	this->cost = cost;
}

JMDD::~JMDD() {
	std::set<JMDDNode*>* currentLayer = new std::set<JMDDNode*>;
	currentLayer->insert(head);
	std::set<JMDDNode*>* nextLayer = new std::set<JMDDNode*>;
	for (int i = 0; i <= cost; ++i) {
		for (auto layer_it = currentLayer->begin(); layer_it != currentLayer->end(); ++layer_it) {
			for (auto successor_it = (*layer_it)->successors.begin(); successor_it != (*layer_it)->successors.end(); ++successor_it) {
				nextLayer->insert(*successor_it);
			}
			delete *layer_it;
		}
		delete currentLayer;
		currentLayer = nextLayer;
		nextLayer = new std::set<JMDDNode*>;
	}
	delete currentLayer;
	delete nextLayer;
}

JMDDNode* JMDD::getHead() {
	return head;
}

int JMDD::getCost() {
	return cost;
}

std::vector<std::vector<GraphNode*> >* JMDD::extractPaths(GraphNode* sourceNode) {
	//TODO make this somewhat efficient maybe? Not all that important but still...
	//I tried going from head to tail but that gave unreliable results sometimes ending short. Either somehow fix MDDs containing dead ends or just go with tail->head and then reverse
	int agentCount = head->graphNodes.size();
	std::vector<std::vector<GraphNode*>>* jointPath = new std::vector<std::vector<GraphNode*>>(agentCount);
	JMDDNode* currentNode = tail;
	int agentIndex = 0;
	for (auto agentIterator = currentNode->graphNodes.begin(); agentIterator != currentNode->graphNodes.end(); ++agentIterator) {
		(*jointPath)[agentIndex].push_back(sourceNode->getNodeFromGraph(agentIterator->second[0])); //get the first best node this agent is in for this MDD node (for non abstract just the one possibility)
		++agentIndex;
	}
	while (currentNode->predecessors.size() > 0) {
		currentNode = currentNode->predecessors[0]; //jump to first predecessor; any one will do (we do not prefer one optimal solution over another)
		agentIndex = 0;
		for (auto agentIterator = currentNode->graphNodes.begin(); agentIterator != currentNode->graphNodes.end(); ++agentIterator) {
			(*jointPath)[agentIndex].push_back(sourceNode->getNodeFromGraph(agentIterator->second[0])); //get the first best node this agent is in for this MDD node (for non abstract just the one possibility)
			++agentIndex;
		}
	}
	agentIndex = 0;
	for (auto agentIterator = currentNode->graphNodes.begin(); agentIterator != currentNode->graphNodes.end(); ++agentIterator) {
		std::reverse((*jointPath)[agentIndex].begin(), (*jointPath)[agentIndex].end());
		++agentIndex;
	}
	return jointPath;
}
