/*
 * GraphNode.cpp
 *
 *  Created on: 17.10.2017
 *      Author: Simon
 */

#include "GraphNode.h"

#include <algorithm>
#include <climits>
#include <functional>
#include <iterator>
#include <map>
#include <queue>
#include <utility>

//#include <iostream> //only for testing

bool GraphNode::operator==(const GraphNode& rhs) {
	return index == rhs.index;
}

bool GraphNode::operator==(int rhs) {
	return index == rhs;
}

bool GraphNode::operator!=(const GraphNode& rhs) {
	return !operator==(rhs);
}

bool GraphNode::operator!=(int rhs) {
	return !operator==(rhs);
}

int GraphNode::getIndex() {
	return index;
}

string GraphNode::toString() {
	return std::to_string(index);
}

struct SearchNode {

};

// unit-cost best-first search (using GraphNode implementations heuristic, uninformed by default and euclidian for MapGraphNode)
std::vector<GraphNode*>* GraphNode::getShortestPathTo(int destinationIndex) {

	std::vector<GraphNode*>* path = new std::vector<GraphNode*>();

	//initial goal test
	if (this->index == destinationIndex) {
		path->push_back(this);
		return path;
	}

	std::map<GraphNode*,GraphNode*> predecessors; //stores how each node was reached
//	std::priority_queue<std::pair<double,GraphNode*>,std::vector<std::pair<double,GraphNode*>>,std::greater<std::pair<double,GraphNode*>>> open; //takes nodes with smallest estimated total path length first, tie-breaker is I believe comparison of pointers (e.g. whichever is stored first in memory). Not ideal but single-agent search is not really the focus right now and the way it works now there are almost 0 ties.
	std::priority_queue<std::tuple<double, double, int, GraphNode*>,std::vector<std::tuple<double, double, int, GraphNode*>>,std::greater<std::tuple<double, double, int, GraphNode*>>> open; //maybe eliminate inconsistencies here

	//open.push(std::make_pair(this->estimateDistanceTo(destinationIndex),this)); //start with calling node
	open.push(std::make_tuple(0 + this->estimateDistanceTo(destinationIndex), this->estimateDistanceTo(destinationIndex), this->getIndex(), this)); //start with calling node
	predecessors[this] = 0; //no predecessor

	int* distanceFromStart = new int[this->getGraphSize()];

	for (int i = 0; i < this->getGraphSize(); ++i) {
		distanceFromStart[i] = INT_MAX;
	}

	distanceFromStart[this->index] = 0;

	GraphNode* next;
	std::tuple<double, double, int, GraphNode*> nextTuple;
	std::vector<GraphNode*> neighbours;

	while (!open.empty()) {

		nextTuple = open.top();
		next = std::get<3>(nextTuple);
		open.pop();
		//std::cout << "BFS now looking at " << next->toString() << " with ID " << next->getIndex() << std::endl;

		//Check if it's the goal ...
		if (next->getIndex() == destinationIndex) {

			//... and if it is, reconstruct path
			path->push_back(next);
			while (predecessors[next] != 0) {
				next = predecessors[next];
				path->push_back(next);
			}
			std::reverse(path->begin(), path->end()); //reverse direction (because we reconstructed from destination to start)

			delete[] distanceFromStart;
			return path; //because everybody loves multiple exit points. sorry.
		}
		// ... and if it isn't, continue with node expansion

		//expand
		neighbours = next->getNeighbours();
		for (auto it = neighbours.begin(); it != neighbours.end(); ++it) { //for every neighbour...
			if (distanceFromStart[next->getIndex()] + 1 < distanceFromStart[(*it)->getIndex()]) { //... that we haven't handled already in the past (unless at higher cost so we reopen)...
				predecessors[*it] = next; //... mark how we got there...
				distanceFromStart[(*it)->getIndex()] = distanceFromStart[next->getIndex()] + 1; //... add cost ...
				int g = distanceFromStart[(*it)->getIndex()];
				double h = (*it)->estimateDistanceTo(destinationIndex);
				//open.push(std::make_tuple(distanceFromStart[(*it)->getIndex()] + (*it)->estimateDistanceTo(destinationIndex),*it)); //... and add it to the open list.
				open.push(std::make_tuple(g+h, h, (*it)->getIndex(), *it)); //... and add it to the open list.

			}
		}
	}

	//no path found, return null pointer
	delete[] distanceFromStart;
	delete path;
	return 0;
}

std::vector<GraphNode*>* GraphNode::getShortestPathTo(GraphNode* destination) {
	return getShortestPathTo(destination->getIndex());
}

int GraphNode::getDistanceTo(int destinationIndex) {
	std::vector<GraphNode*>* path = getShortestPathTo(destinationIndex);
	if (path == 0) {
		return -1; //infinite distance
	}
	int distance = path->size() - 1; //number of steps = number of nodes - 1
	delete path; //the last memory leak I had :D
	return distance;
}

int GraphNode::getDistanceTo(GraphNode* destination) {
	return getDistanceTo(destination->getIndex());
}

double GraphNode::estimateDistanceTo(GraphNode* destination) {
	return 0.0;
}

double GraphNode::estimateDistanceTo(int destinationIndex) {
	return 0.0;
}

bool inline GraphNode::isTransitionPairConflicting(int originA, int destinationA, int originB, int destinationB) {
	if (destinationA == destinationB) return true;
	else if (originA == destinationB && originB == destinationA) return true;
	else return false;
}
