/*
 * EMDDNode.h
 *
 *  Created on: 05.12.2017
 *      Author: Simon
 */

#ifndef EMDDNODE_H_
#define EMDDNODE_H_

#include <vector>

#include "MDDNode.h"

class EMDDNode : public MDDNode {
private:
	int graphNode;
public:
	EMDDNode(int graphNode);
	virtual ~EMDDNode(){};

	virtual bool containsTile(int tile);
	virtual bool isMDDNodeTransitionPairConflicting(MDDNode* originA, MDDNode* destinationA, MDDNode* originB, MDDNode* destinationB, GraphNode* sourceNode);
	virtual bool isMDDNodeTransitionPairPossiblyConflicting(MDDNode* originA, MDDNode* destinationA, MDDNode* originB, MDDNode* destinationB, GraphNode* sourceNode);

	int getGraphNode();
	void setGraphNode(int graphNode);
	virtual std::vector<int> getAllTiles();
	virtual int getTileCount();
	virtual int getExplicitTile();
};

#endif /* EMDDNODE_H_ */
