/*
 * EMDDNode.cpp
 *
 *  Created on: 05.12.2017
 *      Author: Simon
 */

#include "EMDDNode.h"

#include "GraphNode.h"

EMDDNode::EMDDNode(int newGraphNode) {
	graphNode = newGraphNode;
}

int EMDDNode::getGraphNode() {
	return graphNode;
}

void EMDDNode::setGraphNode(int newGraphNode) {
	graphNode = newGraphNode;
}

bool EMDDNode::containsTile(int tile) {
	return tile == graphNode;
}

bool EMDDNode::isMDDNodeTransitionPairConflicting(MDDNode* originA, MDDNode* destinationA, MDDNode* originB, MDDNode* destinationB, GraphNode* sourceNode) {
	return sourceNode->isTransitionPairConflicting(
			((EMDDNode*) originA)->getGraphNode(),
			((EMDDNode*) destinationA)->getGraphNode(),
			((EMDDNode*) originB)->getGraphNode(),
			((EMDDNode*) destinationB)->getGraphNode());
}

bool EMDDNode::isMDDNodeTransitionPairPossiblyConflicting(MDDNode* originA, MDDNode* destinationA, MDDNode* originB, MDDNode* destinationB, GraphNode* sourceNode) {
	return isMDDNodeTransitionPairConflicting(originA, destinationA, originB, destinationB, sourceNode);
}

std::vector<int> EMDDNode::getAllTiles() {
	return std::vector<int>(1,graphNode);
}

int EMDDNode::getTileCount() {
	return 1;
}

int EMDDNode::getExplicitTile() {
	return graphNode;
}
