/*
 * AMDDNode.h
 *
 *  Created on: 05.12.2017
 *      Author: Simon
 */

#ifndef AMDDNODE_H_
#define AMDDNODE_H_

#include <vector>

#include "MDDNode.h"

class AMDDNode : public MDDNode {
private:
	std::vector<int> graphNodes;
public:
	AMDDNode();
	AMDDNode(int graphNode);
	AMDDNode(MDDNode* copyContainedGraphNodesFromThis);
	virtual ~AMDDNode(){};

	virtual bool containsTile(int tile);

	/**
	 * returns true only if no possible transition in them is possible
	 */
	virtual bool isMDDNodeTransitionPairConflicting(MDDNode* originA, MDDNode* destinationA, MDDNode* originB, MDDNode* destinationB, GraphNode* sourceNode);

	/**
	 * returns true if any possible transition in them is possible
	 */
	virtual bool isMDDNodeTransitionPairPossiblyConflicting(MDDNode* originA, MDDNode* destinationA, MDDNode* originB, MDDNode* destinationB, GraphNode* sourceNode);

	std::vector<int>* getGraphNodes();
	virtual std::vector<int> getAllTiles();
	virtual int getTileCount();

	void addTile(int tile); //does NOT handle connections (successors/predecessors)
	bool removeTile(int tile); //does NOT handle connections (successors/predecessors)

	/**
	 * Doesn't work. returns 0.
	 * I'm gonna make a better way to deal with path reconstruction anyway.
	 * So this is just so it compiles.
	 */
	virtual int getExplicitTile();

};


#endif /* AMDDNODE_H_ */
