/*
 * AMDDNode.cpp
 *
 *  Created on: 05.12.2017
 *      Author: Simon
 */

#include "AMDDNode.h"

#include <algorithm>
#include <iterator>

#include "GraphNode.h"

AMDDNode::AMDDNode() {
}

AMDDNode::AMDDNode(int newGraphNode) {
	graphNodes = std::vector<int>(1,newGraphNode);
}

AMDDNode::AMDDNode(MDDNode* copyContainedGraphNodesFromThis) {
	graphNodes = copyContainedGraphNodesFromThis->getAllTiles();
}

std::vector<int>* AMDDNode::getGraphNodes() {
	return &graphNodes;
}

bool AMDDNode::containsTile(int tile) {
	for (auto iterator = graphNodes.begin(); iterator != graphNodes.end(); ++iterator) {
		if ((*iterator) == tile) return true;
	}
	return false;
}

bool AMDDNode::isMDDNodeTransitionPairConflicting(MDDNode* originA, MDDNode* destinationA, MDDNode* originB, MDDNode* destinationB, GraphNode* sourceNode) {
	std::vector<int>* oA = ((AMDDNode*) originA)->getGraphNodes();
	std::vector<int>* dA = ((AMDDNode*) destinationA)->getGraphNodes();
	std::vector<int>* oB = ((AMDDNode*) originB)->getGraphNodes();
	std::vector<int>* dB = ((AMDDNode*) destinationB)->getGraphNodes();

	for (auto it_oA = oA->begin(); it_oA != oA->end(); ++it_oA) {
		for (auto it_dA = dA->begin(); it_dA != dA->end(); ++it_dA) {
			for (auto it_oB = oB->begin(); it_oB != oB->end(); ++it_oB) {
				for (auto it_dB = dB->begin(); it_dB != dB->end(); ++it_dB) { //FIXME That... That can't be good... Do I just hope that most of the time we'll find a conflict free pair early?

					//for every possible pair of explicit transitions
					if (!sourceNode->isTransitionPairConflicting(*it_oA, *it_dA, *it_oB, *it_dB)) {
						return false;
					}

				}
			}
		}
	}
	return true;

}

bool AMDDNode::isMDDNodeTransitionPairPossiblyConflicting(MDDNode* originA, MDDNode* destinationA, MDDNode* originB, MDDNode* destinationB, GraphNode* sourceNode) {
	std::vector<int>* oA = ((AMDDNode*) originA)->getGraphNodes();
	std::vector<int>* dA = ((AMDDNode*) destinationA)->getGraphNodes();
	std::vector<int>* oB = ((AMDDNode*) originB)->getGraphNodes();
	std::vector<int>* dB = ((AMDDNode*) destinationB)->getGraphNodes();
	//here goes a series of tests to make sure no conflict can occur

	//first let's see if the destination positions are too far apart to be conflicting. This does put a bit of a restriction on the otherwise very free definition of what is conflicting, but since we have that best make use of it.
	bool assuredConflictFree = true;
	int minimumDistanceForConflicts = sourceNode->minimumDestinationDistanceForConflicts();
	for (auto it_dA = dA->begin(); it_dA != dA->end(); ++it_dA) {
		for (auto it_dB = dB->begin(); it_dB != dB->end(); ++it_dB) {
			//for every possible pair of origin positions
			if (sourceNode->getNodeFromGraph(*it_dA)->estimateDistanceTo(*it_dB) <= minimumDistanceForConflicts) { //if they are close enough to cause trouble
				assuredConflictFree = false;
			}
			if (!assuredConflictFree) break; //when we have one possible trouble maker, we can stop here.
		}
		if (!assuredConflictFree) break; //when we have one possible trouble maker, we can stop here.
	}

	if (assuredConflictFree) {
		//if the first test guaranteed us no conflicts
		return false; //no conflicts
	}


	//then let's see if the origin positions are too far apart to be conflicting. This does put a bit of a restriction on the otherwise very free definition of what is conflicting, but since we have that best make use of it.bool assuredConflictFree = true;
	assuredConflictFree = true;
	minimumDistanceForConflicts = sourceNode->minimumOriginDistanceForConflicts();
	for (auto it_oA = oA->begin(); it_oA != oA->end(); ++it_oA) {
		for (auto it_oB = oB->begin(); it_oB != oB->end(); ++it_oB) {
			//for every possible pair of origin positions
			if (sourceNode->getNodeFromGraph(*it_oA)->estimateDistanceTo(*it_oB) <= minimumDistanceForConflicts) { //if they are close enough to cause trouble
				assuredConflictFree = false;
			}
			if (!assuredConflictFree) break; //when we have one possible trouble maker, we can stop here.
		}
		if (!assuredConflictFree) break; //when we have one possible trouble maker, we can stop here.
	}

	if (assuredConflictFree) {
		//if the second test guaranteed us no conflicts
		return false; //no conflicts
	}


	//next see if we have a conflict definition where overlapping in tiles is required. In my case should be true for 4-adjacency and false for 8-adjacency grids.
	if (sourceNode->doConflictsRequireOverlappingNodes()) {
		assuredConflictFree = true;
		for (auto it_dA = dA->begin(); it_dA != dA->end(); ++it_dA) {

			//see if A can go to one of the tiles B can go to
			for (auto it_dB = dB->begin(); it_dB != dB->end(); ++it_dB) {
				if ((*it_dA) == (*it_dB)) {
					assuredConflictFree = false;
				}
				if (!assuredConflictFree) break; //when we have one possible trouble maker, we can stop here.
			}
			if (!assuredConflictFree) break; //when we have one possible trouble maker, we can stop here.

			//see if A can go to one of the tiles B can come from
			for (auto it_oB = oB->begin(); it_oB != oB->end(); ++it_oB) {
				if ((*it_dA) == (*it_oB)) {
					assuredConflictFree = false;
				}
				if (!assuredConflictFree) break; //when we have one possible trouble maker, we can stop here.
			}
			if (!assuredConflictFree) break; //when we have one possible trouble maker, we can stop here.
		}
		if (assuredConflictFree) {
			for (auto it_dB = dB->begin(); it_dB != dB->end(); ++it_dB) {

				//see if B can go to one of the tiles A can come from
				for (auto it_oA = oA->begin(); it_oA != oA->end(); ++it_oA) {
					if ((*it_dB) == (*it_oA)) {
						assuredConflictFree = false;
					}
					if (!assuredConflictFree) break; //when we have one possible trouble maker, we can stop here.
				}
				if (!assuredConflictFree) break; //when we have one possible trouble maker, we can stop here.
			}
		}

		if (assuredConflictFree) {
			//if the third test guaranteed us no conflicts
			return false; //no conflicts
		}
	}

	//if all previous tests have failed, we can only resort to checking every combination of transitions for an actual conflict.
	for (auto it_oA = oA->begin(); it_oA != oA->end(); ++it_oA) {
		for (auto it_dA = dA->begin(); it_dA != dA->end(); ++it_dA) {
			for (auto it_oB = oB->begin(); it_oB != oB->end(); ++it_oB) {
				for (auto it_dB = dB->begin(); it_dB != dB->end(); ++it_dB) {

					//for every possible pair of explicit transitions
					if (sourceNode->isTransitionPairConflicting(*it_oA, *it_dA, *it_oB, *it_dB)) {
						return true;
					}

				}
			}
		}
	}
	return false;

}

std::vector<int> AMDDNode::getAllTiles() {
	return graphNodes; //copy constructor
}

int AMDDNode::getTileCount() {
	return graphNodes.size();
}

void AMDDNode::addTile(int tile) {
	graphNodes.push_back(tile);
}

bool AMDDNode::removeTile(int tile) {
	std::vector<int>::iterator position = std::find(graphNodes.begin(), graphNodes.end(), tile);
	if (position != graphNodes.end()) {
		graphNodes.erase(position);
		return true; //element found and removed
	}
	return false; //element not found
}

/**
 * Should we ever treat an abstract node as an explicit one - say, to create a path which due to abstraction may or may not be a valid one - just taking any node will have to do.
 */
int AMDDNode::getExplicitTile() {
	return graphNodes[0];
}
