/*
 * MapLoader.cpp
 *
 *  Created on: 16.10.2017
 *      Author: Simon
 */

#include "MapLoader.h"

#include <fstream>
#include <iostream>
#include <stdexcept>
#include <string>

MapData MapLoader::_loadSturtevantMapAsBoolArray(const char * filename) {

	using std::ifstream;
	using std::ofstream;
	using std::string;


	MapData mapdata;

	mapdata.width = 1;

	ifstream sfile(filename,std::ios::in);

	if (!sfile.is_open()) throw std::runtime_error("Could not open file '" + string(filename) + "'");

	string next;

	// READ FIRST FIELD: type (octile or quartile -> adjacency)
	sfile>>next;
	if(next == "type"){
		sfile>>next;
		if (next == "octile") { //8-adjacency
			mapdata.eightAdjacency = true;
		} else if (next == "quartile") { //4-adjacency
			//Fun Fact: Sturtevants file type description doesn't list any other option besides octile,
			//but since my system is set up to handle both 8 and 4 adjacency I check for both anyway.
			mapdata.eightAdjacency = false;
		} else {
			std::cout << "problem reading map; unknown type" << std::endl;
		}
	} else {
		std::cout << "problem reading map; type not found" << std::endl;
		mapdata.eightAdjacency = false;
	}

	// READ SECOND FIELD: height (integer)
	sfile>>next;
	if(next == "height"){
		sfile>>next;
		try {
			mapdata.height = std::stoi(next);
		} catch (std::invalid_argument &e) {
			std::cout << "problem reading map; invalid height" << std::endl;
		}
	} else {
		std::cout << "problem reading map; height not found" << std::endl;
	}

	// READ THIRD FIELD: width (integer)
	sfile>>next;
	if(next == "width"){
		sfile>>next;
		try {
			mapdata.width = std::stoi(next);
		} catch (std::invalid_argument &e) {
			std::cout << "problem reading map; invalid width" << std::endl;
		}
	} else {
		std::cout << "problem reading map; width not found" << std::endl;
	}

	//Next line should be "map"
	sfile>>next; //but at this point, am I really going to behave differently if it isn't? -> Ignore line

	// READ ACTUAL MAP (height lines of length width, each character is a tile)
	mapdata.map = new bool[mapdata.width * mapdata.height];
	for (int y = 0; y < mapdata.height; ++y) {
		sfile>>next;
		for(std::string::size_type x = 0; x < next.size(); ++x) {
		    char c = next[x]; //tile type; '.', 'G', '@', 'O', 'T', 'S', or 'W'
		    bool passability = false;

		    switch (c) {
				case '.': //regular terrain
					passability = true;
					break;
				case 'G': //regular terrain, but grape-flavoured
					passability = true;
					break;
				case '@': //out of bounds
					passability = false;
					break;
				case 'O': //out of bounds, but orange-flavoured
					passability = false;
					break;
				case 'T': //trees (unpassable)
					passability = false;
					break;
				case 'S': //swamp (passable from regular terrain) (not entirely sure what that means)
					passability = true;
					break;
				case 'W': //water (traversable, but not passable from terrain) (completely unsure what that means)
					passability = false;
					break;
				default:
					passability = false;
					break;
			}

		    mapdata.map[x + y * mapdata.width] = passability; //enter tile into array
		}
	}

	// Writing the map as pbm
	/*
	std::ofstream visualizationFile;
	visualizationFile.open ("map.pbm");
	visualizationFile << "P1\n"; //ascii encoded bitmap
	visualizationFile << mapdata.width << " " << mapdata.height << "\n"; //image dimensions
	for (int i = 0; i < mapdata.width*mapdata.height; ++i) {
		if (mapdata.map[i]) {
			visualizationFile << "0";
		} else {
			visualizationFile << "1";
		}
		visualizationFile << ' ';
		if ((i+1) % mapdata.width == 0) visualizationFile << '\n';
	}
	visualizationFile.close();
	*/

	return mapdata;
}

