/*
 * MDDNode.h
 *
 *  Created on: 05.12.2017
 *      Author: Simon
 */

#ifndef MDDNODE_H_
#define MDDNODE_H_

#include <vector>

class GraphNode;

class MDDNode {
private:
	//some way to represent its state/-s
public:
	std::vector<MDDNode*> successors;
	std::vector<MDDNode*> predecessors;

	virtual ~MDDNode(){};

	virtual bool containsTile(int tile) = 0;

	/**
	 * uses the source Node's blackbox transition interface to determine if a pair of transitions from MDDNode to MDDNode are necessarily conflicting.
	 * That is to say, is there a combination of transitions that allows one to get from origin to destination for both A and B at the same time.
	 * If there is just one, it returns false. if there is none, it returns true.
	 *
	 * ONLY CALL FOR MDD NODES OF SAME TYPE AS CALLER. (Don't mix explicit and Abstract MDDs!)
	 */
	virtual bool isMDDNodeTransitionPairConflicting(MDDNode* originA, MDDNode* destinationA, MDDNode* originB, MDDNode* destinationB, GraphNode* sourceNode) = 0;

	/**
	 * uses the source Node's blackbox transition interface to determine if a pair of transitions from MDDNode to MDDNode can at all be conflicting.
	 * That is to say, is there a combination of transitions that DOES NOT one to get from origin to destination for both A and B at the same time.
	 * If there is just one potential conflict, it returns true. if there is none, it returns false.
	 *
	 * ONLY CALL FOR MDD NODES OF SAME TYPE AS CALLER. (Don't mix explicit and Abstract MDDs!)
	 */
	virtual bool isMDDNodeTransitionPairPossiblyConflicting(MDDNode* originA, MDDNode* destinationA, MDDNode* originB, MDDNode* destinationB, GraphNode* sourceNode) = 0;

	/**
	 * make a new vector in the stack to return all tiles included in this MDD Node. For conflict avoidance table.
	 */
	virtual std::vector<int> getAllTiles() = 0;

	/**
	 * returns the number of tiles represented in this node. Always 1 for explicit nodes, possibly more for abstract nodes.
	 */
	virtual int getTileCount() = 0;

	/**
	 * For path reconstruction. Should only be used for explicit MDD nodes but I guess I'll have to refactor a whole lot of code to make that destinction.
	 * TODO This method is probably temporary
	 */
	virtual int getExplicitTile() = 0;
};


#endif /* MDDNODE_H_ */
