/*
 * MDD.cpp
 *
 *  Created on: 20.10.2017
 *      Author: Simon
 */

#include "MDD.h"

#include <iterator>
#include <map>
#include <set>
#include <utility>
#include <vector>

#include "MDDNode.h"

MDD::MDD(MDDNode* head, MDDNode* tail, int cost) {
	this->head = head;
	this->tail = tail;
	this->cost = cost;
}

MDD::~MDD() {
	std::set<MDDNode*>* currentLayer = new std::set<MDDNode*>;
	currentLayer->insert(head);
	std::set<MDDNode*>* nextLayer = new std::set<MDDNode*>;
	for (int i = 0; i <= cost; ++i) {
		for (auto layer_it = currentLayer->begin(); layer_it != currentLayer->end(); ++layer_it) {
			for (auto successor_it = (*layer_it)->successors.begin(); successor_it != (*layer_it)->successors.end(); ++successor_it) {
				nextLayer->insert(*successor_it);
			}
			delete *layer_it;
		}
		delete currentLayer;
		currentLayer = nextLayer;
		nextLayer = new std::set<MDDNode*>;
	}
	delete currentLayer;
	delete nextLayer;
}

MDDNode* MDD::getHead() {
	return head;
}

MDDNode* MDD::getTail() {
	return tail;
}

int MDD::getCost() {
	return cost;
}
