/*
 * JMDD.h
 * Explicit representation of Multi-agent MDDs
 *
 *  Created on: 19.10.2017
 *      Author: Simon
 */

#ifndef JMDD_H_
#define JMDD_H_

#include <map>
#include <vector>

#include "GraphNode.h"

struct JMDDNode {
	std::map<int,std::vector<int>> graphNodes; //maps ID of Agent to ID of graph nodes.
	std::vector<JMDDNode*> predecessors;
	std::vector<JMDDNode*> successors;
};

class JMDD {
private:
	JMDDNode* head;
	JMDDNode* tail; //don't need? not sure yet
	int cost;

public:
	/**
	 * Makes a new MDD object to wrap around an existing structure of linked MDDNodes
	 */
	JMDD(JMDDNode* head, JMDDNode* tail, int cost);

	/**
	 * deletes the MDDNodes
	 */
	~JMDD();

	/**
	 * Extracts a set of paths for the agents
	 */
	std::vector<std::vector<GraphNode*>>* extractPaths(GraphNode* sourceNode);

	JMDDNode* getHead();
	JMDDNode* getTail();
	int getCost();
};



#endif /* JMDD_H_ */
