/*
 * ICTSNode.h
 *
 *  Created on: 04.11.2017
 *      Author: Simon
 */

#ifndef ICTSNODE_H_
#define ICTSNODE_H_

#include <unordered_map>
#include <vector>

#include "MDD.h"

using std::vector;
using std::unordered_map;
using std::pair;

#include <iostream> //TODO remove

struct Agent {
	int id;
	int startTile;
	int goalTile;
	Agent(int id, int startTile, int goalTile) : id(id), startTile(startTile), goalTile(goalTile) {};
	Agent(){id = 0; startTile = 0; goalTile = 0;};
	bool operator==(const Agent& other) const {
		return (id == other.id);
	}
	bool operator!=(const Agent& other) const {
		return (id != other.id);
	}
	bool operator<(const Agent& other) const {
		return (id < other.id);
	}
	bool operator>(const Agent& other) const {
		return (other.id < id);
	}
	//int unitCost; //agent's weight //TODO story for another time, but I want weighted agents before the end of the Thesis
};

class ICTSNode {
public: //at first I had them private with getters/setters but really this is just a glorified struct, too much hassle to bother with encapsulation.
	vector<int> agentCosts;
	vector<MDD*> agentMDDs;

	/**
	 * keeps (copies?) agentCosts and fills agentMDDs
	 */
	//ICTSNode(vector<int> agentCosts, vector<Agent>* agents);
	ICTSNode(vector<int> agentCosts, vector<Agent>* agents, bool abstract);

	/**
	 * Calls upon the low-level search in ICTS.cpp
	 * Might delete this one later. After all, if it is the goal I want to have the path information too and dont want to call the low-level search again.
	 */
	bool isGoal();

	/**
	 * Generates Successors of ICTS Node.
	 * A bit strange to tell the Node what its agents are but there really is no point in every node
	 * saving the list of agents or even a pointer to it. No reason to store that information numberOfNodes times.
	 * It also takes a pointer to a hashmap where it can verify its successors aren't duplicates (and enter its new successors)
	 *
	 * @returns all non-duplicate successors; successors already present in alreadyGeneratedNodes are ignored.
	 */
	vector<ICTSNode*> getSuccessors(vector<Agent>* agents, unordered_map<vector<int>,ICTSNode*>* alreadyGeneratedNodes);
	vector<pair<ICTSNode*,ICTSNode*>> getSuccessorsWithAbstracts(vector<Agent>* agents, unordered_map<vector<int>,ICTSNode*>* alreadyGeneratedNodes);

};



#endif /* ICTSNODE_H_ */
