/*
 * ICTSNode.cpp
 *
 *  Created on: 04.11.2017
 *      Author: Simon
 */

#include "ICTSNode.h"

#include "hash.h"
#include "ICTS.h"

// if I keep this change, just call ICTSNode(...,false)
/*
ICTSNode::ICTSNode(vector<int> agentCosts, vector<Agent>* agents) {
	this->agentCosts = agentCosts;
	int agentCount = agentCosts.size();
	this->agentMDDs.reserve(agentCount);
	for (int i = 0; i < agentCount; ++i) {
		this->agentMDDs.push_back(ICTS::_getMDDForAgentWithCost((*agents)[i], agentCosts[i])); //looks up if it already has one or else calls upon MDDFactory to make one
	}
}
*/

ICTSNode::ICTSNode(vector<int> agentCosts, vector<Agent>* agents, bool abstract) {
	this->agentCosts = agentCosts;
	int agentCount = agentCosts.size();
	this->agentMDDs.reserve(agentCount);
	if (abstract) {
		for (int i = 0; i < agentCount; ++i) {
			this->agentMDDs.push_back(ICTS::_getAMDDForAgentWithCost((*agents)[i], agentCosts[i])); //looks up if it already has one or else calls upon MDDFactory to make one
		}
	} else {
		for (int i = 0; i < agentCount; ++i) {
			this->agentMDDs.push_back(ICTS::_getMDDForAgentWithCost((*agents)[i], agentCosts[i])); //looks up if it already has one or else calls upon MDDFactory to make one
		}
	}

}

bool ICTSNode::isGoal() {
	return !(ICTS::_getJointPath(&agentMDDs) == 0);
}

vector<ICTSNode*> ICTSNode::getSuccessors(vector<Agent>* agents, unordered_map<vector<int>,ICTSNode*>* alreadyGeneratedNodes) {
	vector<ICTSNode*> successors;
	for (int agentIndex = 0; agentIndex < (int) this->agentCosts.size(); ++agentIndex) {
		vector<int> newAgentCosts = this->agentCosts;
		newAgentCosts[agentIndex] = agentCosts[agentIndex] + 1; //TODO eventually "+ agent.unitCost" rather than "+ 1", if I have the time
		if (alreadyGeneratedNodes->find(newAgentCosts) == alreadyGeneratedNodes->end()) {
			ICTSNode* newICTSNode = new ICTSNode(newAgentCosts, agents, false);
			(*alreadyGeneratedNodes)[newAgentCosts] = newICTSNode;
			successors.push_back(newICTSNode);
		}
	}
	return successors;
}

/**
 * Best way I could think of to incorporate a faulty low-level test with abstract nodes is to generate pairs, one abstract and one concrete.
 * First is abstract, Second is concrete
 */
vector<pair<ICTSNode*, ICTSNode*>> ICTSNode::getSuccessorsWithAbstracts(vector<Agent>* agents, unordered_map<vector<int>,ICTSNode*>* alreadyGeneratedNodes) {
	vector<pair<ICTSNode*, ICTSNode*>> successors;
	for (int agentIndex = 0; agentIndex < (int) this->agentCosts.size(); ++agentIndex) {
		vector<int> newAgentCosts = this->agentCosts;
		newAgentCosts[agentIndex] = agentCosts[agentIndex] + 1; //TODO eventually "+ agent.unitCost" rather than "+ 1", if I have the time
		if (alreadyGeneratedNodes->find(newAgentCosts) == alreadyGeneratedNodes->end()) {
			ICTSNode* newICTSNodeConcrete = new ICTSNode(newAgentCosts, agents, false);
			ICTSNode* newICTSNodeAbstract = new ICTSNode(newAgentCosts, agents, true); //order important (but not vital); abstract uses pre-existing concrete but can also generate concrete which will be stored for when we need it
			(*alreadyGeneratedNodes)[newAgentCosts] = newICTSNodeConcrete;
			successors.push_back(std::make_pair(newICTSNodeAbstract, newICTSNodeConcrete));
		}
	}
	return successors;
}
