#ifndef SEARCH_ENGINES_SDD_SEARCH_H
#define SEARCH_ENGINES_SDD_SEARCH_H

#include "../search_engine.h"
#include "../global_operator.h"

#include <memory>
#include <vector>
#include <map>
#include <list>
#include <string>

extern "C" {
	#include "sddapi.h"
}

class GlobalOperator;

namespace options {
	class Options;
}

namespace sdd_search {
	class SddSearch : public SearchEngine {
		const std::string _orderType;
		const std::string _orderTree;
		const bool _verbose;
		
	private:
		
		std::map<int,std::list<SddNode*>> _operators;
		std::map<SddNode*, const GlobalOperator*> _operatorCorrespondence;
		
		SddLiteral _varCount; //count of SDD variables
		SddManager* _manager;
		
		std::vector<int> _domains; //domain sizes of SAS+ variables; _domains.size() = variable count of SAS+ variables
		
		std::map<int,SddNode*> _open;
		std::map<int,SddNode*> _closed;
		
		SddLiteral* _renameToPrime;
		SddLiteral* _renameFromPrime;
		
		std::vector<std::vector<int>> _order; //should map variable v_d to position p, _order[v][d]=p, v = variable in SAS+, d = its domain, p = index in SDD
		std::vector<std::vector<int>> _orderPrime; //same as above for primed variables.
		
		void setOrder(const std::string& mode);
		
		int getGMin();
		void fillInSuccessors(int g);
		SddNode* generateTransition(std::map<int,int> &pre, std::map<int,int> &eff);
		std::vector<const GlobalOperator*> reconstructPath(SddNode* reachedGoalStates, int g);

	protected:
		virtual void initialize() override;
		virtual SearchStatus step() override;

	public:
		explicit SddSearch(const options::Options &opts);
		virtual ~SddSearch() = default;

		virtual void print_statistics() const override;
	};
}

#endif
