# - Find the SDD package.
# This code defines the following variables:
#
#  SDD_FOUND                  - TRUE if SDD was found.
#  SDD_INCLUDE_DIRS           - Full paths to all include dirs.
#  SDD_LIBRARIES              - Full paths to all libraries.
#
# Usage:
#  find_package(SDD)
#
# The location of SDD can be specified using the environment variable
# or cmake parameter DOWNWARD_SDD_ROOT.
#
# Note that the standard FIND_PACKAGE features are supported
# (QUIET, REQUIRED, etc.).

find_path(SDD_INCLUDE_DIRS
    NAMES sddapi.h
    HINTS $ENV{DOWNWARD_SDD_ROOT}
    PATH_SUFFIXES include
    NO_DEFAULT_PATH
)

find_library(SDD_LIBRARY
    NAMES sdd
    HINTS $ENV{DOWNWARD_SDD_ROOT}
    PATH_SUFFIXES lib 
    NO_DEFAULT_PATH
)

set(SDD_LIBRARIES ${SDD_LIBRARY})

# Check if everything was found and set SDD_FOUND.
include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    SDD
    REQUIRED_VARS SDD_INCLUDE_DIRS SDD_LIBRARIES SDD_LIBRARY
)

mark_as_advanced(SDD_INCLUDE_DIRS SDD_LIBRARIES SDD_LIBRARY)
