;; ../../../domain-slitherlink/generator-solver/generate-pddl.py gen 9 12 p19.pddl p19.plan
;;
;;  322.32.3..2.             
;;  .2.221......             
;;  .........122             
;;  ..232.12..3.             
;;  1.0..2..3.1.             
;;  .3.3..212..2             
;;  .......2..03             
;;  .1.3.3.2...3             
;;  .3.1..2.3.2.             
;;
;;  +-+ +-+-+-+ +-+-+ +-+-+-+
;;  |3|2|2 . 3|2|. 3|.|. 2 .|
;;  + + + +-+-+ + +-+ + +-+-+
;;  |.|2|.|2 2 1|.|. .|.|. . 
;;  + + + + +-+ + +   + +-+-+
;;  |.|.|.|.|.|.|.|. .|1 2 2|
;;  + + + + + + + +-+-+ +-+ +
;;  |.|.|2|3|2|.|1 2 . .|3|.|
;;  + +-+ +-+ +-+ +-+ +-+ +-+
;;  |1 . 0 . . 2 .|.|3|. 1 . 
;;  + +-+ +-+-+-+-+ +-+ +-+  
;;  |.|3|.|3 . . 2 1 2 .|.|2 
;;  +-+ + +-+-+-+-+-+-+-+ +-+
;;   . .|. . . . . 2 . . 0 3|
;;  +-+-+ +-+ +-+-+-+-+-+ +-+
;;  |. 1 .|3|.|3 . 2 . .|.|3 
;;  +-+ +-+ + +-+-+-+-+ + +-+
;;   .|3|. 1|. . 2 . 3|.|2 .|
;;    +-+   +-+-+-+-+-+ +-+-+

(define (problem sliterlink-939616)
(:domain slitherlink)

(:objects
    cap-0 cap-1 cap-2 cap-3 cap-4 - cell-capacity-level
    n-0-0 n-0-1 n-0-2 n-0-3 n-0-4 n-0-5 n-0-6 n-0-7 n-0-8 n-0-9 n-0-10 n-0-11 n-0-12 n-1-0 n-1-1 n-1-2 n-1-3 n-1-4 n-1-5 n-1-6 n-1-7 n-1-8 n-1-9 n-1-10 n-1-11 n-1-12 n-2-0 n-2-1 n-2-2 n-2-3 n-2-4 n-2-5 n-2-6 n-2-7 n-2-8 n-2-9 n-2-10 n-2-11 n-2-12 n-3-0 n-3-1 n-3-2 n-3-3 n-3-4 n-3-5 n-3-6 n-3-7 n-3-8 n-3-9 n-3-10 n-3-11 n-3-12 n-4-0 n-4-1 n-4-2 n-4-3 n-4-4 n-4-5 n-4-6 n-4-7 n-4-8 n-4-9 n-4-10 n-4-11 n-4-12 n-5-0 n-5-1 n-5-2 n-5-3 n-5-4 n-5-5 n-5-6 n-5-7 n-5-8 n-5-9 n-5-10 n-5-11 n-5-12 n-6-0 n-6-1 n-6-2 n-6-3 n-6-4 n-6-5 n-6-6 n-6-7 n-6-8 n-6-9 n-6-10 n-6-11 n-6-12 n-7-0 n-7-1 n-7-2 n-7-3 n-7-4 n-7-5 n-7-6 n-7-7 n-7-8 n-7-9 n-7-10 n-7-11 n-7-12 n-8-0 n-8-1 n-8-2 n-8-3 n-8-4 n-8-5 n-8-6 n-8-7 n-8-8 n-8-9 n-8-10 n-8-11 n-8-12 n-9-0 n-9-1 n-9-2 n-9-3 n-9-4 n-9-5 n-9-6 n-9-7 n-9-8 n-9-9 n-9-10 n-9-11 n-9-12 - node
    cell-0-0 cell-0-1 cell-0-2 cell-0-3 cell-0-4 cell-0-5 cell-0-6 cell-0-7 cell-0-8 cell-0-9 cell-0-10 cell-0-11 cell-1-0 cell-1-1 cell-1-2 cell-1-3 cell-1-4 cell-1-5 cell-1-6 cell-1-7 cell-1-8 cell-1-9 cell-1-10 cell-1-11 cell-2-0 cell-2-1 cell-2-2 cell-2-3 cell-2-4 cell-2-5 cell-2-6 cell-2-7 cell-2-8 cell-2-9 cell-2-10 cell-2-11 cell-3-0 cell-3-1 cell-3-2 cell-3-3 cell-3-4 cell-3-5 cell-3-6 cell-3-7 cell-3-8 cell-3-9 cell-3-10 cell-3-11 cell-4-0 cell-4-1 cell-4-2 cell-4-3 cell-4-4 cell-4-5 cell-4-6 cell-4-7 cell-4-8 cell-4-9 cell-4-10 cell-4-11 cell-5-0 cell-5-1 cell-5-2 cell-5-3 cell-5-4 cell-5-5 cell-5-6 cell-5-7 cell-5-8 cell-5-9 cell-5-10 cell-5-11 cell-6-0 cell-6-1 cell-6-2 cell-6-3 cell-6-4 cell-6-5 cell-6-6 cell-6-7 cell-6-8 cell-6-9 cell-6-10 cell-6-11 cell-7-0 cell-7-1 cell-7-2 cell-7-3 cell-7-4 cell-7-5 cell-7-6 cell-7-7 cell-7-8 cell-7-9 cell-7-10 cell-7-11 cell-8-0 cell-8-1 cell-8-2 cell-8-3 cell-8-4 cell-8-5 cell-8-6 cell-8-7 cell-8-8 cell-8-9 cell-8-10 cell-8-11 cell-outside-0-left cell-outside-0-right cell-outside-1-left cell-outside-1-right cell-outside-2-left cell-outside-2-right cell-outside-3-left cell-outside-3-right cell-outside-4-left cell-outside-4-right cell-outside-5-left cell-outside-5-right cell-outside-6-left cell-outside-6-right cell-outside-7-left cell-outside-7-right cell-outside-8-left cell-outside-8-right cell-outside-0-up cell-outside-0-down cell-outside-1-up cell-outside-1-down cell-outside-2-up cell-outside-2-down cell-outside-3-up cell-outside-3-down cell-outside-4-up cell-outside-4-down cell-outside-5-up cell-outside-5-down cell-outside-6-up cell-outside-6-down cell-outside-7-up cell-outside-7-down cell-outside-8-up cell-outside-8-down cell-outside-9-up cell-outside-9-down cell-outside-10-up cell-outside-10-down cell-outside-11-up cell-outside-11-down - cell
)

(:init
    (CELL-CAPACITY-INC cap-0 cap-1)
    (CELL-CAPACITY-INC cap-1 cap-2)
    (CELL-CAPACITY-INC cap-2 cap-3)
    (CELL-CAPACITY-INC cap-3 cap-4)

    (CELL-CAPACITY cell-outside-0-left cap-1)
    (CELL-CAPACITY cell-outside-0-right cap-1)
    (CELL-CAPACITY cell-outside-1-left cap-1)
    (CELL-CAPACITY cell-outside-1-right cap-1)
    (CELL-CAPACITY cell-outside-2-left cap-1)
    (CELL-CAPACITY cell-outside-2-right cap-1)
    (CELL-CAPACITY cell-outside-3-left cap-1)
    (CELL-CAPACITY cell-outside-3-right cap-1)
    (CELL-CAPACITY cell-outside-4-left cap-1)
    (CELL-CAPACITY cell-outside-4-right cap-1)
    (CELL-CAPACITY cell-outside-5-left cap-1)
    (CELL-CAPACITY cell-outside-5-right cap-1)
    (CELL-CAPACITY cell-outside-6-left cap-1)
    (CELL-CAPACITY cell-outside-6-right cap-1)
    (CELL-CAPACITY cell-outside-7-left cap-1)
    (CELL-CAPACITY cell-outside-7-right cap-1)
    (CELL-CAPACITY cell-outside-8-left cap-1)
    (CELL-CAPACITY cell-outside-8-right cap-1)
    (CELL-CAPACITY cell-outside-0-up cap-1)
    (CELL-CAPACITY cell-outside-0-down cap-1)
    (CELL-CAPACITY cell-outside-1-up cap-1)
    (CELL-CAPACITY cell-outside-1-down cap-1)
    (CELL-CAPACITY cell-outside-2-up cap-1)
    (CELL-CAPACITY cell-outside-2-down cap-1)
    (CELL-CAPACITY cell-outside-3-up cap-1)
    (CELL-CAPACITY cell-outside-3-down cap-1)
    (CELL-CAPACITY cell-outside-4-up cap-1)
    (CELL-CAPACITY cell-outside-4-down cap-1)
    (CELL-CAPACITY cell-outside-5-up cap-1)
    (CELL-CAPACITY cell-outside-5-down cap-1)
    (CELL-CAPACITY cell-outside-6-up cap-1)
    (CELL-CAPACITY cell-outside-6-down cap-1)
    (CELL-CAPACITY cell-outside-7-up cap-1)
    (CELL-CAPACITY cell-outside-7-down cap-1)
    (CELL-CAPACITY cell-outside-8-up cap-1)
    (CELL-CAPACITY cell-outside-8-down cap-1)
    (CELL-CAPACITY cell-outside-9-up cap-1)
    (CELL-CAPACITY cell-outside-9-down cap-1)
    (CELL-CAPACITY cell-outside-10-up cap-1)
    (CELL-CAPACITY cell-outside-10-down cap-1)
    (CELL-CAPACITY cell-outside-11-up cap-1)
    (CELL-CAPACITY cell-outside-11-down cap-1)
    (CELL-CAPACITY cell-0-0 cap-3)
    (CELL-CAPACITY cell-0-1 cap-2)
    (CELL-CAPACITY cell-0-2 cap-2)
    (CELL-CAPACITY cell-0-3 cap-4)
    (CELL-CAPACITY cell-0-4 cap-3)
    (CELL-CAPACITY cell-0-5 cap-2)
    (CELL-CAPACITY cell-0-6 cap-4)
    (CELL-CAPACITY cell-0-7 cap-3)
    (CELL-CAPACITY cell-0-8 cap-4)
    (CELL-CAPACITY cell-0-9 cap-4)
    (CELL-CAPACITY cell-0-10 cap-2)
    (CELL-CAPACITY cell-0-11 cap-4)
    (CELL-CAPACITY cell-1-0 cap-4)
    (CELL-CAPACITY cell-1-1 cap-2)
    (CELL-CAPACITY cell-1-2 cap-4)
    (CELL-CAPACITY cell-1-3 cap-2)
    (CELL-CAPACITY cell-1-4 cap-2)
    (CELL-CAPACITY cell-1-5 cap-1)
    (CELL-CAPACITY cell-1-6 cap-4)
    (CELL-CAPACITY cell-1-7 cap-4)
    (CELL-CAPACITY cell-1-8 cap-4)
    (CELL-CAPACITY cell-1-9 cap-4)
    (CELL-CAPACITY cell-1-10 cap-4)
    (CELL-CAPACITY cell-1-11 cap-4)
    (CELL-CAPACITY cell-2-0 cap-4)
    (CELL-CAPACITY cell-2-1 cap-4)
    (CELL-CAPACITY cell-2-2 cap-4)
    (CELL-CAPACITY cell-2-3 cap-4)
    (CELL-CAPACITY cell-2-4 cap-4)
    (CELL-CAPACITY cell-2-5 cap-4)
    (CELL-CAPACITY cell-2-6 cap-4)
    (CELL-CAPACITY cell-2-7 cap-4)
    (CELL-CAPACITY cell-2-8 cap-4)
    (CELL-CAPACITY cell-2-9 cap-1)
    (CELL-CAPACITY cell-2-10 cap-2)
    (CELL-CAPACITY cell-2-11 cap-2)
    (CELL-CAPACITY cell-3-0 cap-4)
    (CELL-CAPACITY cell-3-1 cap-4)
    (CELL-CAPACITY cell-3-2 cap-2)
    (CELL-CAPACITY cell-3-3 cap-3)
    (CELL-CAPACITY cell-3-4 cap-2)
    (CELL-CAPACITY cell-3-5 cap-4)
    (CELL-CAPACITY cell-3-6 cap-1)
    (CELL-CAPACITY cell-3-7 cap-2)
    (CELL-CAPACITY cell-3-8 cap-4)
    (CELL-CAPACITY cell-3-9 cap-4)
    (CELL-CAPACITY cell-3-10 cap-3)
    (CELL-CAPACITY cell-3-11 cap-4)
    (CELL-CAPACITY cell-4-0 cap-1)
    (CELL-CAPACITY cell-4-1 cap-4)
    (CELL-CAPACITY cell-4-2 cap-0)
    (CELL-CAPACITY cell-4-3 cap-4)
    (CELL-CAPACITY cell-4-4 cap-4)
    (CELL-CAPACITY cell-4-5 cap-2)
    (CELL-CAPACITY cell-4-6 cap-4)
    (CELL-CAPACITY cell-4-7 cap-4)
    (CELL-CAPACITY cell-4-8 cap-3)
    (CELL-CAPACITY cell-4-9 cap-4)
    (CELL-CAPACITY cell-4-10 cap-1)
    (CELL-CAPACITY cell-4-11 cap-4)
    (CELL-CAPACITY cell-5-0 cap-4)
    (CELL-CAPACITY cell-5-1 cap-3)
    (CELL-CAPACITY cell-5-2 cap-4)
    (CELL-CAPACITY cell-5-3 cap-3)
    (CELL-CAPACITY cell-5-4 cap-4)
    (CELL-CAPACITY cell-5-5 cap-4)
    (CELL-CAPACITY cell-5-6 cap-2)
    (CELL-CAPACITY cell-5-7 cap-1)
    (CELL-CAPACITY cell-5-8 cap-2)
    (CELL-CAPACITY cell-5-9 cap-4)
    (CELL-CAPACITY cell-5-10 cap-4)
    (CELL-CAPACITY cell-5-11 cap-2)
    (CELL-CAPACITY cell-6-0 cap-4)
    (CELL-CAPACITY cell-6-1 cap-4)
    (CELL-CAPACITY cell-6-2 cap-4)
    (CELL-CAPACITY cell-6-3 cap-4)
    (CELL-CAPACITY cell-6-4 cap-4)
    (CELL-CAPACITY cell-6-5 cap-4)
    (CELL-CAPACITY cell-6-6 cap-4)
    (CELL-CAPACITY cell-6-7 cap-2)
    (CELL-CAPACITY cell-6-8 cap-4)
    (CELL-CAPACITY cell-6-9 cap-4)
    (CELL-CAPACITY cell-6-10 cap-0)
    (CELL-CAPACITY cell-6-11 cap-3)
    (CELL-CAPACITY cell-7-0 cap-4)
    (CELL-CAPACITY cell-7-1 cap-1)
    (CELL-CAPACITY cell-7-2 cap-4)
    (CELL-CAPACITY cell-7-3 cap-3)
    (CELL-CAPACITY cell-7-4 cap-4)
    (CELL-CAPACITY cell-7-5 cap-3)
    (CELL-CAPACITY cell-7-6 cap-4)
    (CELL-CAPACITY cell-7-7 cap-2)
    (CELL-CAPACITY cell-7-8 cap-4)
    (CELL-CAPACITY cell-7-9 cap-4)
    (CELL-CAPACITY cell-7-10 cap-4)
    (CELL-CAPACITY cell-7-11 cap-3)
    (CELL-CAPACITY cell-8-0 cap-4)
    (CELL-CAPACITY cell-8-1 cap-3)
    (CELL-CAPACITY cell-8-2 cap-4)
    (CELL-CAPACITY cell-8-3 cap-1)
    (CELL-CAPACITY cell-8-4 cap-4)
    (CELL-CAPACITY cell-8-5 cap-4)
    (CELL-CAPACITY cell-8-6 cap-2)
    (CELL-CAPACITY cell-8-7 cap-4)
    (CELL-CAPACITY cell-8-8 cap-3)
    (CELL-CAPACITY cell-8-9 cap-4)
    (CELL-CAPACITY cell-8-10 cap-2)
    (CELL-CAPACITY cell-8-11 cap-4)

    (node-degree0 n-0-0)
    (node-degree0 n-0-1)
    (node-degree0 n-0-2)
    (node-degree0 n-0-3)
    (node-degree0 n-0-4)
    (node-degree0 n-0-5)
    (node-degree0 n-0-6)
    (node-degree0 n-0-7)
    (node-degree0 n-0-8)
    (node-degree0 n-0-9)
    (node-degree0 n-0-10)
    (node-degree0 n-0-11)
    (node-degree0 n-0-12)
    (node-degree0 n-1-0)
    (node-degree0 n-1-1)
    (node-degree0 n-1-2)
    (node-degree0 n-1-3)
    (node-degree0 n-1-4)
    (node-degree0 n-1-5)
    (node-degree0 n-1-6)
    (node-degree0 n-1-7)
    (node-degree0 n-1-8)
    (node-degree0 n-1-9)
    (node-degree0 n-1-10)
    (node-degree0 n-1-11)
    (node-degree0 n-1-12)
    (node-degree0 n-2-0)
    (node-degree0 n-2-1)
    (node-degree0 n-2-2)
    (node-degree0 n-2-3)
    (node-degree0 n-2-4)
    (node-degree0 n-2-5)
    (node-degree0 n-2-6)
    (node-degree0 n-2-7)
    (node-degree0 n-2-8)
    (node-degree0 n-2-9)
    (node-degree0 n-2-10)
    (node-degree0 n-2-11)
    (node-degree0 n-2-12)
    (node-degree0 n-3-0)
    (node-degree0 n-3-1)
    (node-degree0 n-3-2)
    (node-degree0 n-3-3)
    (node-degree0 n-3-4)
    (node-degree0 n-3-5)
    (node-degree0 n-3-6)
    (node-degree0 n-3-7)
    (node-degree0 n-3-8)
    (node-degree0 n-3-9)
    (node-degree0 n-3-10)
    (node-degree0 n-3-11)
    (node-degree0 n-3-12)
    (node-degree0 n-4-0)
    (node-degree0 n-4-1)
    (node-degree0 n-4-2)
    (node-degree0 n-4-3)
    (node-degree0 n-4-4)
    (node-degree0 n-4-5)
    (node-degree0 n-4-6)
    (node-degree0 n-4-7)
    (node-degree0 n-4-8)
    (node-degree0 n-4-9)
    (node-degree0 n-4-10)
    (node-degree0 n-4-11)
    (node-degree0 n-4-12)
    (node-degree0 n-5-0)
    (node-degree0 n-5-1)
    (node-degree0 n-5-2)
    (node-degree0 n-5-3)
    (node-degree0 n-5-4)
    (node-degree0 n-5-5)
    (node-degree0 n-5-6)
    (node-degree0 n-5-7)
    (node-degree0 n-5-8)
    (node-degree0 n-5-9)
    (node-degree0 n-5-10)
    (node-degree0 n-5-11)
    (node-degree0 n-5-12)
    (node-degree0 n-6-0)
    (node-degree0 n-6-1)
    (node-degree0 n-6-2)
    (node-degree0 n-6-3)
    (node-degree0 n-6-4)
    (node-degree0 n-6-5)
    (node-degree0 n-6-6)
    (node-degree0 n-6-7)
    (node-degree0 n-6-8)
    (node-degree0 n-6-9)
    (node-degree0 n-6-10)
    (node-degree0 n-6-11)
    (node-degree0 n-6-12)
    (node-degree0 n-7-0)
    (node-degree0 n-7-1)
    (node-degree0 n-7-2)
    (node-degree0 n-7-3)
    (node-degree0 n-7-4)
    (node-degree0 n-7-5)
    (node-degree0 n-7-6)
    (node-degree0 n-7-7)
    (node-degree0 n-7-8)
    (node-degree0 n-7-9)
    (node-degree0 n-7-10)
    (node-degree0 n-7-11)
    (node-degree0 n-7-12)
    (node-degree0 n-8-0)
    (node-degree0 n-8-1)
    (node-degree0 n-8-2)
    (node-degree0 n-8-3)
    (node-degree0 n-8-4)
    (node-degree0 n-8-5)
    (node-degree0 n-8-6)
    (node-degree0 n-8-7)
    (node-degree0 n-8-8)
    (node-degree0 n-8-9)
    (node-degree0 n-8-10)
    (node-degree0 n-8-11)
    (node-degree0 n-8-12)
    (node-degree0 n-9-0)
    (node-degree0 n-9-1)
    (node-degree0 n-9-2)
    (node-degree0 n-9-3)
    (node-degree0 n-9-4)
    (node-degree0 n-9-5)
    (node-degree0 n-9-6)
    (node-degree0 n-9-7)
    (node-degree0 n-9-8)
    (node-degree0 n-9-9)
    (node-degree0 n-9-10)
    (node-degree0 n-9-11)
    (node-degree0 n-9-12)

    (CELL-EDGE cell-0-0 cell-1-0 n-1-0 n-1-1)
    (CELL-EDGE cell-0-1 cell-1-1 n-1-1 n-1-2)
    (CELL-EDGE cell-0-2 cell-1-2 n-1-2 n-1-3)
    (CELL-EDGE cell-0-3 cell-1-3 n-1-3 n-1-4)
    (CELL-EDGE cell-0-4 cell-1-4 n-1-4 n-1-5)
    (CELL-EDGE cell-0-5 cell-1-5 n-1-5 n-1-6)
    (CELL-EDGE cell-0-6 cell-1-6 n-1-6 n-1-7)
    (CELL-EDGE cell-0-7 cell-1-7 n-1-7 n-1-8)
    (CELL-EDGE cell-0-8 cell-1-8 n-1-8 n-1-9)
    (CELL-EDGE cell-0-9 cell-1-9 n-1-9 n-1-10)
    (CELL-EDGE cell-0-10 cell-1-10 n-1-10 n-1-11)
    (CELL-EDGE cell-0-11 cell-1-11 n-1-11 n-1-12)
    (CELL-EDGE cell-1-0 cell-2-0 n-2-0 n-2-1)
    (CELL-EDGE cell-1-1 cell-2-1 n-2-1 n-2-2)
    (CELL-EDGE cell-1-2 cell-2-2 n-2-2 n-2-3)
    (CELL-EDGE cell-1-3 cell-2-3 n-2-3 n-2-4)
    (CELL-EDGE cell-1-4 cell-2-4 n-2-4 n-2-5)
    (CELL-EDGE cell-1-5 cell-2-5 n-2-5 n-2-6)
    (CELL-EDGE cell-1-6 cell-2-6 n-2-6 n-2-7)
    (CELL-EDGE cell-1-7 cell-2-7 n-2-7 n-2-8)
    (CELL-EDGE cell-1-8 cell-2-8 n-2-8 n-2-9)
    (CELL-EDGE cell-1-9 cell-2-9 n-2-9 n-2-10)
    (CELL-EDGE cell-1-10 cell-2-10 n-2-10 n-2-11)
    (CELL-EDGE cell-1-11 cell-2-11 n-2-11 n-2-12)
    (CELL-EDGE cell-2-0 cell-3-0 n-3-0 n-3-1)
    (CELL-EDGE cell-2-1 cell-3-1 n-3-1 n-3-2)
    (CELL-EDGE cell-2-2 cell-3-2 n-3-2 n-3-3)
    (CELL-EDGE cell-2-3 cell-3-3 n-3-3 n-3-4)
    (CELL-EDGE cell-2-4 cell-3-4 n-3-4 n-3-5)
    (CELL-EDGE cell-2-5 cell-3-5 n-3-5 n-3-6)
    (CELL-EDGE cell-2-6 cell-3-6 n-3-6 n-3-7)
    (CELL-EDGE cell-2-7 cell-3-7 n-3-7 n-3-8)
    (CELL-EDGE cell-2-8 cell-3-8 n-3-8 n-3-9)
    (CELL-EDGE cell-2-9 cell-3-9 n-3-9 n-3-10)
    (CELL-EDGE cell-2-10 cell-3-10 n-3-10 n-3-11)
    (CELL-EDGE cell-2-11 cell-3-11 n-3-11 n-3-12)
    (CELL-EDGE cell-3-0 cell-4-0 n-4-0 n-4-1)
    (CELL-EDGE cell-3-1 cell-4-1 n-4-1 n-4-2)
    (CELL-EDGE cell-3-2 cell-4-2 n-4-2 n-4-3)
    (CELL-EDGE cell-3-3 cell-4-3 n-4-3 n-4-4)
    (CELL-EDGE cell-3-4 cell-4-4 n-4-4 n-4-5)
    (CELL-EDGE cell-3-5 cell-4-5 n-4-5 n-4-6)
    (CELL-EDGE cell-3-6 cell-4-6 n-4-6 n-4-7)
    (CELL-EDGE cell-3-7 cell-4-7 n-4-7 n-4-8)
    (CELL-EDGE cell-3-8 cell-4-8 n-4-8 n-4-9)
    (CELL-EDGE cell-3-9 cell-4-9 n-4-9 n-4-10)
    (CELL-EDGE cell-3-10 cell-4-10 n-4-10 n-4-11)
    (CELL-EDGE cell-3-11 cell-4-11 n-4-11 n-4-12)
    (CELL-EDGE cell-4-0 cell-5-0 n-5-0 n-5-1)
    (CELL-EDGE cell-4-1 cell-5-1 n-5-1 n-5-2)
    (CELL-EDGE cell-4-2 cell-5-2 n-5-2 n-5-3)
    (CELL-EDGE cell-4-3 cell-5-3 n-5-3 n-5-4)
    (CELL-EDGE cell-4-4 cell-5-4 n-5-4 n-5-5)
    (CELL-EDGE cell-4-5 cell-5-5 n-5-5 n-5-6)
    (CELL-EDGE cell-4-6 cell-5-6 n-5-6 n-5-7)
    (CELL-EDGE cell-4-7 cell-5-7 n-5-7 n-5-8)
    (CELL-EDGE cell-4-8 cell-5-8 n-5-8 n-5-9)
    (CELL-EDGE cell-4-9 cell-5-9 n-5-9 n-5-10)
    (CELL-EDGE cell-4-10 cell-5-10 n-5-10 n-5-11)
    (CELL-EDGE cell-4-11 cell-5-11 n-5-11 n-5-12)
    (CELL-EDGE cell-5-0 cell-6-0 n-6-0 n-6-1)
    (CELL-EDGE cell-5-1 cell-6-1 n-6-1 n-6-2)
    (CELL-EDGE cell-5-2 cell-6-2 n-6-2 n-6-3)
    (CELL-EDGE cell-5-3 cell-6-3 n-6-3 n-6-4)
    (CELL-EDGE cell-5-4 cell-6-4 n-6-4 n-6-5)
    (CELL-EDGE cell-5-5 cell-6-5 n-6-5 n-6-6)
    (CELL-EDGE cell-5-6 cell-6-6 n-6-6 n-6-7)
    (CELL-EDGE cell-5-7 cell-6-7 n-6-7 n-6-8)
    (CELL-EDGE cell-5-8 cell-6-8 n-6-8 n-6-9)
    (CELL-EDGE cell-5-9 cell-6-9 n-6-9 n-6-10)
    (CELL-EDGE cell-5-10 cell-6-10 n-6-10 n-6-11)
    (CELL-EDGE cell-5-11 cell-6-11 n-6-11 n-6-12)
    (CELL-EDGE cell-6-0 cell-7-0 n-7-0 n-7-1)
    (CELL-EDGE cell-6-1 cell-7-1 n-7-1 n-7-2)
    (CELL-EDGE cell-6-2 cell-7-2 n-7-2 n-7-3)
    (CELL-EDGE cell-6-3 cell-7-3 n-7-3 n-7-4)
    (CELL-EDGE cell-6-4 cell-7-4 n-7-4 n-7-5)
    (CELL-EDGE cell-6-5 cell-7-5 n-7-5 n-7-6)
    (CELL-EDGE cell-6-6 cell-7-6 n-7-6 n-7-7)
    (CELL-EDGE cell-6-7 cell-7-7 n-7-7 n-7-8)
    (CELL-EDGE cell-6-8 cell-7-8 n-7-8 n-7-9)
    (CELL-EDGE cell-6-9 cell-7-9 n-7-9 n-7-10)
    (CELL-EDGE cell-6-10 cell-7-10 n-7-10 n-7-11)
    (CELL-EDGE cell-6-11 cell-7-11 n-7-11 n-7-12)
    (CELL-EDGE cell-7-0 cell-8-0 n-8-0 n-8-1)
    (CELL-EDGE cell-7-1 cell-8-1 n-8-1 n-8-2)
    (CELL-EDGE cell-7-2 cell-8-2 n-8-2 n-8-3)
    (CELL-EDGE cell-7-3 cell-8-3 n-8-3 n-8-4)
    (CELL-EDGE cell-7-4 cell-8-4 n-8-4 n-8-5)
    (CELL-EDGE cell-7-5 cell-8-5 n-8-5 n-8-6)
    (CELL-EDGE cell-7-6 cell-8-6 n-8-6 n-8-7)
    (CELL-EDGE cell-7-7 cell-8-7 n-8-7 n-8-8)
    (CELL-EDGE cell-7-8 cell-8-8 n-8-8 n-8-9)
    (CELL-EDGE cell-7-9 cell-8-9 n-8-9 n-8-10)
    (CELL-EDGE cell-7-10 cell-8-10 n-8-10 n-8-11)
    (CELL-EDGE cell-7-11 cell-8-11 n-8-11 n-8-12)
    (CELL-EDGE cell-outside-0-up cell-0-0 n-0-0 n-0-1)
    (CELL-EDGE cell-8-0 cell-outside-0-down n-9-0 n-9-1)
    (CELL-EDGE cell-outside-1-up cell-0-1 n-0-1 n-0-2)
    (CELL-EDGE cell-8-1 cell-outside-1-down n-9-1 n-9-2)
    (CELL-EDGE cell-outside-2-up cell-0-2 n-0-2 n-0-3)
    (CELL-EDGE cell-8-2 cell-outside-2-down n-9-2 n-9-3)
    (CELL-EDGE cell-outside-3-up cell-0-3 n-0-3 n-0-4)
    (CELL-EDGE cell-8-3 cell-outside-3-down n-9-3 n-9-4)
    (CELL-EDGE cell-outside-4-up cell-0-4 n-0-4 n-0-5)
    (CELL-EDGE cell-8-4 cell-outside-4-down n-9-4 n-9-5)
    (CELL-EDGE cell-outside-5-up cell-0-5 n-0-5 n-0-6)
    (CELL-EDGE cell-8-5 cell-outside-5-down n-9-5 n-9-6)
    (CELL-EDGE cell-outside-6-up cell-0-6 n-0-6 n-0-7)
    (CELL-EDGE cell-8-6 cell-outside-6-down n-9-6 n-9-7)
    (CELL-EDGE cell-outside-7-up cell-0-7 n-0-7 n-0-8)
    (CELL-EDGE cell-8-7 cell-outside-7-down n-9-7 n-9-8)
    (CELL-EDGE cell-outside-8-up cell-0-8 n-0-8 n-0-9)
    (CELL-EDGE cell-8-8 cell-outside-8-down n-9-8 n-9-9)
    (CELL-EDGE cell-outside-9-up cell-0-9 n-0-9 n-0-10)
    (CELL-EDGE cell-8-9 cell-outside-9-down n-9-9 n-9-10)
    (CELL-EDGE cell-outside-10-up cell-0-10 n-0-10 n-0-11)
    (CELL-EDGE cell-8-10 cell-outside-10-down n-9-10 n-9-11)
    (CELL-EDGE cell-outside-11-up cell-0-11 n-0-11 n-0-12)
    (CELL-EDGE cell-8-11 cell-outside-11-down n-9-11 n-9-12)
    (CELL-EDGE cell-0-0 cell-0-1 n-0-1 n-1-1)
    (CELL-EDGE cell-1-0 cell-1-1 n-1-1 n-2-1)
    (CELL-EDGE cell-2-0 cell-2-1 n-2-1 n-3-1)
    (CELL-EDGE cell-3-0 cell-3-1 n-3-1 n-4-1)
    (CELL-EDGE cell-4-0 cell-4-1 n-4-1 n-5-1)
    (CELL-EDGE cell-5-0 cell-5-1 n-5-1 n-6-1)
    (CELL-EDGE cell-6-0 cell-6-1 n-6-1 n-7-1)
    (CELL-EDGE cell-7-0 cell-7-1 n-7-1 n-8-1)
    (CELL-EDGE cell-8-0 cell-8-1 n-8-1 n-9-1)
    (CELL-EDGE cell-0-1 cell-0-2 n-0-2 n-1-2)
    (CELL-EDGE cell-1-1 cell-1-2 n-1-2 n-2-2)
    (CELL-EDGE cell-2-1 cell-2-2 n-2-2 n-3-2)
    (CELL-EDGE cell-3-1 cell-3-2 n-3-2 n-4-2)
    (CELL-EDGE cell-4-1 cell-4-2 n-4-2 n-5-2)
    (CELL-EDGE cell-5-1 cell-5-2 n-5-2 n-6-2)
    (CELL-EDGE cell-6-1 cell-6-2 n-6-2 n-7-2)
    (CELL-EDGE cell-7-1 cell-7-2 n-7-2 n-8-2)
    (CELL-EDGE cell-8-1 cell-8-2 n-8-2 n-9-2)
    (CELL-EDGE cell-0-2 cell-0-3 n-0-3 n-1-3)
    (CELL-EDGE cell-1-2 cell-1-3 n-1-3 n-2-3)
    (CELL-EDGE cell-2-2 cell-2-3 n-2-3 n-3-3)
    (CELL-EDGE cell-3-2 cell-3-3 n-3-3 n-4-3)
    (CELL-EDGE cell-4-2 cell-4-3 n-4-3 n-5-3)
    (CELL-EDGE cell-5-2 cell-5-3 n-5-3 n-6-3)
    (CELL-EDGE cell-6-2 cell-6-3 n-6-3 n-7-3)
    (CELL-EDGE cell-7-2 cell-7-3 n-7-3 n-8-3)
    (CELL-EDGE cell-8-2 cell-8-3 n-8-3 n-9-3)
    (CELL-EDGE cell-0-3 cell-0-4 n-0-4 n-1-4)
    (CELL-EDGE cell-1-3 cell-1-4 n-1-4 n-2-4)
    (CELL-EDGE cell-2-3 cell-2-4 n-2-4 n-3-4)
    (CELL-EDGE cell-3-3 cell-3-4 n-3-4 n-4-4)
    (CELL-EDGE cell-4-3 cell-4-4 n-4-4 n-5-4)
    (CELL-EDGE cell-5-3 cell-5-4 n-5-4 n-6-4)
    (CELL-EDGE cell-6-3 cell-6-4 n-6-4 n-7-4)
    (CELL-EDGE cell-7-3 cell-7-4 n-7-4 n-8-4)
    (CELL-EDGE cell-8-3 cell-8-4 n-8-4 n-9-4)
    (CELL-EDGE cell-0-4 cell-0-5 n-0-5 n-1-5)
    (CELL-EDGE cell-1-4 cell-1-5 n-1-5 n-2-5)
    (CELL-EDGE cell-2-4 cell-2-5 n-2-5 n-3-5)
    (CELL-EDGE cell-3-4 cell-3-5 n-3-5 n-4-5)
    (CELL-EDGE cell-4-4 cell-4-5 n-4-5 n-5-5)
    (CELL-EDGE cell-5-4 cell-5-5 n-5-5 n-6-5)
    (CELL-EDGE cell-6-4 cell-6-5 n-6-5 n-7-5)
    (CELL-EDGE cell-7-4 cell-7-5 n-7-5 n-8-5)
    (CELL-EDGE cell-8-4 cell-8-5 n-8-5 n-9-5)
    (CELL-EDGE cell-0-5 cell-0-6 n-0-6 n-1-6)
    (CELL-EDGE cell-1-5 cell-1-6 n-1-6 n-2-6)
    (CELL-EDGE cell-2-5 cell-2-6 n-2-6 n-3-6)
    (CELL-EDGE cell-3-5 cell-3-6 n-3-6 n-4-6)
    (CELL-EDGE cell-4-5 cell-4-6 n-4-6 n-5-6)
    (CELL-EDGE cell-5-5 cell-5-6 n-5-6 n-6-6)
    (CELL-EDGE cell-6-5 cell-6-6 n-6-6 n-7-6)
    (CELL-EDGE cell-7-5 cell-7-6 n-7-6 n-8-6)
    (CELL-EDGE cell-8-5 cell-8-6 n-8-6 n-9-6)
    (CELL-EDGE cell-0-6 cell-0-7 n-0-7 n-1-7)
    (CELL-EDGE cell-1-6 cell-1-7 n-1-7 n-2-7)
    (CELL-EDGE cell-2-6 cell-2-7 n-2-7 n-3-7)
    (CELL-EDGE cell-3-6 cell-3-7 n-3-7 n-4-7)
    (CELL-EDGE cell-4-6 cell-4-7 n-4-7 n-5-7)
    (CELL-EDGE cell-5-6 cell-5-7 n-5-7 n-6-7)
    (CELL-EDGE cell-6-6 cell-6-7 n-6-7 n-7-7)
    (CELL-EDGE cell-7-6 cell-7-7 n-7-7 n-8-7)
    (CELL-EDGE cell-8-6 cell-8-7 n-8-7 n-9-7)
    (CELL-EDGE cell-0-7 cell-0-8 n-0-8 n-1-8)
    (CELL-EDGE cell-1-7 cell-1-8 n-1-8 n-2-8)
    (CELL-EDGE cell-2-7 cell-2-8 n-2-8 n-3-8)
    (CELL-EDGE cell-3-7 cell-3-8 n-3-8 n-4-8)
    (CELL-EDGE cell-4-7 cell-4-8 n-4-8 n-5-8)
    (CELL-EDGE cell-5-7 cell-5-8 n-5-8 n-6-8)
    (CELL-EDGE cell-6-7 cell-6-8 n-6-8 n-7-8)
    (CELL-EDGE cell-7-7 cell-7-8 n-7-8 n-8-8)
    (CELL-EDGE cell-8-7 cell-8-8 n-8-8 n-9-8)
    (CELL-EDGE cell-0-8 cell-0-9 n-0-9 n-1-9)
    (CELL-EDGE cell-1-8 cell-1-9 n-1-9 n-2-9)
    (CELL-EDGE cell-2-8 cell-2-9 n-2-9 n-3-9)
    (CELL-EDGE cell-3-8 cell-3-9 n-3-9 n-4-9)
    (CELL-EDGE cell-4-8 cell-4-9 n-4-9 n-5-9)
    (CELL-EDGE cell-5-8 cell-5-9 n-5-9 n-6-9)
    (CELL-EDGE cell-6-8 cell-6-9 n-6-9 n-7-9)
    (CELL-EDGE cell-7-8 cell-7-9 n-7-9 n-8-9)
    (CELL-EDGE cell-8-8 cell-8-9 n-8-9 n-9-9)
    (CELL-EDGE cell-0-9 cell-0-10 n-0-10 n-1-10)
    (CELL-EDGE cell-1-9 cell-1-10 n-1-10 n-2-10)
    (CELL-EDGE cell-2-9 cell-2-10 n-2-10 n-3-10)
    (CELL-EDGE cell-3-9 cell-3-10 n-3-10 n-4-10)
    (CELL-EDGE cell-4-9 cell-4-10 n-4-10 n-5-10)
    (CELL-EDGE cell-5-9 cell-5-10 n-5-10 n-6-10)
    (CELL-EDGE cell-6-9 cell-6-10 n-6-10 n-7-10)
    (CELL-EDGE cell-7-9 cell-7-10 n-7-10 n-8-10)
    (CELL-EDGE cell-8-9 cell-8-10 n-8-10 n-9-10)
    (CELL-EDGE cell-0-10 cell-0-11 n-0-11 n-1-11)
    (CELL-EDGE cell-1-10 cell-1-11 n-1-11 n-2-11)
    (CELL-EDGE cell-2-10 cell-2-11 n-2-11 n-3-11)
    (CELL-EDGE cell-3-10 cell-3-11 n-3-11 n-4-11)
    (CELL-EDGE cell-4-10 cell-4-11 n-4-11 n-5-11)
    (CELL-EDGE cell-5-10 cell-5-11 n-5-11 n-6-11)
    (CELL-EDGE cell-6-10 cell-6-11 n-6-11 n-7-11)
    (CELL-EDGE cell-7-10 cell-7-11 n-7-11 n-8-11)
    (CELL-EDGE cell-8-10 cell-8-11 n-8-11 n-9-11)
    (CELL-EDGE cell-outside-0-left cell-0-0 n-0-0 n-1-0)
    (CELL-EDGE cell-0-11 cell-outside-0-right n-0-12 n-1-12)
    (CELL-EDGE cell-outside-1-left cell-1-0 n-1-0 n-2-0)
    (CELL-EDGE cell-1-11 cell-outside-1-right n-1-12 n-2-12)
    (CELL-EDGE cell-outside-2-left cell-2-0 n-2-0 n-3-0)
    (CELL-EDGE cell-2-11 cell-outside-2-right n-2-12 n-3-12)
    (CELL-EDGE cell-outside-3-left cell-3-0 n-3-0 n-4-0)
    (CELL-EDGE cell-3-11 cell-outside-3-right n-3-12 n-4-12)
    (CELL-EDGE cell-outside-4-left cell-4-0 n-4-0 n-5-0)
    (CELL-EDGE cell-4-11 cell-outside-4-right n-4-12 n-5-12)
    (CELL-EDGE cell-outside-5-left cell-5-0 n-5-0 n-6-0)
    (CELL-EDGE cell-5-11 cell-outside-5-right n-5-12 n-6-12)
    (CELL-EDGE cell-outside-6-left cell-6-0 n-6-0 n-7-0)
    (CELL-EDGE cell-6-11 cell-outside-6-right n-6-12 n-7-12)
    (CELL-EDGE cell-outside-7-left cell-7-0 n-7-0 n-8-0)
    (CELL-EDGE cell-7-11 cell-outside-7-right n-7-12 n-8-12)
    (CELL-EDGE cell-outside-8-left cell-8-0 n-8-0 n-9-0)
    (CELL-EDGE cell-8-11 cell-outside-8-right n-8-12 n-9-12)

    
)
(:goal
    (and
        (not (node-degree1 n-0-0))
        (not (node-degree1 n-0-1))
        (not (node-degree1 n-0-10))
        (not (node-degree1 n-0-11))
        (not (node-degree1 n-0-12))
        (not (node-degree1 n-0-2))
        (not (node-degree1 n-0-3))
        (not (node-degree1 n-0-4))
        (not (node-degree1 n-0-5))
        (not (node-degree1 n-0-6))
        (not (node-degree1 n-0-7))
        (not (node-degree1 n-0-8))
        (not (node-degree1 n-0-9))
        (not (node-degree1 n-1-0))
        (not (node-degree1 n-1-1))
        (not (node-degree1 n-1-10))
        (not (node-degree1 n-1-11))
        (not (node-degree1 n-1-12))
        (not (node-degree1 n-1-2))
        (not (node-degree1 n-1-3))
        (not (node-degree1 n-1-4))
        (not (node-degree1 n-1-5))
        (not (node-degree1 n-1-6))
        (not (node-degree1 n-1-7))
        (not (node-degree1 n-1-8))
        (not (node-degree1 n-1-9))
        (not (node-degree1 n-2-0))
        (not (node-degree1 n-2-1))
        (not (node-degree1 n-2-10))
        (not (node-degree1 n-2-11))
        (not (node-degree1 n-2-12))
        (not (node-degree1 n-2-2))
        (not (node-degree1 n-2-3))
        (not (node-degree1 n-2-4))
        (not (node-degree1 n-2-5))
        (not (node-degree1 n-2-6))
        (not (node-degree1 n-2-7))
        (not (node-degree1 n-2-8))
        (not (node-degree1 n-2-9))
        (not (node-degree1 n-3-0))
        (not (node-degree1 n-3-1))
        (not (node-degree1 n-3-10))
        (not (node-degree1 n-3-11))
        (not (node-degree1 n-3-12))
        (not (node-degree1 n-3-2))
        (not (node-degree1 n-3-3))
        (not (node-degree1 n-3-4))
        (not (node-degree1 n-3-5))
        (not (node-degree1 n-3-6))
        (not (node-degree1 n-3-7))
        (not (node-degree1 n-3-8))
        (not (node-degree1 n-3-9))
        (not (node-degree1 n-4-0))
        (not (node-degree1 n-4-1))
        (not (node-degree1 n-4-10))
        (not (node-degree1 n-4-11))
        (not (node-degree1 n-4-12))
        (not (node-degree1 n-4-2))
        (not (node-degree1 n-4-3))
        (not (node-degree1 n-4-4))
        (not (node-degree1 n-4-5))
        (not (node-degree1 n-4-6))
        (not (node-degree1 n-4-7))
        (not (node-degree1 n-4-8))
        (not (node-degree1 n-4-9))
        (not (node-degree1 n-5-0))
        (not (node-degree1 n-5-1))
        (not (node-degree1 n-5-10))
        (not (node-degree1 n-5-11))
        (not (node-degree1 n-5-12))
        (not (node-degree1 n-5-2))
        (not (node-degree1 n-5-3))
        (not (node-degree1 n-5-4))
        (not (node-degree1 n-5-5))
        (not (node-degree1 n-5-6))
        (not (node-degree1 n-5-7))
        (not (node-degree1 n-5-8))
        (not (node-degree1 n-5-9))
        (not (node-degree1 n-6-0))
        (not (node-degree1 n-6-1))
        (not (node-degree1 n-6-10))
        (not (node-degree1 n-6-11))
        (not (node-degree1 n-6-12))
        (not (node-degree1 n-6-2))
        (not (node-degree1 n-6-3))
        (not (node-degree1 n-6-4))
        (not (node-degree1 n-6-5))
        (not (node-degree1 n-6-6))
        (not (node-degree1 n-6-7))
        (not (node-degree1 n-6-8))
        (not (node-degree1 n-6-9))
        (not (node-degree1 n-7-0))
        (not (node-degree1 n-7-1))
        (not (node-degree1 n-7-10))
        (not (node-degree1 n-7-11))
        (not (node-degree1 n-7-12))
        (not (node-degree1 n-7-2))
        (not (node-degree1 n-7-3))
        (not (node-degree1 n-7-4))
        (not (node-degree1 n-7-5))
        (not (node-degree1 n-7-6))
        (not (node-degree1 n-7-7))
        (not (node-degree1 n-7-8))
        (not (node-degree1 n-7-9))
        (not (node-degree1 n-8-0))
        (not (node-degree1 n-8-1))
        (not (node-degree1 n-8-10))
        (not (node-degree1 n-8-11))
        (not (node-degree1 n-8-12))
        (not (node-degree1 n-8-2))
        (not (node-degree1 n-8-3))
        (not (node-degree1 n-8-4))
        (not (node-degree1 n-8-5))
        (not (node-degree1 n-8-6))
        (not (node-degree1 n-8-7))
        (not (node-degree1 n-8-8))
        (not (node-degree1 n-8-9))
        (not (node-degree1 n-9-0))
        (not (node-degree1 n-9-1))
        (not (node-degree1 n-9-10))
        (not (node-degree1 n-9-11))
        (not (node-degree1 n-9-12))
        (not (node-degree1 n-9-2))
        (not (node-degree1 n-9-3))
        (not (node-degree1 n-9-4))
        (not (node-degree1 n-9-5))
        (not (node-degree1 n-9-6))
        (not (node-degree1 n-9-7))
        (not (node-degree1 n-9-8))
        (not (node-degree1 n-9-9))

        (CELL-CAPACITY cell-0-0 cap-0)
        (CELL-CAPACITY cell-0-1 cap-0)
        (CELL-CAPACITY cell-0-2 cap-0)
        (CELL-CAPACITY cell-0-4 cap-0)
        (CELL-CAPACITY cell-0-5 cap-0)
        (CELL-CAPACITY cell-0-7 cap-0)
        (CELL-CAPACITY cell-0-10 cap-0)
        (CELL-CAPACITY cell-1-1 cap-0)
        (CELL-CAPACITY cell-1-3 cap-0)
        (CELL-CAPACITY cell-1-4 cap-0)
        (CELL-CAPACITY cell-1-5 cap-0)
        (CELL-CAPACITY cell-2-9 cap-0)
        (CELL-CAPACITY cell-2-10 cap-0)
        (CELL-CAPACITY cell-2-11 cap-0)
        (CELL-CAPACITY cell-3-2 cap-0)
        (CELL-CAPACITY cell-3-3 cap-0)
        (CELL-CAPACITY cell-3-4 cap-0)
        (CELL-CAPACITY cell-3-6 cap-0)
        (CELL-CAPACITY cell-3-7 cap-0)
        (CELL-CAPACITY cell-3-10 cap-0)
        (CELL-CAPACITY cell-4-0 cap-0)
        (CELL-CAPACITY cell-4-2 cap-0)
        (CELL-CAPACITY cell-4-5 cap-0)
        (CELL-CAPACITY cell-4-8 cap-0)
        (CELL-CAPACITY cell-4-10 cap-0)
        (CELL-CAPACITY cell-5-1 cap-0)
        (CELL-CAPACITY cell-5-3 cap-0)
        (CELL-CAPACITY cell-5-6 cap-0)
        (CELL-CAPACITY cell-5-7 cap-0)
        (CELL-CAPACITY cell-5-8 cap-0)
        (CELL-CAPACITY cell-5-11 cap-0)
        (CELL-CAPACITY cell-6-7 cap-0)
        (CELL-CAPACITY cell-6-10 cap-0)
        (CELL-CAPACITY cell-6-11 cap-0)
        (CELL-CAPACITY cell-7-1 cap-0)
        (CELL-CAPACITY cell-7-3 cap-0)
        (CELL-CAPACITY cell-7-5 cap-0)
        (CELL-CAPACITY cell-7-7 cap-0)
        (CELL-CAPACITY cell-7-11 cap-0)
        (CELL-CAPACITY cell-8-1 cap-0)
        (CELL-CAPACITY cell-8-3 cap-0)
        (CELL-CAPACITY cell-8-6 cap-0)
        (CELL-CAPACITY cell-8-8 cap-0)
        (CELL-CAPACITY cell-8-10 cap-0)
    )
)
)


