#ifndef SUBSUMPTION_TRIE_H
#define SUBSUMPTION_TRIE_H

#include <vector>
#include <cstddef>

#include "global_state.h"
#include "search_space.h"
class TrieNode {
private:
    std::vector<TrieNode *> children;
    StateID id;
public:
    TrieNode(size_t size);
    ~TrieNode();
    TrieNode* get_child(size_t index);
    size_t get_size();
    void insert_child(size_t index, TrieNode* child);
    void set_id(StateID id);
    StateID get_id();
};

class SubsumptionTrie {
private:
    TrieNode *root;
    SearchSpace *search_space;
    void lookup(const GlobalState& state, TrieNode* node, size_t level, bool& subsuming_found);
    void insert(const GlobalState& state, TrieNode* node, size_t level);
    void delete_node(TrieNode* node);
public:
    SubsumptionTrie();
    ~SubsumptionTrie();
    void insert(const GlobalState& state);
    bool lookup(const GlobalState& state);
    void attach_search_space(SearchSpace* search_space);

};

#endif
