#ifndef REGRESSION_SEARCH_H
#define REGRESSION_SEARCH_H

#include "eager_search.h"
#include "subsumption_trie.h"
class RegressionSearch : public EagerSearch {
protected:
    bool use_subsumption_check;
    bool use_subsumption_trie;
    SubsumptionTrie subsumption_trie;
    virtual SearchStatus step();
    virtual void initialize();
    void generate_applicable_ops_regression(
        const GlobalState &s, std::vector<const GlobalOperator *> &applicable_ops);
    bool check_goal_and_set_plan_regression(const GlobalState &state);
public:
    RegressionSearch(const Options &opts);

};

#endif
