set(Libtorch_HINT_PATHS
    ${LIBTORCH_ROOT}
    $ENV{LIBTORCH_ROOT}
)

find_path(Libtorch_INCLUDE_DIRS
    NAMES "torch.h"
    HINTS ${Libtorch_HINT_PATHS}
    PATH_SUFFIXES include
)

find_library(Libtorch_LIBRARIES
    NAMES torch
    HINTS ${Libtorch_HINT_PATHS}
    PATH_SUFFIXES lib
)

# Check if everything was found and set Libtorch_FOUND.
include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    Libtorch
    REQUIRED_VARS Libtorch_INCLUDE_DIRS Libtorch_LIBRARIES
)
