#!/bin/bash

# Directory containing output txt files
INPUT_DIR="blocksworld_infinity_outputs_all_states"
OUTPUT_FILE="$INPUT_DIR/final_results.csv"

# Initialize the output file with a header
echo "File Name, Infinity-DDA" > "$OUTPUT_FILE"

# Loop through all .txt files
for FILE in "$INPUT_DIR"/*.txt; do
    BASENAME=$(basename "$FILE" .txt)

    # Default value
    INFINITY_DDA="no"

    # Check if the file contains the specific string
    if grep -q "Infinity-DDA property fullfilled" "$FILE"; then
        INFINITY_DDA="yes"
    fi

    # Write result to the CSV
    echo "$BASENAME, $INFINITY_DDA" >> "$OUTPUT_FILE"
done

echo "Results written to $OUTPUT_FILE"
