#ifndef PHO_STATE_EQUATION_CONSTRAINTS_H
#define PHO_STATE_EQUATION_CONSTRAINTS_H

#include "constraint_generator.h"

#include "../operator.h"
#include "../option_parser.h"
#include "../state.h"

#include <set>

class Options;

namespace pho {
// A proposition has an index and refer to an atom of the form Var = Val.
struct Proposition {
    int lower_bound_constraint_index;
    int upper_bound_constraint_index;
    std::set<int> always_produced_by;
    std::set<int> sometimes_produced_by;
    std::set<int> always_consumed_by;
    std::set<int> sometimes_consumed_by;

    Proposition()
        : lower_bound_constraint_index(-1),
          upper_bound_constraint_index(-1) {
    }
};

class LPConstraint;
class LPConstraintCollection;

class StateEquationConstraints : public ConstraintGenerator {
    enum VariableSituationInGoal {
        VAR_UNDEFINED_IN_GOAL = 0,
        VAR_HAS_VAL_IN_GOAL = 1,
        VAR_HAS_OTHER_VAL_IN_GOAL = 2
    };
    enum VariableSituationInState {
        VAR_HAS_VAL_IN_STATE = 0,
        VAR_HAS_OTHER_VAL_IN_STATE = 1
    };
    // Could be implemented as static const int arrays but the initialization
    // is much more confusing than using enums in the constructor.
    double net_change_lower_bound[3][2];
    double net_change_upper_bound[3][2];
    double one_safe_upper_bound[3][2];

    bool use_lower_bound_constraints;
    bool use_upper_bound_constraints;
    bool use_1safe_information;

    std::vector<bool> one_safe;
    std::vector<std::vector<Proposition> > propositions;
    std::vector<state_var_t> goal_state;
    int constraint_offset;

    void build_propositions();
    void add_indices_to_constraints(LPConstraint &constraint,
                                    const std::set<int> &indices,
                                    double coefficient) const;
    void add_constraints(LPConstraintCollection &constraint_collection);
public:
    StateEquationConstraints(const ::Options &opts);
    virtual ~StateEquationConstraints();
    virtual void initialize_constraints(LPConstraintCollection &constraint_collection, std::vector<bool> &filter);
    virtual bool update_constraints(const State &state, OperatorCountLP &lp);
};
}

#endif
