#ifndef PHO_OPERATOR_COUNT_LP_H
#define PHO_OPERATOR_COUNT_LP_H

#include "../lp_solver_interface.h"
#include "../operator_cost.h"

#include <vector>

class EquivalenceRelation;

namespace pho {
class LPVariable;
class LPConstraint;
class LPConstraintCollection;

class OperatorCountLP {
    OperatorCost cost_type;

    bool is_solved;
    bool is_objective_function_modified;
    bool has_temporary_constraints;
    int num_permanent_constraints;
    //int *constraint_bound;

    EquivalenceRelation *merged_variables;
    std::vector<double> reference_values;
    bool has_modified_merge_representatives;

    OsiSolverInterface *lp_solver;
    void merge_variables(const LPConstraintCollection &constraint_collection);
    void refine_merged_variables(const std::vector<LPVariable> &variables);
    void refine_merged_variables(const std::vector<LPConstraint> &constraints);
    void set_merged_variable_bounds();
public:
    OperatorCountLP(const LPConstraintCollection &constraint_collection,
                    bool merge_lp_variables, LPSolverType solver_type,
                    OperatorCost cost_type_);
    ~OperatorCountLP();

    int get_num_variables() const;
    int get_num_zero_variables() const;
    int get_num_constraints() const;
    void print_statistics(std::string location) const;

    void set_permanent_constraint_lower_bound(int constraint_id, double lower_bound);
    void set_permanent_constraint_upper_bound(int constraint_id, double upper_bound);
    void add_temporary_constraints(const std::vector<LPConstraint> &constraints);
    void solve();
    size_t update_binding_count(std::vector<std::pair<int,int> > &activityCounts) const;
    void remove_constraints(const int num, const int *rowIndices);
    bool has_feasible_solution() const;
    int get_heuristic_value() const;
    void remove_temporary_constraints();
};
}

#endif
