#ifndef PHO_LP_CONSTRAINT_COLLECTION_H
#define PHO_LP_CONSTRAINT_COLLECTION_H

#include <limits>
#include <vector>

#include "../lp_solver_interface.h"

class CoinPackedVector;
class CoinPackedVectorBase;

namespace pho {

double translate_infinity(double value, OsiSolverInterface *lp_solver);

class LPConstraint {
    std::vector<int> indices;
    std::vector<double> coefficients;
    double lower_bound;
    double upper_bound;
public:
    LPConstraint();
    ~LPConstraint();

    const std::vector<int> &get_indices() const {return indices; }
    const std::vector<double> &get_coefficients() const {return coefficients; }
    double get_lower_bound() const {return lower_bound; }
    void set_lower_bound(double lb) {lower_bound = lb; }
    double get_upper_bound() const {return upper_bound; }
    void set_upper_bound(double ub) {upper_bound = ub; }

    bool empty() const;
    void insert(int index, double coefficient);
};

struct LPVariable {
    double lower_bound;
    double upper_bound;
    double objective;

    LPVariable(double lower_bound_, double upper_bound_, double objective_)
        : lower_bound(lower_bound_),
          upper_bound(upper_bound_),
          objective(objective_) {
    }
    ~LPVariable() {
    }
};

class LPConstraintCollection {
    std::vector<LPConstraint> constraints;
    std::vector<LPVariable> variables;
public:
    const std::vector<LPConstraint> &get_constraints() const {return constraints; }
    const std::vector<LPVariable> &get_variables() const {return variables; }

    // Adds a variable to the collection and returns its index that should be
    // used in constraints.
    int add_variable(LPVariable var);
    // Convenience method to add n copies of the given variable and return the
    // index of the first. The created variables will have continous indices
    // starting from the returned value.
    int add_variables(int n, LPVariable var);
    // Adds the given constraints to the collection and returns the index of the
    // first. The created constraints will have continous indices
    // starting from the returned value.
    // NOTE the constraints will be copied here. We could avoid this by allowing
    //      ConstraintGenerators direct access to the constraints member
    //      (turning the class into a struct) but this would also expose constraints
    //      from other ConstraintGenerators.
    int add_constraints(const std::vector<LPConstraint> &new_constraints);
};

struct CoinRows {
    int num_rows;
    bool owns_data;
    double *lower_bounds;
    double *upper_bounds;
    CoinPackedVectorBase **rows;
    CoinPackedVector *create_coin_vector(const LPConstraint &constraint,
                                         OsiSolverInterface *lp_solver) const;
    CoinRows(const std::vector<LPConstraint> &constraints,
             OsiSolverInterface *lp_solver);
    ~CoinRows();

    void release_ownership();
};

struct CoinColumns {
    int num_cols;
    bool owns_data;
    double *lower_bounds;
    double *upper_bounds;
    double *objective;
    CoinColumns(const std::vector<LPVariable> &variables,
                OsiSolverInterface *lp_solver);
    ~CoinColumns();

    void release_ownership();
};

}

#endif
