#include "lm_cut_constraints.h"

#include "constraint_generator.h"
#include "lp_constraint_collection.h"
#include "operator_count_lp.h"

#include "../lm_cut_heuristic.h"
#include "../option_parser.h"
#include "../plugin.h"

namespace pho {
LMCutConstraints::LMCutConstraints(const Options &opts) {
    // TODO In the long term, heuristics should be parameters (with default values).
    //      See also the comment on reach_state in constraint_generator.h
    heuristic = new LandmarkCutHeuristic(opts);
    heuristic->start_storing_landmarks();
}

LMCutConstraints::~LMCutConstraints() {
    delete heuristic;
}

bool LMCutConstraints::reach_state(const State &parent_state, const Operator &op,
                                   const State &state) {
    // NOTE that this does nothing for the regular LM-cut heuristic but would be
    //      important if we ever try a different heuristic, e.g. the incremental
    //      LM-cut heuristic.
    return heuristic->reach_state(parent_state, op, state);
}

bool LMCutConstraints::update_constraints(const State &state, OperatorCountLP &lp) {
    heuristic->evaluate(state);
    if (heuristic->is_dead_end()) {
        return true;
    }
    const vector<pair<vector<const Operator *>, int> > &landmarks = heuristic->get_last_landmarks();
    int num_rows = landmarks.size();
    vector<LPConstraint> constraints(num_rows);
    for (size_t i = 0; i < num_rows; ++i) {
        const vector<const Operator *> &landmark_ops = landmarks[i].first;
        for (size_t op_id = 0; op_id < landmark_ops.size(); ++op_id) {
            const Operator *op = landmark_ops[op_id];
            constraints[i].insert(op->get_operator_index(), 1.0);
        }
        constraints[i].set_lower_bound(1.0);
    }
    lp.add_temporary_constraints(constraints);
    return false;
}

static ConstraintGenerator *_parse(OptionParser &parser) {
    Heuristic::add_options_to_parser(parser);
    Options opts = parser.parse();
    if (parser.dry_run())
        return 0;
    return new LMCutConstraints(opts);
}

static Plugin<ConstraintGenerator> _plugin("lmcut_constraints", _parse);
}
