#include "dead_end_detection_constraints.h"

#include "../plugin.h"

namespace pho {
DeadEndDetectionConstraints::DeadEndDetectionConstraints(const Options &opts)
    : heuristic(opts.get<Heuristic *>("heuristic")) {
}

DeadEndDetectionConstraints::~DeadEndDetectionConstraints() {
}

bool DeadEndDetectionConstraints::reach_state(const State &parent_state, const Operator &op,
                                              const State &state) {
    return heuristic->reach_state(parent_state, op, state);
}

bool DeadEndDetectionConstraints::update_constraints(const State &state, OperatorCountLP & /*lp*/) {
    heuristic->evaluate(state);
    return heuristic->is_dead_end();
}

static ConstraintGenerator *_parse(OptionParser &parser) {
    parser.add_option<Heuristic *>("heuristic",
                                   "Use dead end detection of this heuristic, "
                                   "i.e. do not evaluate the LP if the given "
                                   "heuristic reports a dead end.");
    Heuristic::add_options_to_parser(parser);
    Options opts = parser.parse();
    if (parser.dry_run())
        return 0;
    return new DeadEndDetectionConstraints(opts);
}

static Plugin<ConstraintGenerator> _plugin("dead_end_detection", _parse);
}
