#ifndef PHO_CONSTRAINT_GENERATOR_H
#define PHO_CONSTRAINT_GENERATOR_H

#include "../operator.h"
#include "../operator_cost.h"
#include "../option_parser.h"
#include "../state.h"

class Options;

namespace pho {
class LPConstraintCollection;
class OperatorCountLP;

class ConstraintGenerator {
public:
    /*
      Add permanent constraints and/or additional variables.
    */
    virtual void initialize_constraints(LPConstraintCollection & /*constraint_collection*/, std::vector<bool> &/*filter*/) { }

    /*
      This method can be used to inform heuristics that are part of the
      ConstraintGenerator that a new state was reached.
    */
    // TODO In the long term, we should use the existing mechanisms here.
    //      Heuristics should be collected with get_involved_heuristics and
    //      then evaluated by the search algorithm.
    //      Currently this is not possible, because the evaluations are not
    //      necessarily evaluated in the correct order.
    virtual bool reach_state(const State & /*parent_state*/, const Operator & /*op*/,
                             const State & /*state*/) {return false; }
    /*
      Set bounds on permanent constraints or add temporary constraints.
      Returns true if a dead end was detected and false otherwise.
    */
    virtual bool update_constraints(const State &state, OperatorCountLP &lp) = 0;
};
}

#endif
