#ifndef PDB_LP_HEURISTIC_H
#define PDB_LP_HEURISTIC_H

#include "heuristic.h"
#include "option_parser.h"
#include "lp_solver_interface.h"

#ifdef USE_LP
#include "CoinPackedVector.hpp"
#include "CoinPackedMatrix.hpp"
#include <sys/times.h>
#endif

class LandmarkCutHeuristic;
class CanonicalPDBsHeuristic;
class PDBHeuristic;

class PDBLPHeuristic : public Heuristic {
    LandmarkCutHeuristic *lmcut;
    int landmark_count;
    bool merge_operators;
    std::vector<PDBHeuristic *> heuristics;
    bool borrowed_heuristics;
    CanonicalPDBsHeuristic *canonical;
    int size;
#ifdef USE_LP
    OsiSolverInterface *lp_solver;
#endif
    void generateLP();

protected:
    virtual void initialize();
    virtual int compute_heuristic(const State &state);
public:
    PDBLPHeuristic(const Options &opts);
    ~PDBLPHeuristic();

    void clear_pdbs();
    void set_pdbs(std::vector<PDBHeuristic *> heuristics, bool borrowed_heuristics);
    const std::vector<PDBHeuristic *> &get_pattern_databases() const {return heuristics; }
    int get_size() const {return size; }
    // WARNING: For now, this is not incremental and just recomputes everything from scratch.
    // This could be easily changed to accept a PDBHeuristic instead but for now we prefer the
    // better comparability with iPDB.
    void add_pattern(const std::vector<int> &pattern);
};

#endif
