#ifndef PHO_POSTHOC_OPTIMIZATION_HEURISTIC_H
#define PHO_POSTHOC_OPTIMIZATION_HEURISTIC_H

#include "../heuristic.h"
#include "../option_parser.h"

#include "constraint_generator.h"
#include "operator_count_lp.h"

#include <vector>

namespace pho {
class PosthocOptimizationHeuristic : public Heuristic {
    // Variables that always occur together can be merged if there are no temporary constraint generators.
    bool merge_lp_variables;
    int pruning_samples,prune_num_constraints;
    std::vector<ConstraintGenerator *> constraint_generators;
    LPSolverType lp_solver_type;
    OperatorCountLP *lp;
    Options opts;
    void sample_states(std::vector<State> &samples, int num_samples, double average_operator_cost, Heuristic *heuristic);
protected:
    virtual void initialize();
    virtual bool reach_state(const State &parent_state, const Operator &op,
                             const State &state);
    virtual int compute_heuristic(const State &state);
public:
    PosthocOptimizationHeuristic(const Options &opts);
    ~PosthocOptimizationHeuristic();
    virtual void print_statistics() const;
};
}

#endif
