#ifndef PHO_PDB_CONSTRAINTS_H
#define PHO_PDB_CONSTRAINTS_H

#include "constraint_generator.h"

class CanonicalPDBsHeuristic;
class PDBHeuristic;

namespace pho {
class PDBConstraints : public ConstraintGenerator {
    OperatorCost cost_type;
    std::vector<PDBHeuristic *> heuristics;
    bool borrowed_heuristics;
    CanonicalPDBsHeuristic *canonical;
    int size, num_pdb_limit;

    int constraint_offset;
    
    void sample_states(std::vector<State> &samples, int num_samples, double average_operator_cost, Heuristic *heuristic);
public:
    PDBConstraints(const Options &opts);
    ~PDBConstraints();
    virtual void initialize_constraints(LPConstraintCollection &constraint_collection, std::vector<bool> &filter);
    virtual bool reach_state(const State &parent_state, const Operator &op,
                             const State &state);
    virtual bool update_constraints(const State &state, OperatorCountLP &lp);
};
}

#endif
