#ifndef PHO_LM_COUNT_CONSTRAINTS_H
#define PHO_LM_COUNT_CONSTRAINTS_H

#include "constraint_generator.h"

#include "../landmarks/landmark_graph.h"
#include "../landmarks/landmark_status_manager.h"

#include <set>

namespace pho {
// TODO avoid code duplication with LandmarkCountHeuristic
class LMCountConstraints : public ConstraintGenerator {
    LandmarkGraph &lm_graph;
    LandmarkStatusManager lm_status_manager;
    const std::set<int> empty;
    const std::set<int> &get_achievers(int lmn_status,
                                       const LandmarkNode &lmn) const;
public:
    LMCountConstraints(const Options &opts);
    virtual ~LMCountConstraints();

    virtual bool reach_state(const State &parent_state, const Operator &op,
                             const State &state);
    virtual bool update_constraints(const State &state, OperatorCountLP &lp);
};
}

#endif
