#ifndef PHO_DEAD_END_DETECTION_CONSTRAINTS_H
#define PHO_DEAD_END_DETECTION_CONSTRAINTS_H

#include "constraint_generator.h"

#include "../heuristic.h"
#include "../option_parser.h"

/*
  Despite its name this ConstraintGenerator does not generate any constraints.
  It just evaluates the given heuristic and forwards the result of is_dead_end().
  Having this functionality as a ConstraintGenerator allows to have short-circuit
  evaluation in h^pho, i.e. other ConstraintGenerators are only evaluated if the
  given heuristic does not report a dead end.
*/
// TODO: In the long run we should think about implementing this as a general
//       mechanism in the planner.
namespace pho {
class DeadEndDetectionConstraints : public ConstraintGenerator {
    Heuristic *heuristic;
public:
    DeadEndDetectionConstraints(const Options &opts);
    virtual ~DeadEndDetectionConstraints();

    virtual bool reach_state(const State &parent_state, const Operator &op,
                             const State &state);
    virtual bool update_constraints(const State &state, OperatorCountLP &lp);
};
}

#endif
