/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.matthatem.ai.msa.heuristics;

import com.matthatem.ai.msa.MSAHeuristic;
import com.matthatem.ai.msa.SubMatrix;
import com.matthatem.ai.msa.MSA.MSAState;

/**
 * A heuristic that uses a combination of 2D and 3D heuristics.
 * 
 * @author Matthew Hatem
 */
public class HeuristicALL3 implements MSAHeuristic {

  private MSAHeuristic[] h3dTable; 
  private MSAHeuristic[] h2dTable; 
  private int[][] h3dIndex;
  private int[][] h2dIndex;
  
  private int l;
  public static enum TYPE {DOUBLE, INT};
  
  public HeuristicALL3(char[][] seqs, SubMatrix sm, double weight) {
    this(seqs, sm, TYPE.DOUBLE, weight);  
  }
  
  public HeuristicALL3(char[][] seqs, SubMatrix sm, TYPE type, double weight) {
    // build the 3D table
	  //hardcode n chose 3
	  l = seqs.length;
	  int n = 0;
	  if(seqs.length == 3)
		  n = 1;
	  else if(seqs.length == 4)
		  n = 4;
	  else if (seqs.length == 5)
		  n = 10;
	  else if (seqs.length == 6)
		  n = 20;
    h3dTable = new Heuristic3D[n];
    h3dIndex = new int[n][3];
    
    int h3di=0;
    for (int i=0; i<seqs.length-1; i++) {
    	for(int j = i+1;j<seqs.length-1;j++){
    		for(int k = j+1;k<seqs.length;k++){
		      char[][] seqSub1 = new char[3][];
		      h3dIndex[h3di][0] = i; 
		      h3dIndex[h3di][1] = j; 
		      h3dIndex[h3di][2] = k;
		      seqSub1[0] = new String(seqs[h3dIndex[h3di][0]]).trim().toCharArray();
		      seqSub1[1] = new String(seqs[h3dIndex[h3di][1]]).trim().toCharArray();
		      seqSub1[2] = new String(seqs[h3dIndex[h3di][2]]).trim().toCharArray();
		      System.out.print("{ "+h3dIndex[h3di][0]+ ", "+h3dIndex[h3di][1]+", "+h3dIndex[h3di][2]+ " }");
		
		        h3dTable[h3di] = new Heuristic3D(seqSub1, sm, weight);
		    	
		      h3di++;
    		}
    	}
    }
    System.out.print("\n");
  }
  
  int binom(int n, int k)
  {
     assert(n >= k);
     int r = 1;
     for(int i = 0; i <= k; ++i)
     {
        r *= n-i;
        r /= i+1;
     }
     return r;
  }
  
  public double getInitH() {
      System.out.println("h3dTable length: "+h3dTable.length);
    double initH = 0;
    for (int i=0; i<h3dTable.length; i++)
      initH += h3dTable[i].getInitH();
    
    initH/=(l-2);
    return (int)initH;
  }

  public double getH(MSAState state, int[] delta, int[] index) {
    throw new IllegalArgumentException();
  }
  
  public double getH(MSAState state, int[] delta) {
    double h = 0;
    for (int i=0; i<h3dTable.length; i++)
      h += h3dTable[i].getH(state, delta, h3dIndex[i]);
    
    h/=(l-2);
    return (int)h;
  }

}
