/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.matthatem.ai.msa.heuristics;

import com.matthatem.ai.msa.MSAHeuristic;
import com.matthatem.ai.msa.SubMatrix;
import com.matthatem.ai.msa.MSA.MSAState;

/**
 * A 2D heuristic for MSA with affine gap costs.
 * 
 * @author Matthew Hatem
 */
public class Heuristic2DFactoredOps implements MSAHeuristic {
	
	  private static final int DG = 0;
	  private static final int HZ = 1;
	  private static final int VT = 2;
  
  private double lrGapCost;
  private double weight;
  
  private char[][] seqs;
  private double D[][];
  private double[][] scoreTable;
private int[][][] Ops;
private int n;
private int m;
    
  public Heuristic2DFactoredOps(char[][] seqs, SubMatrix sm, double weight, int[][][] Ops) {
    D = sm.getTable();
    this.Ops = Ops;

    this.seqs = seqs;
    lrGapCost = sm.getLinearGapCost();
    this.weight = weight;
    compute();
  }

  private void compute() {

        char[] A = new String(seqs[0]).trim().toCharArray();
        char[] B = new String(seqs[1]).trim().toCharArray();
        System.out.println(A);
        System.out.println(B);
  }
  
  private double[][] DP2(char[] A, char[] B) {
    int i, j;
    int pos, end;
    n = A.length;
    m = B.length;
    double P[][] = new double [n+1][m+1];

    end = m;
    P[n][end] = 0;
    pos = end-1;
    for (j = m - 1; j >= 0; --j, pos -= 1) {
      P[n][pos] = P[n][pos+1] + Ops[pos][n][HZ];
    }
    for (i = n - 1; i >= 0; --i) {
      P[i][end] = P[i + 1][end] + Ops[end][i][VT];

      for (j = m - 1; j >= 0; --j, pos -= 1) {
    	  P[i][j] = min((int)(P[i + 1][j] + Ops[j][i][VT]), (int)(P[i + 1][j+1] + Ops[j][i][DG]), (int)(P[i][j+1]+Ops[j][i][HZ]));
        //P[i][j] = min(P[i + 1][j]+lrGapCost,P[i + 1][j+1]+D[A[i]][B[j]],P[i][j+1]+lrGapCost) ;

      }
    } 
    return P;
  }
  
  public double getH(MSAState state, int[] delta, int[] index) {
    int[] pos = state.pos;
    double cost = 0.0f;
    for (int i=1; i<seqs.length; i++) {
      for (int j = 0; j < i; j++) {
        int di = index[i]; int dj = index[j];
        int col = pos[index[i]]; int row = pos[index[j]];
        cost += scoreTable[col][row];
      }
    }
    return weight*cost;
  }
  
  public double getH(MSAState state, int[] delta) {
    int[] pos = state.pos;
    double cost = 0.0f;
        int col = pos[0]; int row = pos[1];
        cost += scoreTable[col][row];
    return weight*cost;
  }
  
  public double getInitH() {
    double cost = 0.0f;
    cost += scoreTable[0][0];
    return weight*cost;
  }
  
  private static final double min(double x, double y, double z) {
    return Math.min(Math.min(x, y), z);
  }
  
  public String toString() {
    StringBuffer sb = new StringBuffer();    
    for (int i=1; i<seqs.length; i++) {
      for (int j=0; j<i; j++) {
        double t[][] = scoreTable;
        for (int x=0; x<t.length; x++) {
          for (int y=0; y<t[x].length; y++) {
            sb.append("["+(int)t[x][y]+"]");
          }
          sb.append("\n");
        }
        sb.append("\n\n\n");
      }
    }    
    return sb.toString();
  }

public int[][][] saturate(int[][][] ops) {
	int[][][] Ops1 = ops;
	System.out.println("m: "+m);
	System.out.println(Ops1.length);
	System.out.println("n: "+n);
	System.out.println(Ops1[n].length);
	for(int npos = n-1;npos>=0;--npos){
		
		Ops1[m][npos][VT] -= 0;
				//scoreTable[1][0][npos][m]- scoreTable[1][0][npos+1][m];
	}
	for(int mpos = m-1;mpos>=0;--mpos){
		Ops1[mpos][n][HZ] -= scoreTable[n][mpos]- scoreTable[n][mpos+1];
	}
	for(int npos = n-1;npos>=0;--npos) {
		for(int mpos = m-1;mpos>=0;--mpos) {
			Ops1[mpos][npos][DG] -= scoreTable[npos][mpos]-scoreTable[npos+1][mpos+1];
			Ops1[mpos][npos][HZ] -= scoreTable[npos][mpos]- scoreTable[npos][mpos+1];
			Ops1[mpos][npos][VT] -= scoreTable[npos][mpos]- scoreTable[npos+1][mpos];
		}
	}
	return Ops1;
	
}

}
