#! /usr/bin/env python
# -*- coding: utf-8 -*-

from Cheetah.Template import Template
import os
import sys

# defines the benchmark that is used for the experiment (must be the name of a
# folder in testbed/benchmarks)
benchmark="ippc-all"

# defines which queue to use for one task. Possible values are
# "athlon.q" and "athlon_core.q". The former value configures the use
# of a whole cpu, while the latter option configures the use of a
# single cpu core.
queue = "all.q@ase*"

# defines the priority of the task. Possible values are [-1023,0], but the
# maximum of 0 should only be used for very urgent jobs.
priority = 0

# defines the timeout for one task. The time format is
# "hours:minutes:seconds", eg, a value of "0:30:00" sets the timeout
# to 30 minutes. If timout is set to None, then there is no timeout.
timeout = None

# defines the maximum amount of available memory for one task. The
# value's format is either "<mem>M" or "<mem>G", where <mem> is an
# integer number, M stands for MByte and G for GByte. If memout is
# None, then there is no memory bound.
memout = None

configs = [
    #"[IPPC2011]",
    #"[IPPC2014]",
    #"[UCT -init [Single -h [RandomWalk]]]",
    #"[MaxUCT -init [Expand -h [MLS]] -rec [MPA]]",
    #"[UCTStar -init [Single -h [Uniform]] -rec [EBA]]",
    "OfflineHeuristic -learnType learnOnly "
]

#####
# Loading config which contains number of epochs and step size
#####

module_name = 'learn-config'

import sys
__import__(module_name)
learn_conf = sys.modules[module_name]
###     

revision = "rev" + learn_conf.revisionNumber + "-store"

host = "localhost"
resultsDir = "results/"+revision+"/"+revision+"_"
numRuns = "30"

TASK_TEMPLATE = "export LD_LIBRARY_PATH=.:$LD_LIBRARY_PATH && " \
"mkdir -p %(resultsDir)s && " \
"./run-server benchmarks/%(benchmark)s/ %(port)s %(numRuns)s > %(resultsDir)s/%(instance)s_server.log 2> %(resultsDir)s/%(instance)s_server.err &" \
" sleep 45 &&" \
" ./prost benchmarks/%(benchmark)s/prost/%(instance)s -p %(port)s [PROST -s 1 -se [%(config)s]] > %(resultsDir)s/%(instance)s.log 2> %(resultsDir)s/%(instance)s.err"

def isInstanceName(fileName):
    return fileName.count("inst") > 0

def create_tasks(filename, instances):
    port = 2000
    tasks = []

    #print len(instances)
    #print instances

    for config in configs:
        for instance in sorted(instances):
            for est in learn_conf.estimateFrom:
                conf = config + est 
                task = TASK_TEMPLATE % dict(config=conf, benchmark=benchmark, instance=instance,
                                            host=host, port=port, numRuns=numRuns,
                                            resultsDir=resultsDir+conf.replace(" ","_"))
                tasks.append(task)
                port = port + 1


    template = Template(file='job.tmpl',
                        searchList=[{'tasks'    : tasks,
                                     'queue'    : queue,
                                     'timeout'  : timeout,
                                     'memout'   : memout,
                                     'priority' : priority}])    
    f = file(filename, 'w')
    f.write(str(template))
    f.close()

if __name__ == '__main__':
    if len(sys.argv) > 1:
        print >> sys.stderr, "Usage: create-jobs.py"
        exit()
    instances = filter(isInstanceName, os.listdir("../testbed/benchmarks/"+benchmark+"/rddl/"))
    instances = [instance.split(".")[0] for instance in instances]
    create_tasks("../testbed/prost-store.q", instances)
