from Wordle import Wordle
from Entropie_finder import Entropie_finder

import time

use_precomputed_feedback = True

wordle_instance = Wordle(use_precomputed_feedback=False)
entropie_finder = Entropie_finder(use_precomputed_feedback=use_precomputed_feedback)

first_guess = "salet"

legal_list = wordle_instance.get_legal_list()
solution_list = wordle_instance.get_solution_list()
current_solution_list = wordle_instance.get_solution_list()
#solution_list = ['audio', 'basic', 'torso']

print("\nSolution words to test: " + str(len(solution_list)) + '\n')


amount_of_guesses = [0] * 8
total_guesses = 0
count_itterations = 0

t0 = time.time()
for solution in solution_list:
    count_itterations +=1
    guess_count = 0
    c = 1
    feedback = None
    current_solution_list = wordle_instance.get_solution_list()
    wordle_instance.start_game(solution)

    while feedback != "ggggg":

        if feedback == "-1":
            guess_count = 7
            break
        if c == 1:
            next_guess = first_guess
            c = 2
        else:
            next_guess = entropie_finder.get_highest_entropie(legal_list, current_solution_list)


        feedback = wordle_instance.make_guess(next_guess)
        guess_count += 1


        if feedback == "ggggg":
            break

        current_solution_list = entropie_finder.filter_word_list(feedback, next_guess, current_solution_list)
    
    amount_of_guesses[guess_count] += 1
    total_guesses += guess_count
    if count_itterations % 100 == 0:
        print("Solution word: " + solution + "    Guesses: " + str(guess_count) + "    Itteration " + str(count_itterations) + " done    " + str(count_itterations/len(solution_list)) + '%')

t1 = time.time()

print("\n\nFinished!")
print("Time: " + str(t1-t0))
print("Frist guess: " + first_guess)
print("Avg number of guesses: " + str(total_guesses/len(solution_list)))
s = []
for i in range(len(amount_of_guesses)):
    s.append(f"{i}:{amount_of_guesses[i]}")
print(s)
with open('test_results_salet.txt', 'w') as file:
    file.write("First guess: " + first_guess + '\n' + "Average guesses: " + str(total_guesses/len(solution_list)) + '\n')
    file.write("Frequencies of results: \n")
    file.write(str(s) + '\n')
    file.write("Time taken: " + str(t1-t0) + '\n' + "Average time taken: " + str((t1-t0)/len(solution_list)) + '\n')
    file.write("Used precomputed feedback: " + str(use_precomputed_feedback) + '\n')

