from Wordle import Wordle
import json
import time

wordle = Wordle(use_precomputed_feedback=False)

def compute_feedback(guess_list: list, solution_list: list):
    feedback_dict = {}

    for guess in guess_list:
        for solution in solution_list:
            feedback = wordle.create_feedback(guess, solution)
            feedback_dict[f"{guess},{solution}"] = feedback # string key for json storage
        #print("next itteration done")
    with open("guess_feedback_test.json", 'w') as file:
        json.dump(feedback_dict, file)

solution_list = wordle.get_solution_list()
guess_list = ["tarse", "crane"]
#guess_list = solution_list
guess_list = wordle.get_legal_list()

t0 = time.time()
compute_feedback(guess_list, solution_list)
t1 = time.time()
print(t1-t0)

        