import random
import json
import pickle
import time
import numpy as np

class Wordle:

    legal_list = None
    solution_list = None
    solution_word = None
    guess_count = 0
    feedback_dict = None
    use_precomputed_feedback = False
    legal_list_path = "../data/legal_list.txt"
    solution_list_path = "../data/solution_list.txt"
    feedback_path_json = "../data/guess_feedback.json"
    feedback_path_pickle = "../data/guess_feedback.pkl"
    word_length = ''

    guess_word_idices = {}
    solution_word_indices = {}

    def __init__(self, solution_word="1", use_precomputed_feedback=True, word_length='S5'):
        self.legal_list = self.read_word_list(self.legal_list_path)
        self.solution_list = self.read_word_list(self.solution_list_path)
        self.word_length = word_length
        print("use precomp: " + str(use_precomputed_feedback))

        if solution_word == "1":  # random solution word
            self.solution_word = random.choice(self.solution_list)
            #print(self.solution_word)
        else:   # given solution word
            self.solution_word = solution_word
        '''
        if use_precomputed_feedback:
            print("load json")
            self.use_precomputed_feedback = True
            self.feedback_dict = {}
            with open(self.feedback_path_json, 'r') as file:
                json_dict = json.load(file)
            for key, value in json_dict.items():
                key_parts = key.split(',')
                key_tuple = tuple(key_parts)

                self.feedback_dict[key_tuple] = value
        '''   
        if use_precomputed_feedback:
            self.use_precomputed_feedback = True
            print("load pickle")
            t0 = time.time()
            with open(self.feedback_path_pickle, "rb") as file:
                self.feedback_dict = pickle.load(file)
            print("loaded pickle: " + str(time.time() - t0))

    def read_word_list(self, input_file_path):
        with open(input_file_path, 'r') as file:
            word_list = file.read().splitlines()
        return word_list
    

    def start_game(self, solution_word: str):
        self.guess_count = 0
        self.solution_word = solution_word
        

    def make_guess(self, guess_word: str) -> str:
        if (self.guess_count >= 5): # to many attempts
            return "-1"
        if not guess_word in self.legal_list: # word not in legal list
            return "-2"
        
        self.guess_count += 1
        return self.create_feedback(guess_word, self.solution_word)

    
    # feedback: b = grey, y = yellow, g = green
    def create_feedback(self, guess_word: str, solution_word: str) -> str:
        if self.use_precomputed_feedback: # use feedback matrix
            return self.feedback_dict[(guess_word, solution_word)]
        else:
            return self.compute_feedback(guess_word, solution_word)
    

    # feedback: b = grey, y = yellow, g = green
    def compute_feedback(self, guess_word: str, solution_word: str) -> str:
        feedback = ['b'] * len(guess_word)

        #print(guess_word)

        guess_char_list = list(guess_word)
        solution_char_list = list(solution_word)

        # green pass
        for i in range(len(guess_char_list)):
            if guess_char_list[i] == solution_char_list[i]:
                feedback[i] = 'g'
                solution_char_list[i] = '0'  # mark used chars

        # yellow pass
        for i in range(len(guess_char_list)):
            if feedback[i] == 'b' and guess_char_list[i] in solution_char_list:
                feedback[i] = 'y'
                solution_char_list[solution_char_list.index(guess_char_list[i])] = '0'

        feedback_str = "".join(feedback)

        return feedback_str


    def get_legal_list(self) -> list:
        return self.legal_list
    
    def get_solution_list(self) -> list:
        return self.solution_list
