from Wordle import Wordle
from collections import Counter
import math
import numpy as np
import time


class Entropie_finder:
    
    wordle = None
    time_entropie = 0
    time_feedback = 0
    time_add_map = 0
    time_add_list = 0
    time_count_feedback = 0
    feedback_dict = {}

    def __init__(self, use_precomputed_feedback=False):
        if use_precomputed_feedback:
            self.wordle = Wordle(use_precomputed_feedback=True)
            self.feedback_dict = self.wordle.feedback_dict
        else:
            self.wordle = Wordle(use_precomputed_feedback=False)

    
    def get_entropie_for_word(self, guess_word: str, solution_list: list) -> float:
        feedbacks = []
        entropie = 0
        probability = 0
        for solution in solution_list:
            t0 = time.time()
            feedback = self.wordle.create_feedback(guess_word, solution)
            #feedback = self.feedback_dict[(guess_word, solution)]
            self.time_add_list += time.time() - t0
            t1 = time.time()
            feedbacks.append(feedback)
            self.time_add_map += time.time() - t1
        
        t2 = time.time()
        coloring_count = Counter(feedbacks)
        t3 = time.time()
        self.time_count_feedback += t3 - t2
        
        for value in coloring_count.values():
            probability = value / len(solution_list)
            entropie += probability * math.log2(1/probability)

        return entropie
    
    

    def get_highest_entropie(self, guess_list: str, solution_list: list) -> str:
        t0 = time.time()
        if len(solution_list) == 1:
            return solution_list[0]

        max_entropie = 0
        best_guess = None

        for guess in guess_list:
            entropie = self.get_entropie_for_word(guess, solution_list)
            
            if entropie > max_entropie:
                max_entropie = entropie
                best_guess = guess

        t1 = time.time()
        self.time_entropie += t1 - t0
        return best_guess

    
    def filter_word_list(self, coloring: str, guess_word: str, solution_list: list) -> list:
        new_word_list = []

        for solution_word in solution_list:
            if self.is_valid_solution(coloring, guess_word, solution_word):
                new_word_list.append(solution_word)

        return new_word_list
    
    
    def is_valid_solution(self, coloring: str, guess_word: str, solution_word: str):

        solution_chars = list(solution_word) # mark used chars
        len_coloring = len(coloring)
        

        for i in range(len_coloring):
            if coloring[i] == 'g':
                if guess_word[i] != solution_chars[i]:
                    return False
                solution_chars[i] = None
        
        for i in range(len_coloring):
            if coloring[i] == 'y':
                if guess_word[i] == solution_chars[i]:
                    return False
                if guess_word[i] not in solution_chars:
                    return False
                first_occurrence_index = solution_chars.index(guess_word[i])
                solution_chars[first_occurrence_index] = None
        

        for i in range(len_coloring):
            if coloring[i] == 'b':
                if guess_word[i] in solution_chars:
                    #guess_count = guess_word.count(guess_word[i])
                    #solution_count = solution_chars.count(guess_word[i])
                    #if guess_count >= solution_count:
                    return False
        
        return True
