package wordle.java;

import java.util.Scanner;

/**
 * Basic class to play a random command line
 * based wordle game for a human player.
 */
public class WordleTest {
    public static void main(String[] args) {
        Wordle wordle = new Wordle("1");
        Scanner scanner = new Scanner(System.in);
        String feedback = "00000";
        int count = 1;

        while (!feedback.equals("ggggg") && count <= 6) {
            System.out.println("Enter guess " + count + ": ");
            String nextGuess = scanner.nextLine();
            feedback = wordle.makeGuess(nextGuess);

            System.out.println("Feedback: ");
            System.out.println(nextGuess);
            System.out.println(feedback);

            count++;
        }

        if (feedback.equals("ggggg")) {
            System.out.println("You won in " + (count - 1) + " guesses!");
        } else {
            System.out.println("You lost.");
        }
        scanner.close();
    }
}
