package wordle.java;

import java.io.BufferedWriter;
import java.io.FileWriter;

/**
 * Used to precompute the feedback matrix for the wordle guesses.
 * Reading from disc is faster than computing the feedbacks each time a test is called.
 * Was used for local testing.
 */
public class StoreFeedbackMatrix {
    public static void main(String[] args) {
        Wordle wordle = new Wordle(1);

        wordle.computeFeedbackMatrixInt();
        int[][] feedbackMatrix = wordle.getFeedbackMatrixInt();

        try (BufferedWriter writer = new BufferedWriter(new FileWriter("./src/wordle/data/feedbackMatrixInt.txt"))) {
            for (int[] row : feedbackMatrix) {
                String line = "";
                for (int num : row) {
                    line += num + " ";
                }
                writer.write(line.trim());
                writer.newLine();
            }
        } catch (Exception e) {
            
        }

    }
 }
