package wordle.java;

import java.util.List;

/**
 * Class used to test wordle algorithms for a single game.
 * Prints single guesses and relevant word lists
 */
public class PlayGame {
    private static Wordle wordle;
    private static WordleGuessFinder finder;

    private static List<String> legalList;
    private static List<String> solutionList;

    private static int guessAmount;
    private static int solutionAmount;


    public static void main(String[] args) {
        //playInt(50000);
        playInt(args[0]);
    }

    /**
     * Uses the integer based version to play a game.
     * Algorithms are switched with comments in the while loop
     */
    public static void playInt(String solution) {
        finder = new WordleGuessFinder(0);
        wordle = new Wordle(-1, finder.wordle.getFeedbackMatrixInt());

        wordle.startGame(wordle.getSolutionWordIntFromString(solution), 0);

        guessAmount = wordle.getLegalWordAmount();
        solutionAmount = wordle.getSolutionWordAmount();

        int[] solutionWords = new int[solutionAmount];
        for (int i = 0; i < solutionWords.length; i++) {
                solutionWords[i] = i;
        }
        long t0 = System.currentTimeMillis();
        int nextGuess = wordle.getGuessWordIntFromString("salet");
        //int nextGuess = finder.getHighestEntropyParallel(guessAmount, solutionWords, 8);
        //int nextGuess = finder.findNextGuessRollout(guessAmount, solutionWords, 0, 100, false);
        //int nextGuess = finder.UCT(0, solutionWords, 0, wordle.getLegalWordAmount(), 50000, true);
        System.out.println("First guess: " + wordle.getGuessWordFromInt(nextGuess));
        int feedback = wordle.makeGuess(nextGuess);
        solutionWords = finder.filterWordList(feedback, nextGuess, solutionWords);
        //feedback = wordle.makeGuess((wordle.getGuessWordIntFromString("thing")));
        //solutionWords = finder.filterWordList(feedback, wordle.getGuessWordIntFromString("thing"), solutionWords);
        int guessCount = 1;
        

        while(feedback != 0) {
            //nextGuess = finder.getHighestEntropyParallel(guessAmount, solutionWords, 8);
            nextGuess = finder.getHighestEntropyParallelTieBraking(guessAmount, solutionWords, 8);
            //nextGuess = finder.findNextGuessRollout(guessAmount, solutionWords, guessCount, 10, true);
            //nextGuess = finder.UCT(nextGuess, solutionWords, guessCount, 10, 5000, true);
            //nextGuess = finder.UCTOptimistic(nextGuess, solutionWords, guessCount, 100000, 20);
            System.out.println("Next Guess: " + wordle.getGuessWordFromInt(nextGuess));
            feedback = wordle.makeGuess(nextGuess);
            System.out.println("Feedback from wordle: " + feedback);
            guessCount++;

            solutionWords = finder.filterWordList(feedback, nextGuess, solutionWords);
            System.out.println("New solutionWords size: " + solutionWords.length);
            if (solutionWords.length <= 10) {
                for (int i = 0; i < solutionWords.length; i++) {
                    System.out.print(wordle.getSolutionWordFromInt(solutionWords[i]) + " ");
                }
                System.out.println("");
            }
            if (guessCount > 10) break;
        }
        
        double time = (System.currentTimeMillis() - t0) / 1000.0;
        System.out.println("Guessamount: " + guessCount);
        System.out.println("Simulated games: " + finder.simulatedGames);
        System.out.println("Time: " + time + "s\n");
        
    }

    /**
     * Uses the integer based version to play a game.
     * Not maintained
     */
    public static void playString() {
        wordle = new Wordle("aback");
        finder = new WordleGuessFinder("aback");

        legalList = wordle.getLegalList();
        solutionList = wordle.getSolutionList();

        //Scanner scanner = new Scanner(System.in);
        //System.out.println("Press enter to start...");
        //scanner.nextLine();
        //scanner.close();

        String feedback = "";
        int guessCount = 0;
        String nextGuess = "";

        int c = 1;

        long time1 = System.currentTimeMillis();
        while (!feedback.equals("ggggg")) {
            if (feedback.equals("-1")) {
                System.out.println("Game lost, guess count: " + guessCount);
                break;
            }

            if (c == 1) {
                nextGuess = "soare";
                c = 2;
            } else {
                nextGuess = finder.getHighestEntropyString(legalList, solutionList);
            }


            feedback = wordle.makeGuess(nextGuess);
            //legalList.remove(nextGuess);
            guessCount++;

            System.out.println("Guess " + guessCount + ": "+ nextGuess);
            System.out.println("Feedback: " + feedback);

            if (feedback.equals("ggggg")) {
                System.out.println("Game won!");
                break;
            }

            solutionList = finder.filterWordList(feedback, nextGuess, solutionList);

            System.out.println("Size solution list: " + solutionList.size());
            if (solutionList.size() < 20) {
                System.out.print("[");
                for (String word : solutionList) {
                    System.out.print(word + ", ");
                }
                System.out.println("]");
            }

        }
        long time2 = System.currentTimeMillis();
        System.out.println("Time: " + (time2-time1)/1000.0 + "s");
        System.out.println("Time key lookup: " + finder.wordle.tt0/1000000000.0 + "s");
        System.out.println("time Feedback retrival: " + finder.feedbackTime/1000000000.0 + "s");
        System.out.println("Time entropy computation: " + finder.tt0/1000000000.0 + "s");
    } 


    /**
     * Basic test to make sure integer and string implementations
     * compute indentical policies
     */
    public static void testCompareIntString(String[] args) {
        Wordle wordleInt = new Wordle(0);
        WordleGuessFinder finderInt = new WordleGuessFinder(0);

        Wordle wordleString = new Wordle("aback");
        WordleGuessFinder finderString = new WordleGuessFinder("aback");

        guessAmount = wordleInt.getLegalWordAmount();
        solutionAmount = wordleInt.getSolutionWordAmount();
        int[] solutionWords = new int[solutionAmount];
        for (int i = 0; i < solutionWords.length; i++) {
            solutionWords[i] = i;
        }
        legalList = wordleString.getLegalList();
        solutionList = wordleString.getSolutionList();

        int feedbackInt = wordleInt.makeGuess(10364);
        String feedbackString = wordleString.makeGuess("soare");
        System.out.println(feedbackInt);
        System.out.println(feedbackString + "\n");
        System.out.println(solutionWords.length);
        System.out.println(solutionList.size() + "\n");

        solutionWords = finderInt.filterWordList(feedbackInt, 10364, solutionWords);
        System.out.println(solutionWords.length);
        solutionList = finderString.filterWordList(feedbackString, "soare", solutionList);
        System.out.println(solutionList.size() + "\n");

        boolean bol = true;
        for (int i = 0; i < solutionWords.length; i++) {
            if (!wordleInt.solutionList.get(solutionWords[i]).equals(solutionList.get(i))) {
                System.out.println("i: " + i + ", Solutionwords: " + wordleInt.solutionList.get(solutionWords[i]) + ", solutionList: " + solutionList.get(i));
                bol = false;
            }
        }
        if (bol) System.out.println("Lits are equal\n");


        int nextGuessInt = finderInt.getHighestEntropy(guessAmount, solutionWords);
        String nextGuessString = finderString.getHighestEntropyString(legalList, solutionList);

        System.out.println("nextguess int: " + wordleInt.legalList.get(nextGuessInt) + ", nextguess String: " + nextGuessString + "\n");;

        feedbackInt = wordleInt.makeGuess(nextGuessInt);
        feedbackString = wordleString.makeGuess(nextGuessString);

        solutionWords = finderInt.filterWordList(feedbackInt, nextGuessInt, solutionWords);
        solutionList = finderString.filterWordList(feedbackString, nextGuessString, solutionList);



        System.out.println(solutionWords.length);
        System.out.println(solutionList.size());

        bol = true;
        for (int i = 0; i < solutionWords.length; i++) {
            if (!wordleInt.solutionList.get(solutionWords[i]).equals(solutionList.get(i))) {
                System.out.println("i: " + i + ", Solutionwords: " + wordleInt.solutionList.get(solutionWords[i]) + ", solutionList: " + solutionList.get(i));
                bol = false;
            }
        }
        if (bol) System.out.println("Lits are equal");


    }
}