package wordle.java;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;

/**
 * Primitive class to test functionality of entropy calculations.
 * Not maintained anymore.
 */
public class EntropyFinderTest {
    private static WordleGuessFinder finder;
    private static Wordle wordle;
    //private static String legalListPath = "./src/wordle/data/legal_list.txt";
    //private static String solutionListPath = "./src/wordle/data/solution_list.txt";
    private static List<String> legalList;
    private static List<String> solutionList;
    // Next two lists from: https://github.com/deedy/wordle-solver
    private static String legalListPath = "./src/wordle/data/official_wordle_all_sorted.txt";
    private static String solutionListPath = "./src/wordle/data/official_wordle_solution_sorted.txt";



    public static void main(String[] args) {
        finder = new WordleGuessFinder();
        wordle = new Wordle(0);

        int solutionAmount = wordle.getSolutionWordAmount();

        int[] solutionWords = new int[solutionAmount];
        for (int i = 0; i < solutionWords.length; i++) {
                solutionWords[i] = i;
        }

    }



    public static void main2(String[] args) {
        finder = new WordleGuessFinder();

        legalList = readWordList(legalListPath);
        solutionList = readWordList(solutionListPath);

        String word = "tarse";

        double entropy = finder.getEntropyForWordString(word, solutionList, solutionList.size());

        long startTime = System.currentTimeMillis();
        String bestWord = finder.getHighestEntropyParallelString(legalList, solutionList, 8);
        double timeEntropy = (double) (System.currentTimeMillis() - startTime) / 1000;

        //System.out.println("Do rollouts");
        // bestWordRollout = finder.findNextGuessRollout(legalList, solutionList, 0);

        List<String> bestGuesses = finder.getHighestEntropyListString(legalList, solutionList, 10);

        for (String guess : bestGuesses) {
            System.out.print(guess + ",  ");
        }
        System.out.println("");

        System.out.println("Entropy for " + word + ": " + entropy);
        System.out.println("Highest entropy word: " + bestWord + ": " + finder.getEntropyForWordString(bestWord, solutionList, solutionList.size()));
        System.out.println("Time for entropy computation: " + timeEntropy);
        //System.out.println("Best word rollout: " + bestWordRollout);

    }

    private static List<String> readWordList(String filePath) {
        try {
            return Files.readAllLines(Paths.get(filePath));
        } catch (IOException e) {
            System.out.println(e);
            return Collections.emptyList();
        }
    }
}
